/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.Platform;
import com.spacekiller.util.workspace.DefaultProject;
import com.spacekiller.util.workspace.DefaultProjectType;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectLoader;
import com.spacekiller.util.workspace.ProjectPersistence;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.ProjectSource;
import com.spacekiller.util.workspace.ProjectType;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.SynchronizedProjectPath;
import com.spacekiller.util.workspace.Workspace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class DefaultProjectLoader
implements ProjectLoader {
    private Workspace workspace;
    private Hashtable hashProjectsByReference = new Hashtable();
    private Vector loadedProjects = new Vector();
    private boolean useExistingWorkspaceProjects = true;
    private boolean useAlreadyLoadedProjects = true;
    private ClassLoader classLoader;
    private ProjectType fallbackProjectType = DefaultProjectType.DEFAULT_PROJECT_TYPE;
    private static final Logger logger = Logger.getLogger(DefaultProjectLoader.class.getName());

    public DefaultProjectLoader(Workspace ws, ClassLoader defaultProjectClassLoader) {
        this.setWorkspace(ws);
        this.setClassLoader(defaultProjectClassLoader);
    }

    protected Project createProject(ProjectType type) throws Exception {
        return type.createProject();
    }

    protected boolean equals(ProjectReference a, Project b) {
        ProjectReference bRef = b.getProjectReference();
        return bRef.equals(a);
    }

    protected boolean equals(ProjectReference a, ProjectReference b) {
        return a.equals(b);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public synchronized Project getProject(ProjectReference reference) throws Exception {
        if (reference == null) {
            return null;
        }
        ProjectReference[] refs = new ProjectReference[]{reference};
        Project[] pro = this.getProjects(refs, 0, 1);
        return pro.length == 1 ? pro[0] : null;
    }

    @Override
    public Project[] getProjects(ProjectReference[] references, int off, int len) throws Exception {
        Project[] projects = new Project[len];
        ArrayList<ProjectReference> loadReferences = new ArrayList<ProjectReference>();
        for (int i = 0; i < len; ++i) {
            ProjectReference reference = references[off + i];
            if (reference == null) {
                projects[i] = null;
                continue;
            }
            Project project = null;
            if (this.isUseExistingWorkspaceProjects()) {
                Iterator it;
                Workspace ws = this.getWorkspace();
                if (ws != null && (it = ws.iterator()) != null) {
                    while (it.hasNext()) {
                        Project refPro;
                        Object o = it.next();
                        if (o == null || !(o instanceof Project) || !this.equals(reference, refPro = (Project)o)) continue;
                        project = refPro;
                        break;
                    }
                }
                if (project != null) {
                    projects[i] = project;
                    continue;
                }
            }
            if (this.isUseAlreadyLoadedProjects()) {
                Enumeration en = this.hashProjectsByReference.keys();
                while (en.hasMoreElements()) {
                    ProjectReference ref = (ProjectReference)en.nextElement();
                    if (!this.equals(ref, reference)) continue;
                    project = (Project)this.hashProjectsByReference.get(ref);
                    break;
                }
                if (project != null) {
                    projects[i] = project;
                    continue;
                }
            }
            projects[i] = null;
            loadReferences.add(reference);
        }
        if (!loadReferences.isEmpty()) {
            Project[] loadedProjects = this.loadProjects(loadReferences.iterator());
            int x = 0;
            for (int i = 0; i < loadedProjects.length; ++i) {
                Project pro = loadedProjects[i];
                if (pro == null) continue;
                ProjectReference proRef = (ProjectReference)loadReferences.get(i);
                this.hashProjectsByReference.put(proRef, pro);
                while (x < len) {
                    if (references[off + x] == proRef) {
                        projects[x] = pro;
                        ++x;
                        break;
                    }
                    ++x;
                }
                Platform.getInstance().debugReference((Object)pro);
            }
        }
        return projects;
    }

    protected ClassLoader getProjectClassLoader(ProjectReference reference) throws Exception {
        return this.getClassLoader();
    }

    protected ProjectType getProjectType(ProjectReference reference) throws Exception {
        String typeName = reference.getProjectTypeName();
        ProjectType rc = null;
        if (typeName != null) {
            rc = this.getWorkspace().getProjectType(typeName);
        }
        return rc;
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    protected void installProjects(Project[] projects) {
        Workspace ws = this.getWorkspace();
        if (ws == null) {
            return;
        }
        logger.fine(" - installing project(s) into workspace: " + ws);
        for (int i = 0; i < projects.length; ++i) {
            Project project = projects[i];
            if (project == null) continue;
            this.loadedProjects.add(project);
            if (ws.add(project)) continue;
            if (ws.contains(project)) {
                logger.fine("Warning: Project already loaded: " + project);
                continue;
            }
            throw new RuntimeException("Unable to install project into workspace: " + project);
        }
    }

    protected boolean isUseAlreadyLoadedProjects() {
        return this.useAlreadyLoadedProjects;
    }

    protected boolean isUseExistingWorkspaceProjects() {
        return this.useExistingWorkspaceProjects;
    }

    protected Project[] loadProjects(Iterator references) throws Exception {
        ProjectReference ref;
        ArrayList<ProjectReference> refs = new ArrayList<ProjectReference>();
        while (references.hasNext()) {
            ref = (ProjectReference)references.next();
            refs.add(ref);
        }
        int num = refs.size();
        Project[] projects = new Project[num];
        SyncManager sync = this.workspace.getSyncManager();
        ArrayList<ProjectReference> syncLoadRefs = new ArrayList<ProjectReference>();
        for (int i = 0; i < num; ++i) {
            ref = (ProjectReference)refs.get(i);
            String projectName = ref.getProjectName();
            Object projectPath = ref.getProjectPath();
            if (projectPath == null) {
                logger.fine("Creating project: " + ref);
                String projectTypeName = ref.getProjectTypeName();
                if (projectTypeName == null) {
                    throw new NullPointerException("projectTypeName");
                }
                ProjectType projectType = this.workspace.getProjectType(projectTypeName);
                if (projectType == null) {
                    throw new Exception("Project type not found: " + projectTypeName);
                }
                Project project = projectType.createProject();
                if (project == null) {
                    throw new Exception("Unable to create project of type: " + projectType);
                }
                if (project instanceof DefaultProject) {
                    DefaultProject ap = (DefaultProject)project;
                    ap.setName(projectName);
                }
                projects[i] = project;
                continue;
            }
            logger.fine("Loading project: " + ref);
            if (projectPath instanceof SynchronizedProjectPath) {
                syncLoadRefs.add(ref);
                continue;
            }
            ProjectSource source = this.workspace.getProjectSource(ref);
            if (source == null) {
                throw new Exception("Reference not supported: " + ref);
            }
            ProjectPersistence[] persistences = source.openProjects(ref);
            if (persistences == null) {
                return null;
            }
            int count = persistences.length;
            if (count < 1) {
                return null;
            }
            Project[] pros = new Project[count];
            for (int c = 0; c < count; ++c) {
                Project project;
                Object obj;
                ProjectPersistence pp = persistences[c];
                if (pp == null || (obj = pp.getProject()) == null) continue;
                if (obj instanceof Project) {
                    Project resolved;
                    project = (Project)obj;
                    String projectTypeName = project.getProjectTypeName();
                    logger.fine("Project: " + project + " >> Type: " + projectTypeName);
                    ProjectType projectType = this.workspace.getProjectType(projectTypeName);
                    if (projectType != null && (resolved = projectType.resolveProject(pp)) != null) {
                        pros[c] = resolved;
                        continue;
                    }
                    logger.fine("Warning: Project-Type not found: " + projectTypeName);
                }
                project = this.fallbackProjectType.createProject();
                project.add(obj);
                pros[c] = project;
            }
            Project rc = null;
            for (int c = 0; c < count; ++c) {
                Project pro = pros[c];
                if (pro == null) continue;
                logger.fine("Installing project: " + pro);
                if (rc == null) {
                    rc = pro;
                    continue;
                }
                this.installProjects(new Project[]{pro});
            }
            projects[i] = rc;
        }
        if (!syncLoadRefs.isEmpty()) {
            ProjectReference[] loadRefs = syncLoadRefs.toArray(new ProjectReference[syncLoadRefs.size()]);
            int numLoad = loadRefs.length;
            Object[] loadPros = sync.getProjects(loadRefs);
            int x = 0;
            block4: for (int i = 0; i < numLoad; ++i) {
                ProjectReference r = loadRefs[i];
                Object proObj = loadPros[i];
                if (proObj == null) {
                    logger.fine("WARNING: project not loaded: " + r);
                    continue;
                }
                Project pro = null;
                if (proObj instanceof Project) {
                    pro = (Project)proObj;
                } else {
                    pro = this.fallbackProjectType.createProject();
                    pro.add(proObj);
                    proObj = pro;
                }
                if (pro != null && pro instanceof DefaultProject) {
                    ((DefaultProject)pro).setProjectPath(r.getProjectPath());
                }
                while (x < num) {
                    ProjectReference pr = (ProjectReference)refs.get(x);
                    if (pr == r) {
                        projects[x] = pro;
                        ++x;
                        continue block4;
                    }
                    ++x;
                }
            }
        }
        this.installProjects(projects);
        return projects;
    }

    protected void setClassLoader(ClassLoader newClassLoader) {
        this.classLoader = newClassLoader;
    }

    protected void setUseAlreadyLoadedProjects(boolean newUseAlreadyLoadedProjects) {
        this.useAlreadyLoadedProjects = newUseAlreadyLoadedProjects;
    }

    protected void setUseExistingWorkspaceProjects(boolean newUseExistingWorkspaceProjects) {
        this.useExistingWorkspaceProjects = newUseExistingWorkspaceProjects;
    }

    protected void setWorkspace(Workspace newWorkspace) {
        this.workspace = newWorkspace;
    }
}

