/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.Platform;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.ProjectSource;
import com.spacekiller.util.workspace.ProjectType;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.TransactionListener;
import com.spacekiller.util.workspace.TransactionSavepoint;
import com.spacekiller.util.workspace.Workspace;
import java.beans.beancontext.BeanContextServicesSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWorkspace
extends BeanContextServicesSupport
implements Workspace {
    private static final long serialVersionUID = 1899459913543775738L;
    private String name = "Default workspace";
    private SyncManager syncManager;
    private List vProjectTypes = new ArrayList();
    private Map hProjectTypes = new HashMap();
    private List projectSources = new ArrayList();
    private TransHandler transHandler = new TransHandler();
    private TransactionListener[] transListeners = new TransactionListener[0];
    private boolean committed = true;
    private static final Logger logger = Logger.getLogger(DefaultWorkspace.class.getName());

    @Override
    public void addProjectType(ProjectType type) {
        this.insertProjectTypeAt(type, this.getProjectTypeCount());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void getPersistentBeans(Collection dstBeans) {
    }

    @Override
    public ProjectType getProjectType(String projectType) {
        return (ProjectType)this.hProjectTypes.get(projectType);
    }

    @Override
    public ProjectType getProjectTypeAt(int i) {
        return (ProjectType)this.vProjectTypes.get(i);
    }

    @Override
    public int getProjectTypeCount() {
        return this.vProjectTypes.size();
    }

    @Override
    public int getProjectTypeIndex(ProjectType type) {
        return this.vProjectTypes.indexOf(type);
    }

    public void insertProjectTypeAt(ProjectType type, int i) {
        if (type == null) {
            return;
        }
        this.vProjectTypes.add(i, type);
        this.hProjectTypes.put(type.getName(), type);
    }

    @Override
    public void removeProjectType(ProjectType type) {
        if (type == null) {
            return;
        }
        this.vProjectTypes.remove(type);
        this.hProjectTypes.remove(type.getName());
    }

    public void removeProjectTypeAt(int i) {
        this.removeProjectType(this.getProjectTypeAt(i));
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String toString() {
        return String.valueOf(this.getName());
    }

    @Override
    public ProjectSource getProjectSourceAt(int i) {
        return (ProjectSource)this.projectSources.get(i);
    }

    @Override
    public int getProjectSourceCount() {
        return this.projectSources.size();
    }

    @Override
    public int getProjectSourceIndex(ProjectSource ps) {
        return this.projectSources.indexOf(ps);
    }

    @Override
    public void addProjectSource(ProjectSource ps) {
        if (ps != null && !this.projectSources.contains(ps)) {
            this.projectSources.add(ps);
        }
    }

    @Override
    public void removeProjectSource(ProjectSource ps) {
        this.projectSources.remove(ps);
    }

    public void removeProjectSourceAt(int i) {
        this.projectSources.remove(i);
    }

    @Override
    public ProjectSource getProjectSource(ProjectReference ref) {
        for (ProjectSource src : this.projectSources) {
            if (src == null || !src.supportsOpenProject(ref) || !src.supportsSaveProject(ref)) continue;
            return src;
        }
        return null;
    }

    @Override
    public SyncManager getSyncManager() {
        return this.syncManager;
    }

    protected synchronized void setSyncManager(SyncManager newSynchronizer) {
        if (this.syncManager == newSynchronizer) {
            return;
        }
        if (this.syncManager != null) {
            this.syncManager.removeTransactionListener(this.transHandler);
        }
        this.syncManager = newSynchronizer;
        if (this.syncManager != null) {
            this.syncManager.addTransactionListener(this.transHandler);
            try {
                this.committed = this.syncManager.isCommitted();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (newSynchronizer != null) {
            Platform.getInstance().debugReference((Object)newSynchronizer);
        }
    }

    @Override
    public boolean add(Object targetChild) {
        SyncManager sync;
        if (targetChild == null) {
            return false;
        }
        if (!(targetChild instanceof Project)) {
            return false;
        }
        Project project = (Project)targetChild;
        boolean ok = super.add(project);
        if (ok && (sync = this.getSyncManager()) != null) {
            try {
                Object key = project.getProjectId();
                sync.addProject(key, project);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ok;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean remove(Object targetChild) {
        if (targetChild == null) {
            return false;
        }
        if (!(targetChild instanceof Project)) {
            return false;
        }
        Project project = (Project)targetChild;
        return super.remove(project);
    }

    @Override
    public boolean delete(Project project) throws Exception {
        if (!this.remove(project)) {
            return false;
        }
        SyncManager sync = this.getSyncManager();
        if (sync != null) {
            try {
                Object key = project.getProjectId();
                sync.removeProject(key);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public void close() {
        Iterator<Object> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.setSyncManager(null);
        this.vProjectTypes = null;
        this.transListeners = null;
        this.projectSources = null;
        this.hProjectTypes = null;
    }

    @Override
    public synchronized void addTransactionListener(TransactionListener l) {
        if (this.hasTransactionListener(l)) {
            return;
        }
        TransactionListener[] oldArray = this.transListeners;
        int oldCount = oldArray.length;
        int newCount = oldCount + 1;
        TransactionListener[] newArray = new TransactionListener[newCount];
        System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        newArray[oldCount] = l;
        this.transListeners = newArray;
    }

    @Override
    public synchronized void removeTransactionListener(TransactionListener l) {
        TransactionListener[] arr = this.transListeners;
        int n = arr.length;
        int index = -1;
        for (int i = 0; i < n; ++i) {
            if (arr[i] != l) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        int oldCount = arr.length;
        int newCount = oldCount - 1;
        TransactionListener[] newArray = new TransactionListener[newCount];
        System.arraycopy(arr, 0, newArray, 0, index);
        System.arraycopy(arr, index + 1, newArray, index, oldCount - index - 1);
        this.transListeners = newArray;
    }

    @Override
    public boolean hasTransactionListener(TransactionListener l) {
        TransactionListener[] arr = this.transListeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            if (arr[i] != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected class TransHandler
    implements TransactionListener {
        protected TransHandler() {
        }

        @Override
        public void transactionBegin(TransactionSavepoint sp) {
            DefaultWorkspace.this.committed = false;
            TransactionListener[] arr = DefaultWorkspace.this.transListeners;
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                arr[i].transactionBegin(sp);
            }
        }

        @Override
        public void transactionCommit(TransactionSavepoint sp) {
            try {
                DefaultWorkspace.this.committed = DefaultWorkspace.this.syncManager.isCommitted();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TransactionListener[] arr = DefaultWorkspace.this.transListeners;
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                arr[i].transactionCommit(sp);
            }
        }

        @Override
        public void transactionRollback(TransactionSavepoint sp) {
            try {
                DefaultWorkspace.this.committed = DefaultWorkspace.this.syncManager.isCommitted();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TransactionListener[] arr = DefaultWorkspace.this.transListeners;
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                arr[i].transactionRollback(sp);
            }
        }

        @Override
        public void transactionSavepoint(TransactionSavepoint sp) {
            try {
                DefaultWorkspace.this.committed = DefaultWorkspace.this.syncManager.isCommitted();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TransactionListener[] arr = DefaultWorkspace.this.transListeners;
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                arr[i].transactionSavepoint(sp);
            }
        }

        @Override
        public void transactionRemoveSavepoint(TransactionSavepoint sp) {
            try {
                DefaultWorkspace.this.committed = DefaultWorkspace.this.syncManager.isCommitted();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TransactionListener[] arr = DefaultWorkspace.this.transListeners;
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                arr[i].transactionRemoveSavepoint(sp);
            }
        }
    }
}

