/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.FileType;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DefaultBeansToolkit;
import com.spacekiller.util.beans.TypeMapping;
import com.spacekiller.util.crypto.CipherManager;
import com.spacekiller.util.workspace.ProjectSource;
import com.spacekiller.util.workspace.ProjectType;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.WorkspacePlugin;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWorkspacePlugin
extends Plugin
implements WorkspacePlugin {
    public static final String EXTENSION_DEFAULT_BEANSTOOLKIT = "DefaultBeansToolkit";
    public static final String EXTENSION_DEFAULT_BEANCLIPBOARD = "DefaultBeanClipboard";
    private static final Logger logger = Logger.getLogger(DefaultWorkspacePlugin.class.getName());
    private List extensions = new ArrayList();
    private ClassRegistry classRegistry;
    private BeansToolkit beansToolkit;
    private CipherManager cipherManager;
    private BeanContext projectSources;
    private BeanContext projectTypes;
    private BeanContext fileTypes;
    private BeanContext propertyEditors;
    private BeanContext customizers;
    private BeanContext syncManagers;

    protected BeansToolkit lookupBeansToolkit() throws Exception {
        return Platform.getInstance().getBeansToolkit();
    }

    @Override
    public BeansToolkit getBeansToolkit() throws Exception {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(this.lookupBeansToolkit());
        }
        return this.beansToolkit;
    }

    protected void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    @Override
    public ClipboardManager getClipboardManager() throws Exception {
        BeansToolkit btk = this.getBeansToolkit();
        if (btk != null && btk instanceof AbstractBeansToolkit) {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)btk;
            return abt.getClipboardManager();
        }
        return null;
    }

    @Override
    public BeanDropSupport getBeanDropSupport() throws Exception {
        BeansToolkit btk = this.getBeansToolkit();
        if (btk != null && btk instanceof AbstractBeansToolkit) {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)btk;
            return abt.getBeanDropSupport();
        }
        return null;
    }

    private CipherManager createCipherManager() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.crypto.CipherManager");
        logger.fine("CipherManager-Extensions: " + x.length);
        if (x.length > 0) {
            return (CipherManager)this.getExtensionInstance(x[0]);
        }
        return null;
    }

    @Override
    public CipherManager getCipherManager() throws Exception {
        if (this.cipherManager == null) {
            this.setCipherManager(this.createCipherManager());
        }
        return this.cipherManager;
    }

    protected void setCipherManager(CipherManager cipherManager) {
        this.cipherManager = cipherManager;
    }

    protected ClassRegistry lookupClassRegistry() {
        return this.getPlatform().getClassRegistry();
    }

    @Override
    public ClassRegistry getClassRegistry() {
        if (this.classRegistry == null) {
            this.setClassRegistry(this.lookupClassRegistry());
        }
        return this.classRegistry;
    }

    protected void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    protected Object createExtensionInstance(Extension extension) throws Exception {
        if (extension.getId().equals(EXTENSION_DEFAULT_BEANSTOOLKIT)) {
            return new DefaultBeansToolkit(this.getClassRegistry());
        }
        return super.createExtensionInstance(extension);
    }

    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        this.extensions.add(x);
        String pid = point.getId();
        try {
            if (pid.equals("com.spacekiller.util.beans.customizer")) {
                return;
            }
            if (pid.equals("com.spacekiller.util.beans.propertyeditor")) {
                return;
            }
            if (pid.equals("com.spacekiller.util.workspace.ProjectType")) {
                ProjectType obj;
                if (this.projectTypes != null && (obj = this.createProjectType(x)) != null) {
                    this.projectTypes.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.beans.FileType")) {
                FileType obj;
                if (this.fileTypes != null && (obj = this.createFileType(x)) != null) {
                    this.fileTypes.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.workspace.ProjectSource")) {
                ProjectSource obj;
                if (this.projectSources != null && (obj = this.createProjectSource(x)) != null) {
                    this.projectSources.add(obj);
                }
                return;
            }
            if (pid.equals("com.spacekiller.util.crypto.CipherManager")) {
                return;
            }
            if (pid.equals("com.spacekiller.util.workspace.SyncManager")) {
                SyncManager obj;
                if (this.syncManagers != null && (obj = this.createSyncManager(x)) != null) {
                    this.syncManagers.add(obj);
                }
                return;
            }
            logger.warning("Unsupported extension available: point=" + pid + ", extension=" + x);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void extensionUnavailable(ExtensionPoint point, Extension x) {
        logger.fine("TODO WorkspacePlugin.Extension unavailable: " + x);
        if (this.extensions.remove(x)) {
            // empty if block
        }
    }

    protected Extension[] getExtensions(String pointId) {
        ArrayList<Extension> list = new ArrayList<Extension>();
        int num = this.extensions.size();
        for (int c = 0; c < num; ++c) {
            Extension ext = (Extension)this.extensions.get(c);
            String pid = ext.getExtensionPointId();
            if (pid == null || !pointId.equals(pid)) continue;
            list.add(ext);
        }
        Extension[] rc = new Extension[list.size()];
        rc = list.toArray(rc);
        return rc;
    }

    @Override
    public BeanContext getFileTypes() throws Exception {
        if (this.fileTypes == null) {
            this.setFileTypes(new BeanContextSupport());
            this.initFileTypes();
        }
        return this.fileTypes;
    }

    protected void setFileTypes(BeanContext fileTypes) {
        this.fileTypes = fileTypes;
    }

    @Override
    public BeanContext getProjectSources() throws Exception {
        if (this.projectSources == null) {
            this.setProjectSources(new BeanContextSupport());
            this.initProjectSources();
        }
        return this.projectSources;
    }

    protected void setProjectSources(BeanContext projectSources) {
        this.projectSources = projectSources;
    }

    @Override
    public BeanContext getProjectTypes() throws Exception {
        if (this.projectTypes == null) {
            this.setProjectTypes(new BeanContextSupport());
            this.initProjectTypes();
        }
        return this.projectTypes;
    }

    protected void setProjectTypes(BeanContext projectTypes) {
        this.projectTypes = projectTypes;
    }

    protected void initFileTypes() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.beans.FileType");
        for (int c = 0; c < x.length; ++c) {
            FileType obj = this.createFileType(x[c]);
            if (obj == null) continue;
            this.fileTypes.add(obj);
        }
    }

    protected void initProjectTypes() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workspace.ProjectType");
        for (int c = 0; c < x.length; ++c) {
            ProjectType obj = this.createProjectType(x[c]);
            if (obj == null) continue;
            this.projectTypes.add(obj);
        }
    }

    protected void initProjectSources() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workspace.ProjectSource");
        for (int c = 0; c < x.length; ++c) {
            ProjectSource obj = this.createProjectSource(x[c]);
            if (obj == null) continue;
            this.projectSources.add(obj);
        }
    }

    protected FileType createFileType(Extension x) throws Exception {
        return (FileType)this.getExtensionInstance(x);
    }

    protected ProjectType createProjectType(Extension x) throws Exception {
        return (ProjectType)this.getExtensionInstance(x);
    }

    protected ProjectSource createProjectSource(Extension x) throws Exception {
        return (ProjectSource)this.getExtensionInstance(x);
    }

    @Override
    public BeanContext getCustomizers() throws Exception {
        if (this.customizers == null) {
            this.setCustomizers(new BeanContextSupport());
            this.initCustomizers();
        }
        return this.customizers;
    }

    protected void setCustomizers(BeanContext customizers) {
        this.customizers = customizers;
    }

    protected void initCustomizers() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.beans.customizer");
        for (int c = 0; c < x.length; ++c) {
            TypeMapping obj = this.createTypeMapping(x[c]);
            if (obj == null) continue;
            this.customizers.add(obj);
        }
    }

    @Override
    public BeanContext getPropertyEditors() throws Exception {
        if (this.propertyEditors == null) {
            this.setPropertyEditors(new BeanContextSupport());
            this.initPropertyEditors();
        }
        return this.propertyEditors;
    }

    protected void setPropertyEditors(BeanContext propertyEditors) {
        this.propertyEditors = propertyEditors;
    }

    protected void initPropertyEditors() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.beans.propertyeditor");
        for (int c = 0; c < x.length; ++c) {
            TypeMapping obj = this.createTypeMapping(x[c]);
            if (obj == null) continue;
            this.propertyEditors.add(obj);
        }
    }

    protected TypeMapping createTypeMapping(Extension x) throws Exception {
        return (TypeMapping)this.getExtensionInstance(x);
    }

    @Override
    public BeanContext getSyncManagers() throws Exception {
        if (this.syncManagers == null) {
            this.setSyncManagers(new BeanContextSupport());
            this.initSyncManagers();
        }
        return this.syncManagers;
    }

    protected void setSyncManagers(BeanContext syncManagers) {
        this.syncManagers = syncManagers;
    }

    protected void initSyncManagers() throws Exception {
        Extension[] x = this.getExtensions("com.spacekiller.util.workspace.SyncManager");
        for (int c = 0; c < x.length; ++c) {
            SyncManager obj = this.createSyncManager(x[c]);
            if (obj == null) continue;
            this.syncManagers.add(obj);
        }
    }

    protected SyncManager createSyncManager(Extension x) throws Exception {
        return (SyncManager)this.getExtensionInstance(x);
    }
}

