/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.Tools;
import com.spacekiller.util.workspace.AbstractProjectSource;
import com.spacekiller.util.workspace.DefaultProjectPersistence;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectPersistence;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.SerializedFileOpenPropertyEditor;
import com.spacekiller.util.workspace.SerializedFileProjectPath;
import com.spacekiller.util.workspace.SerializedFileSavePropertyEditor;
import java.beans.PropertyEditor;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Icon;

public class SerializedFileProjectSource
extends AbstractProjectSource {
    private static final Logger logger = Logger.getLogger(SerializedFileProjectSource.class.getName());

    public SerializedFileProjectSource(String name, String tooltip, Icon icon) {
        super(name);
        this.setTooltip(tooltip);
        this.setIcon(icon);
    }

    public SerializedFileProjectSource() {
        super("Serialized File");
        this.setTooltip("Serialized objects in file (*.ser)");
        this.setIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/beans/icons/serialized_file.gif"));
    }

    @Override
    public PropertyEditor createOpenProjectPropertyEditor() throws Exception {
        return new SerializedFileOpenPropertyEditor();
    }

    @Override
    public PropertyEditor createSaveProjectPropertyEditor() throws Exception {
        return new SerializedFileSavePropertyEditor();
    }

    protected File getProjectFile(ProjectReference reference) {
        SerializedFileProjectPath pp;
        String filePath;
        Object path;
        if (reference != null && (path = reference.getProjectPath()) != null && path instanceof SerializedFileProjectPath && (filePath = (pp = (SerializedFileProjectPath)path).getFilePath()) != null) {
            return new File(filePath);
        }
        return null;
    }

    @Override
    public boolean supportsOpenProject(ProjectReference reference) {
        return this.getProjectFile(reference) != null;
    }

    @Override
    public boolean supportsSaveProject(ProjectReference reference) {
        return this.getProjectFile(reference) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProjects(ProjectReference reference, ProjectPersistence[] projects) throws Exception {
        File file = this.getProjectFile(reference);
        if (file == null) {
            throw new Exception("Invalid project path: " + file);
        }
        if (file.exists()) {
            // empty if block
        }
        OutputStream out = this.createOutputStream(file);
        try {
            ObjectOutputStream objout = new ObjectOutputStream(out);
            this.writeProjects(projects, objout);
            objout.flush();
        }
        finally {
            out.close();
        }
    }

    protected OutputStream createOutputStream(File file) throws Exception {
        return new FileOutputStream(file);
    }

    protected void writeProjects(ProjectPersistence[] projects, ObjectOutput out) throws Exception {
        int count = projects.length;
        for (int i = 0; i < count; ++i) {
            this.writeProject(projects[i], out);
        }
    }

    protected void writeProject(ProjectPersistence persistence, ObjectOutput out) throws Exception {
        Object project = persistence.getProject();
        if (project == null) {
            throw new NullPointerException("project==null");
        }
        logger.fine("Writing project: " + project + ", typeName=" + ((Project)project).getProjectTypeName());
        out.writeObject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectPersistence[] openProjects(ProjectReference reference) throws Exception {
        File file = this.getProjectFile(reference);
        if (file == null) {
            throw new Exception("Project not found: " + reference);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        InputStream in = this.createInputStream(file);
        try {
            ProjectPersistence[] projects;
            ObjectInputStream objin = new ObjectInputStream(in);
            ProjectPersistence[] projectPersistenceArray = projects = this.readProjects(objin);
            return projectPersistenceArray;
        }
        finally {
            in.close();
        }
    }

    protected InputStream createInputStream(File file) throws Exception {
        return new FileInputStream(file);
    }

    protected ProjectPersistence[] readProjects(ObjectInput in) throws Exception {
        ArrayList<ProjectPersistence> projects = new ArrayList<ProjectPersistence>();
        try {
            while (true) {
                ProjectPersistence pp;
                if ((pp = this.readProject(in)) == null) {
                    continue;
                }
                projects.add(pp);
            }
        }
        catch (EOFException eof) {
            int count = projects.size();
            if (count < 1) {
                return null;
            }
            ProjectPersistence[] rc = new ProjectPersistence[count];
            rc = projects.toArray(rc);
            return rc;
        }
    }

    protected ProjectPersistence readProject(ObjectInput in) throws Exception {
        Object project = in.readObject();
        DefaultProjectPersistence pp = new DefaultProjectPersistence();
        pp.setProject(project);
        return pp;
    }
}

