/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import com.bene.media.sound.AudioFloatConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public abstract class AudioFloatInputStream {
    public static AudioFloatInputStream getInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return new DirectAudioFloatInputStream(AudioSystem.getAudioInputStream(url));
    }

    public static AudioFloatInputStream getInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return new DirectAudioFloatInputStream(AudioSystem.getAudioInputStream(file));
    }

    public static AudioFloatInputStream getInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return new DirectAudioFloatInputStream(AudioSystem.getAudioInputStream(stream));
    }

    public static AudioFloatInputStream getInputStream(AudioInputStream stream) {
        return new DirectAudioFloatInputStream(stream);
    }

    public static AudioFloatInputStream getInputStream(AudioFormat format, byte[] buffer, int offset, int len) {
        AudioFloatConverter converter = AudioFloatConverter.getConverter(format);
        if (converter != null) {
            return new BytaArrayAudioFloatInputStream(converter, buffer, offset, len);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer, offset, len);
        long aLen = format.getFrameSize() == -1 ? -1L : (long)(len / format.getFrameSize());
        AudioInputStream astream = new AudioInputStream(stream, format, aLen);
        return AudioFloatInputStream.getInputStream(astream);
    }

    public abstract AudioFormat getFormat();

    public abstract long getFrameLength();

    public abstract int read(float[] var1, int var2, int var3) throws IOException;

    public final int read(float[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final float read() throws IOException {
        float[] b = new float[1];
        int ret = this.read(b, 0, 1);
        if (ret == -1 || ret == 0) {
            return 0.0f;
        }
        return b[0];
    }

    public abstract long skip(long var1) throws IOException;

    public abstract int available() throws IOException;

    public abstract void close() throws IOException;

    public abstract void mark(int var1);

    public abstract boolean markSupported();

    public abstract void reset() throws IOException;

    private static class DirectAudioFloatInputStream
    extends AudioFloatInputStream {
        private final AudioInputStream stream;
        private AudioFloatConverter converter;
        private final int framesize_pc;
        private byte[] buffer;

        DirectAudioFloatInputStream(AudioInputStream stream) {
            this.converter = AudioFloatConverter.getConverter(stream.getFormat());
            if (this.converter == null) {
                AudioFormat newformat;
                AudioFormat format = stream.getFormat();
                AudioFormat[] formats = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, format);
                if (formats.length != 0) {
                    newformat = formats[0];
                } else {
                    float samplerate = format.getSampleRate();
                    int samplesizeinbits = format.getSampleSizeInBits();
                    int framesize = format.getFrameSize();
                    float framerate = format.getFrameRate();
                    samplesizeinbits = 16;
                    framesize = format.getChannels() * (samplesizeinbits / 8);
                    framerate = samplerate;
                    newformat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, samplerate, samplesizeinbits, format.getChannels(), framesize, framerate, false);
                }
                stream = AudioSystem.getAudioInputStream(newformat, stream);
                this.converter = AudioFloatConverter.getConverter(stream.getFormat());
            }
            this.framesize_pc = stream.getFormat().getFrameSize() / stream.getFormat().getChannels();
            this.stream = stream;
        }

        @Override
        public AudioFormat getFormat() {
            return this.stream.getFormat();
        }

        @Override
        public long getFrameLength() {
            return this.stream.getFrameLength();
        }

        @Override
        public int read(float[] b, int off, int len) throws IOException {
            int ret;
            int b_len = len * this.framesize_pc;
            if (this.buffer == null || this.buffer.length < b_len) {
                this.buffer = new byte[b_len];
            }
            if ((ret = this.stream.read(this.buffer, 0, b_len)) == -1) {
                return -1;
            }
            this.converter.toFloatArray(this.buffer, b, off, ret / this.framesize_pc);
            return ret / this.framesize_pc;
        }

        @Override
        public long skip(long len) throws IOException {
            long b_len = len * (long)this.framesize_pc;
            long ret = this.stream.skip(b_len);
            if (ret == -1L) {
                return -1L;
            }
            return ret / (long)this.framesize_pc;
        }

        @Override
        public int available() throws IOException {
            return this.stream.available() / this.framesize_pc;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.stream.mark(readlimit * this.framesize_pc);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }
    }

    private static class BytaArrayAudioFloatInputStream
    extends AudioFloatInputStream {
        private int pos = 0;
        private int markpos = 0;
        private final AudioFloatConverter converter;
        private final AudioFormat format;
        private final byte[] buffer;
        private final int buffer_offset;
        private final int buffer_len;
        private final int framesize_pc;

        BytaArrayAudioFloatInputStream(AudioFloatConverter converter, byte[] buffer, int offset, int len) {
            this.converter = converter;
            this.format = converter.getFormat();
            this.buffer = buffer;
            this.buffer_offset = offset;
            this.framesize_pc = this.format.getFrameSize() / this.format.getChannels();
            this.buffer_len = len / this.framesize_pc;
        }

        @Override
        public AudioFormat getFormat() {
            return this.format;
        }

        @Override
        public long getFrameLength() {
            return this.buffer_len;
        }

        @Override
        public int read(float[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (this.pos >= this.buffer_len) {
                return -1;
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos + len > this.buffer_len) {
                len = this.buffer_len - this.pos;
            }
            this.converter.toFloatArray(this.buffer, this.buffer_offset + this.pos * this.framesize_pc, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public long skip(long len) throws IOException {
            if (this.pos >= this.buffer_len) {
                return -1L;
            }
            if (len <= 0L) {
                return 0L;
            }
            if ((long)this.pos + len > (long)this.buffer_len) {
                len = this.buffer_len - this.pos;
            }
            this.pos = (int)((long)this.pos + len);
            return len;
        }

        @Override
        public int available() throws IOException {
            return this.buffer_len - this.pos;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int readlimit) {
            this.markpos = this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void reset() throws IOException {
            this.pos = this.markpos;
        }
    }
}

