/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import com.bene.media.sound.DLSInfo;
import com.bene.media.sound.DLSModulator;
import com.bene.media.sound.DLSRegion;
import com.bene.media.sound.DLSSample;
import com.bene.media.sound.DLSSampleLoop;
import com.bene.media.sound.DLSSampleOptions;
import com.bene.media.sound.DLSSoundbank;
import com.bene.media.sound.ModelByteBuffer;
import com.bene.media.sound.ModelByteBufferWavetable;
import com.bene.media.sound.ModelConnectionBlock;
import com.bene.media.sound.ModelDestination;
import com.bene.media.sound.ModelIdentifier;
import com.bene.media.sound.ModelInstrument;
import com.bene.media.sound.ModelPatch;
import com.bene.media.sound.ModelPerformer;
import com.bene.media.sound.ModelSource;
import com.bene.media.sound.ModelStandardTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.sound.midi.Patch;

public final class DLSInstrument
extends ModelInstrument {
    int preset = 0;
    int bank = 0;
    boolean druminstrument = false;
    byte[] guid = null;
    DLSInfo info = new DLSInfo();
    List<DLSRegion> regions = new ArrayList<DLSRegion>();
    List<DLSModulator> modulators = new ArrayList<DLSModulator>();

    public DLSInstrument() {
        super(null, null, null, null);
    }

    public DLSInstrument(DLSSoundbank soundbank) {
        super(soundbank, null, null, null);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    public void setName(String name) {
        this.info.name = name;
    }

    @Override
    public ModelPatch getPatch() {
        return new ModelPatch(this.bank, this.preset, this.druminstrument);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.druminstrument = true;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        } else {
            this.druminstrument = false;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        }
    }

    @Override
    public Object getData() {
        return null;
    }

    public List<DLSRegion> getRegions() {
        return this.regions;
    }

    public List<DLSModulator> getModulators() {
        return this.modulators;
    }

    public String toString() {
        if (this.druminstrument) {
            return "Drumkit: " + this.info.name + " bank #" + this.bank + " preset #" + this.preset;
        }
        return "Instrument: " + this.info.name + " bank #" + this.bank + " preset #" + this.preset;
    }

    private ModelIdentifier convertToModelDest(int dest) {
        if (dest == 0) {
            return null;
        }
        if (dest == 1) {
            return ModelDestination.DESTINATION_GAIN;
        }
        if (dest == 3) {
            return ModelDestination.DESTINATION_PITCH;
        }
        if (dest == 4) {
            return ModelDestination.DESTINATION_PAN;
        }
        if (dest == 260) {
            return ModelDestination.DESTINATION_LFO1_FREQ;
        }
        if (dest == 261) {
            return ModelDestination.DESTINATION_LFO1_DELAY;
        }
        if (dest == 518) {
            return ModelDestination.DESTINATION_EG1_ATTACK;
        }
        if (dest == 519) {
            return ModelDestination.DESTINATION_EG1_DECAY;
        }
        if (dest == 521) {
            return ModelDestination.DESTINATION_EG1_RELEASE;
        }
        if (dest == 522) {
            return ModelDestination.DESTINATION_EG1_SUSTAIN;
        }
        if (dest == 778) {
            return ModelDestination.DESTINATION_EG2_ATTACK;
        }
        if (dest == 779) {
            return ModelDestination.DESTINATION_EG2_DECAY;
        }
        if (dest == 781) {
            return ModelDestination.DESTINATION_EG2_RELEASE;
        }
        if (dest == 782) {
            return ModelDestination.DESTINATION_EG2_SUSTAIN;
        }
        if (dest == 5) {
            return ModelDestination.DESTINATION_KEYNUMBER;
        }
        if (dest == 128) {
            return ModelDestination.DESTINATION_CHORUS;
        }
        if (dest == 129) {
            return ModelDestination.DESTINATION_REVERB;
        }
        if (dest == 276) {
            return ModelDestination.DESTINATION_LFO2_FREQ;
        }
        if (dest == 277) {
            return ModelDestination.DESTINATION_LFO2_DELAY;
        }
        if (dest == 523) {
            return ModelDestination.DESTINATION_EG1_DELAY;
        }
        if (dest == 524) {
            return ModelDestination.DESTINATION_EG1_HOLD;
        }
        if (dest == 525) {
            return ModelDestination.DESTINATION_EG1_SHUTDOWN;
        }
        if (dest == 783) {
            return ModelDestination.DESTINATION_EG2_DELAY;
        }
        if (dest == 784) {
            return ModelDestination.DESTINATION_EG2_HOLD;
        }
        if (dest == 1280) {
            return ModelDestination.DESTINATION_FILTER_FREQ;
        }
        if (dest == 1281) {
            return ModelDestination.DESTINATION_FILTER_Q;
        }
        return null;
    }

    private ModelIdentifier convertToModelSrc(int src) {
        if (src == 0) {
            return null;
        }
        if (src == 1) {
            return ModelSource.SOURCE_LFO1;
        }
        if (src == 2) {
            return ModelSource.SOURCE_NOTEON_VELOCITY;
        }
        if (src == 3) {
            return ModelSource.SOURCE_NOTEON_KEYNUMBER;
        }
        if (src == 4) {
            return ModelSource.SOURCE_EG1;
        }
        if (src == 5) {
            return ModelSource.SOURCE_EG2;
        }
        if (src == 6) {
            return ModelSource.SOURCE_MIDI_PITCH;
        }
        if (src == 129) {
            return new ModelIdentifier("midi_cc", "1", 0);
        }
        if (src == 135) {
            return new ModelIdentifier("midi_cc", "7", 0);
        }
        if (src == 138) {
            return new ModelIdentifier("midi_cc", "10", 0);
        }
        if (src == 139) {
            return new ModelIdentifier("midi_cc", "11", 0);
        }
        if (src == 256) {
            return new ModelIdentifier("midi_rpn", "0", 0);
        }
        if (src == 257) {
            return new ModelIdentifier("midi_rpn", "1", 0);
        }
        if (src == 7) {
            return ModelSource.SOURCE_MIDI_POLY_PRESSURE;
        }
        if (src == 8) {
            return ModelSource.SOURCE_MIDI_CHANNEL_PRESSURE;
        }
        if (src == 9) {
            return ModelSource.SOURCE_LFO2;
        }
        if (src == 10) {
            return ModelSource.SOURCE_MIDI_CHANNEL_PRESSURE;
        }
        if (src == 219) {
            return new ModelIdentifier("midi_cc", "91", 0);
        }
        if (src == 221) {
            return new ModelIdentifier("midi_cc", "93", 0);
        }
        return null;
    }

    private ModelConnectionBlock convertToModel(DLSModulator mod) {
        ModelIdentifier source = this.convertToModelSrc(mod.getSource());
        ModelIdentifier control = this.convertToModelSrc(mod.getControl());
        ModelIdentifier destination_id = this.convertToModelDest(mod.getDestination());
        int scale = mod.getScale();
        double f_scale = scale == Integer.MIN_VALUE ? Double.NEGATIVE_INFINITY : (double)scale / 65536.0;
        if (destination_id != null) {
            ModelSource s;
            ModelSource src = null;
            ModelSource ctrl = null;
            ModelConnectionBlock block = new ModelConnectionBlock();
            if (control != null) {
                s = new ModelSource();
                if (control == ModelSource.SOURCE_MIDI_PITCH) {
                    ((ModelStandardTransform)s.getTransform()).setPolarity(true);
                } else if (control == ModelSource.SOURCE_LFO1 || control == ModelSource.SOURCE_LFO2) {
                    ((ModelStandardTransform)s.getTransform()).setPolarity(true);
                }
                s.setIdentifier(control);
                block.addSource(s);
                ctrl = s;
            }
            if (source != null) {
                s = new ModelSource();
                if (source == ModelSource.SOURCE_MIDI_PITCH) {
                    ((ModelStandardTransform)s.getTransform()).setPolarity(true);
                } else if (source == ModelSource.SOURCE_LFO1 || source == ModelSource.SOURCE_LFO2) {
                    ((ModelStandardTransform)s.getTransform()).setPolarity(true);
                }
                s.setIdentifier(source);
                block.addSource(s);
                src = s;
            }
            ModelDestination destination = new ModelDestination();
            destination.setIdentifier(destination_id);
            block.setDestination(destination);
            if (mod.getVersion() == 1) {
                if (mod.getTransform() == 1) {
                    if (src != null) {
                        ((ModelStandardTransform)src.getTransform()).setTransform(1);
                        ((ModelStandardTransform)src.getTransform()).setDirection(true);
                    }
                    if (ctrl != null) {
                        ((ModelStandardTransform)ctrl.getTransform()).setTransform(1);
                        ((ModelStandardTransform)ctrl.getTransform()).setDirection(true);
                    }
                }
            } else if (mod.getVersion() == 2) {
                int trans;
                int transform = mod.getTransform();
                int src_transform_invert = transform >> 15 & 1;
                int src_transform_bipolar = transform >> 14 & 1;
                int src_transform = transform >> 10 & 8;
                int ctr_transform_invert = transform >> 9 & 1;
                int ctr_transform_bipolar = transform >> 8 & 1;
                int ctr_transform = transform >> 4 & 8;
                if (src != null) {
                    trans = 0;
                    if (src_transform == 3) {
                        trans = 3;
                    }
                    if (src_transform == 1) {
                        trans = 1;
                    }
                    if (src_transform == 2) {
                        trans = 2;
                    }
                    ((ModelStandardTransform)src.getTransform()).setTransform(trans);
                    ((ModelStandardTransform)src.getTransform()).setPolarity(src_transform_bipolar == 1);
                    ((ModelStandardTransform)src.getTransform()).setDirection(src_transform_invert == 1);
                }
                if (ctrl != null) {
                    trans = 0;
                    if (ctr_transform == 3) {
                        trans = 3;
                    }
                    if (ctr_transform == 1) {
                        trans = 1;
                    }
                    if (ctr_transform == 2) {
                        trans = 2;
                    }
                    ((ModelStandardTransform)ctrl.getTransform()).setTransform(trans);
                    ((ModelStandardTransform)ctrl.getTransform()).setPolarity(ctr_transform_bipolar == 1);
                    ((ModelStandardTransform)ctrl.getTransform()).setDirection(ctr_transform_invert == 1);
                }
            }
            block.setScale(f_scale);
            return block;
        }
        return null;
    }

    @Override
    public ModelPerformer[] getPerformers() {
        ArrayList<ModelPerformer> performers = new ArrayList<ModelPerformer>();
        HashMap<String, DLSModulator> modmap = new HashMap<String, DLSModulator>();
        for (DLSModulator mod : this.getModulators()) {
            modmap.put(mod.getSource() + "x" + mod.getControl() + "=" + mod.getDestination(), mod);
        }
        HashMap<String, DLSModulator> insmodmap = new HashMap<String, DLSModulator>();
        for (DLSRegion zone : this.regions) {
            ModelPerformer performer = new ModelPerformer();
            performer.setName(zone.getSample().getName());
            performer.setSelfNonExclusive((zone.getFusoptions() & 1) != 0);
            performer.setExclusiveClass(zone.getExclusiveClass());
            performer.setKeyFrom(zone.getKeyfrom());
            performer.setKeyTo(zone.getKeyto());
            performer.setVelFrom(zone.getVelfrom());
            performer.setVelTo(zone.getVelto());
            insmodmap.clear();
            insmodmap.putAll(modmap);
            for (DLSModulator mod : zone.getModulators()) {
                insmodmap.put(mod.getSource() + "x" + mod.getControl() + "=" + mod.getDestination(), mod);
            }
            List<ModelConnectionBlock> blocks = performer.getConnectionBlocks();
            for (DLSModulator mod : insmodmap.values()) {
                ModelConnectionBlock p = this.convertToModel(mod);
                if (p == null) continue;
                blocks.add(p);
            }
            DLSSample sample = zone.getSample();
            DLSSampleOptions sampleopt = zone.getSampleoptions();
            if (sampleopt == null) {
                sampleopt = sample.getSampleoptions();
            }
            ModelByteBuffer buff = sample.getDataBuffer();
            float pitchcorrection = -sampleopt.unitynote * 100 + sampleopt.finetune;
            ModelByteBufferWavetable osc = new ModelByteBufferWavetable(buff, sample.getFormat(), pitchcorrection);
            osc.setAttenuation(osc.getAttenuation() / 65536.0f);
            if (sampleopt.getLoops().size() != 0) {
                DLSSampleLoop loop = sampleopt.getLoops().get(0);
                osc.setLoopStart((int)loop.getStart());
                osc.setLoopLength((int)loop.getLength());
                if (loop.getType() == 0L) {
                    osc.setLoopType(1);
                }
                if (loop.getType() == 1L) {
                    osc.setLoopType(2);
                } else {
                    osc.setLoopType(1);
                }
            }
            performer.getConnectionBlocks().add(new ModelConnectionBlock(1.0, new ModelDestination(new ModelIdentifier("filter", "type", 1))));
            performer.getOscillators().add(osc);
            performers.add(performer);
        }
        return performers.toArray(new ModelPerformer[performers.size()]);
    }

    public byte[] getGuid() {
        return this.guid == null ? null : Arrays.copyOf(this.guid, this.guid.length);
    }

    public void setGuid(byte[] guid) {
        this.guid = guid == null ? null : Arrays.copyOf(guid, guid.length);
    }
}

