/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import com.bene.media.sound.AudioFloatConverter;
import com.bene.media.sound.FFT;
import com.bene.media.sound.ModelPatch;
import com.bene.media.sound.SF2GlobalRegion;
import com.bene.media.sound.SF2Instrument;
import com.bene.media.sound.SF2InstrumentRegion;
import com.bene.media.sound.SF2Layer;
import com.bene.media.sound.SF2LayerRegion;
import com.bene.media.sound.SF2Region;
import com.bene.media.sound.SF2Sample;
import com.bene.media.sound.SF2Soundbank;
import java.util.Random;
import javax.sound.midi.Patch;
import javax.sound.sampled.AudioFormat;

public final class EmergencySoundbank {
    private static final String[] general_midi_instruments = new String[]{"Acoustic Grand Piano", "Bright Acoustic Piano", "Electric Grand Piano", "Honky-tonk Piano", "Electric Piano 1", "Electric Piano 2", "Harpsichord", "Clavi", "Celesta", "Glockenspiel", "Music Box", "Vibraphone", "Marimba", "Xylophone", "Tubular Bells", "Dulcimer", "Drawbar Organ", "Percussive Organ", "Rock Organ", "Church Organ", "Reed Organ", "Accordion", "Harmonica", "Tango Accordion", "Acoustic Guitar (nylon)", "Acoustic Guitar (steel)", "Electric Guitar (jazz)", "Electric Guitar (clean)", "Electric Guitar (muted)", "Overdriven Guitar", "Distortion Guitar", "Guitar harmonics", "Acoustic Bass", "Electric Bass (finger)", "Electric Bass (pick)", "Fretless Bass", "Slap Bass 1", "Slap Bass 2", "Synth Bass 1", "Synth Bass 2", "Violin", "Viola", "Cello", "Contrabass", "Tremolo Strings", "Pizzicato Strings", "Orchestral Harp", "Timpani", "String Ensemble 1", "String Ensemble 2", "SynthStrings 1", "SynthStrings 2", "Choir Aahs", "Voice Oohs", "Synth Voice", "Orchestra Hit", "Trumpet", "Trombone", "Tuba", "Muted Trumpet", "French Horn", "Brass Section", "SynthBrass 1", "SynthBrass 2", "Soprano Sax", "Alto Sax", "Tenor Sax", "Baritone Sax", "Oboe", "English Horn", "Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder", "Pan Flute", "Blown Bottle", "Shakuhachi", "Whistle", "Ocarina", "Lead 1 (square)", "Lead 2 (sawtooth)", "Lead 3 (calliope)", "Lead 4 (chiff)", "Lead 5 (charang)", "Lead 6 (voice)", "Lead 7 (fifths)", "Lead 8 (bass + lead)", "Pad 1 (new age)", "Pad 2 (warm)", "Pad 3 (polysynth)", "Pad 4 (choir)", "Pad 5 (bowed)", "Pad 6 (metallic)", "Pad 7 (halo)", "Pad 8 (sweep)", "FX 1 (rain)", "FX 2 (soundtrack)", "FX 3 (crystal)", "FX 4 (atmosphere)", "FX 5 (brightness)", "FX 6 (goblins)", "FX 7 (echoes)", "FX 8 (sci-fi)", "Sitar", "Banjo", "Shamisen", "Koto", "Kalimba", "Bag pipe", "Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums", "Woodblock", "Taiko Drum", "Melodic Tom", "Synth Drum", "Reverse Cymbal", "Guitar Fret Noise", "Breath Noise", "Seashore", "Bird Tweet", "Telephone Ring", "Helicopter", "Applause", "Gunshot"};

    public static SF2Soundbank createSoundbank() throws Exception {
        SF2Soundbank sf2 = new SF2Soundbank();
        sf2.setName("Emergency GM sound set");
        sf2.setVendor("Generated");
        sf2.setDescription("Emergency generated soundbank");
        SF2Layer bass_drum = EmergencySoundbank.new_bass_drum(sf2);
        SF2Layer snare_drum = EmergencySoundbank.new_snare_drum(sf2);
        SF2Layer tom = EmergencySoundbank.new_tom(sf2);
        SF2Layer open_hihat = EmergencySoundbank.new_open_hihat(sf2);
        SF2Layer closed_hihat = EmergencySoundbank.new_closed_hihat(sf2);
        SF2Layer crash_cymbal = EmergencySoundbank.new_crash_cymbal(sf2);
        SF2Layer side_stick = EmergencySoundbank.new_side_stick(sf2);
        SF2Layer[] drums = new SF2Layer[128];
        drums[35] = bass_drum;
        drums[36] = bass_drum;
        drums[38] = snare_drum;
        drums[40] = snare_drum;
        drums[41] = tom;
        drums[43] = tom;
        drums[45] = tom;
        drums[47] = tom;
        drums[48] = tom;
        drums[50] = tom;
        drums[42] = closed_hihat;
        drums[44] = closed_hihat;
        drums[46] = open_hihat;
        drums[49] = crash_cymbal;
        drums[51] = crash_cymbal;
        drums[52] = crash_cymbal;
        drums[55] = crash_cymbal;
        drums[57] = crash_cymbal;
        drums[59] = crash_cymbal;
        drums[37] = side_stick;
        drums[39] = side_stick;
        drums[53] = side_stick;
        drums[54] = side_stick;
        drums[56] = side_stick;
        drums[58] = side_stick;
        drums[69] = side_stick;
        drums[70] = side_stick;
        drums[75] = side_stick;
        drums[60] = side_stick;
        drums[61] = side_stick;
        drums[62] = side_stick;
        drums[63] = side_stick;
        drums[64] = side_stick;
        drums[65] = side_stick;
        drums[66] = side_stick;
        drums[67] = side_stick;
        drums[68] = side_stick;
        drums[71] = side_stick;
        drums[72] = side_stick;
        drums[73] = side_stick;
        drums[74] = side_stick;
        drums[76] = side_stick;
        drums[77] = side_stick;
        drums[78] = side_stick;
        drums[79] = side_stick;
        drums[80] = side_stick;
        drums[81] = side_stick;
        SF2Instrument drum_instrument = new SF2Instrument(sf2);
        drum_instrument.setName("Standard Kit");
        drum_instrument.setPatch(new ModelPatch(0, 0, true));
        sf2.addInstrument(drum_instrument);
        for (int i = 0; i < drums.length; ++i) {
            if (drums[i] == null) continue;
            SF2InstrumentRegion region = new SF2InstrumentRegion();
            region.setLayer(drums[i]);
            region.putBytes(43, new byte[]{(byte)i, (byte)i});
            drum_instrument.getRegions().add(region);
        }
        SF2Layer gpiano = EmergencySoundbank.new_gpiano(sf2);
        SF2Layer gpiano2 = EmergencySoundbank.new_gpiano2(sf2);
        SF2Layer gpiano_hammer = EmergencySoundbank.new_piano_hammer(sf2);
        SF2Layer piano1 = EmergencySoundbank.new_piano1(sf2);
        SF2Layer epiano1 = EmergencySoundbank.new_epiano1(sf2);
        SF2Layer epiano2 = EmergencySoundbank.new_epiano2(sf2);
        SF2Layer guitar = EmergencySoundbank.new_guitar1(sf2);
        SF2Layer guitar_pick = EmergencySoundbank.new_guitar_pick(sf2);
        SF2Layer guitar_dist = EmergencySoundbank.new_guitar_dist(sf2);
        SF2Layer bass1 = EmergencySoundbank.new_bass1(sf2);
        SF2Layer bass2 = EmergencySoundbank.new_bass2(sf2);
        SF2Layer synthbass = EmergencySoundbank.new_synthbass(sf2);
        SF2Layer string2 = EmergencySoundbank.new_string2(sf2);
        SF2Layer orchhit = EmergencySoundbank.new_orchhit(sf2);
        SF2Layer choir = EmergencySoundbank.new_choir(sf2);
        SF2Layer solostring = EmergencySoundbank.new_solostring(sf2);
        SF2Layer organ = EmergencySoundbank.new_organ(sf2);
        SF2Layer ch_organ = EmergencySoundbank.new_ch_organ(sf2);
        SF2Layer bell = EmergencySoundbank.new_bell(sf2);
        SF2Layer flute = EmergencySoundbank.new_flute(sf2);
        SF2Layer timpani = EmergencySoundbank.new_timpani(sf2);
        SF2Layer melodic_toms = EmergencySoundbank.new_melodic_toms(sf2);
        SF2Layer trumpet = EmergencySoundbank.new_trumpet(sf2);
        SF2Layer trombone = EmergencySoundbank.new_trombone(sf2);
        SF2Layer brass_section = EmergencySoundbank.new_brass_section(sf2);
        SF2Layer horn = EmergencySoundbank.new_horn(sf2);
        SF2Layer sax = EmergencySoundbank.new_sax(sf2);
        SF2Layer oboe = EmergencySoundbank.new_oboe(sf2);
        SF2Layer bassoon = EmergencySoundbank.new_bassoon(sf2);
        SF2Layer clarinet = EmergencySoundbank.new_clarinet(sf2);
        SF2Layer reverse_cymbal = EmergencySoundbank.new_reverse_cymbal(sf2);
        SF2Layer defaultsound = piano1;
        EmergencySoundbank.newInstrument(sf2, "Piano", new Patch(0, 0), gpiano, gpiano_hammer);
        EmergencySoundbank.newInstrument(sf2, "Piano", new Patch(0, 1), gpiano2, gpiano_hammer);
        EmergencySoundbank.newInstrument(sf2, "Piano", new Patch(0, 2), piano1);
        SF2Instrument ins = EmergencySoundbank.newInstrument(sf2, "Honky-tonk Piano", new Patch(0, 3), piano1, piano1);
        SF2InstrumentRegion region = ins.getRegions().get(0);
        region.putInteger(8, 80);
        region.putInteger(52, 30);
        region = ins.getRegions().get(1);
        region.putInteger(8, 30);
        EmergencySoundbank.newInstrument(sf2, "Rhodes", new Patch(0, 4), epiano2);
        EmergencySoundbank.newInstrument(sf2, "Rhodes", new Patch(0, 5), epiano2);
        EmergencySoundbank.newInstrument(sf2, "Clavinet", new Patch(0, 6), epiano1);
        EmergencySoundbank.newInstrument(sf2, "Clavinet", new Patch(0, 7), epiano1);
        EmergencySoundbank.newInstrument(sf2, "Rhodes", new Patch(0, 8), epiano2);
        EmergencySoundbank.newInstrument(sf2, "Bell", new Patch(0, 9), bell);
        EmergencySoundbank.newInstrument(sf2, "Bell", new Patch(0, 10), bell);
        EmergencySoundbank.newInstrument(sf2, "Vibraphone", new Patch(0, 11), bell);
        EmergencySoundbank.newInstrument(sf2, "Marimba", new Patch(0, 12), bell);
        EmergencySoundbank.newInstrument(sf2, "Marimba", new Patch(0, 13), bell);
        EmergencySoundbank.newInstrument(sf2, "Bell", new Patch(0, 14), bell);
        EmergencySoundbank.newInstrument(sf2, "Rock Organ", new Patch(0, 15), organ);
        EmergencySoundbank.newInstrument(sf2, "Rock Organ", new Patch(0, 16), organ);
        EmergencySoundbank.newInstrument(sf2, "Perc Organ", new Patch(0, 17), organ);
        EmergencySoundbank.newInstrument(sf2, "Rock Organ", new Patch(0, 18), organ);
        EmergencySoundbank.newInstrument(sf2, "Church Organ", new Patch(0, 19), ch_organ);
        EmergencySoundbank.newInstrument(sf2, "Accordion", new Patch(0, 20), organ);
        EmergencySoundbank.newInstrument(sf2, "Accordion", new Patch(0, 21), organ);
        EmergencySoundbank.newInstrument(sf2, "Accordion", new Patch(0, 22), organ);
        EmergencySoundbank.newInstrument(sf2, "Accordion", new Patch(0, 23), organ);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 24), guitar, guitar_pick);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 25), guitar, guitar_pick);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 26), guitar, guitar_pick);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 27), guitar, guitar_pick);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 28), guitar, guitar_pick);
        EmergencySoundbank.newInstrument(sf2, "Distorted Guitar", new Patch(0, 29), guitar_dist);
        EmergencySoundbank.newInstrument(sf2, "Distorted Guitar", new Patch(0, 30), guitar_dist);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 31), guitar, guitar_pick);
        EmergencySoundbank.newInstrument(sf2, "Finger Bass", new Patch(0, 32), bass1);
        EmergencySoundbank.newInstrument(sf2, "Finger Bass", new Patch(0, 33), bass1);
        EmergencySoundbank.newInstrument(sf2, "Finger Bass", new Patch(0, 34), bass1);
        EmergencySoundbank.newInstrument(sf2, "Frettless Bass", new Patch(0, 35), bass2);
        EmergencySoundbank.newInstrument(sf2, "Frettless Bass", new Patch(0, 36), bass2);
        EmergencySoundbank.newInstrument(sf2, "Frettless Bass", new Patch(0, 37), bass2);
        EmergencySoundbank.newInstrument(sf2, "Synth Bass1", new Patch(0, 38), synthbass);
        EmergencySoundbank.newInstrument(sf2, "Synth Bass2", new Patch(0, 39), synthbass);
        EmergencySoundbank.newInstrument(sf2, "Solo String", new Patch(0, 40), string2, solostring);
        EmergencySoundbank.newInstrument(sf2, "Solo String", new Patch(0, 41), string2, solostring);
        EmergencySoundbank.newInstrument(sf2, "Solo String", new Patch(0, 42), string2, solostring);
        EmergencySoundbank.newInstrument(sf2, "Solo String", new Patch(0, 43), string2, solostring);
        EmergencySoundbank.newInstrument(sf2, "Solo String", new Patch(0, 44), string2, solostring);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 45), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Harp", new Patch(0, 46), bell);
        EmergencySoundbank.newInstrument(sf2, "Timpani", new Patch(0, 47), timpani);
        EmergencySoundbank.newInstrument(sf2, "Strings", new Patch(0, 48), string2);
        SF2Instrument slow_strings = EmergencySoundbank.newInstrument(sf2, "Slow Strings", new Patch(0, 49), string2);
        region = slow_strings.getRegions().get(0);
        region.putInteger(34, 2500);
        region.putInteger(38, 2000);
        EmergencySoundbank.newInstrument(sf2, "Synth Strings", new Patch(0, 50), string2);
        EmergencySoundbank.newInstrument(sf2, "Synth Strings", new Patch(0, 51), string2);
        EmergencySoundbank.newInstrument(sf2, "Choir", new Patch(0, 52), choir);
        EmergencySoundbank.newInstrument(sf2, "Choir", new Patch(0, 53), choir);
        EmergencySoundbank.newInstrument(sf2, "Choir", new Patch(0, 54), choir);
        SF2Instrument ins2 = EmergencySoundbank.newInstrument(sf2, "Orch Hit", new Patch(0, 55), orchhit, orchhit, timpani);
        region = ins2.getRegions().get(0);
        region.putInteger(51, -12);
        region.putInteger(48, -100);
        EmergencySoundbank.newInstrument(sf2, "Trumpet", new Patch(0, 56), trumpet);
        EmergencySoundbank.newInstrument(sf2, "Trombone", new Patch(0, 57), trombone);
        EmergencySoundbank.newInstrument(sf2, "Trombone", new Patch(0, 58), trombone);
        EmergencySoundbank.newInstrument(sf2, "Trumpet", new Patch(0, 59), trumpet);
        EmergencySoundbank.newInstrument(sf2, "Horn", new Patch(0, 60), horn);
        EmergencySoundbank.newInstrument(sf2, "Brass Section", new Patch(0, 61), brass_section);
        EmergencySoundbank.newInstrument(sf2, "Brass Section", new Patch(0, 62), brass_section);
        EmergencySoundbank.newInstrument(sf2, "Brass Section", new Patch(0, 63), brass_section);
        EmergencySoundbank.newInstrument(sf2, "Sax", new Patch(0, 64), sax);
        EmergencySoundbank.newInstrument(sf2, "Sax", new Patch(0, 65), sax);
        EmergencySoundbank.newInstrument(sf2, "Sax", new Patch(0, 66), sax);
        EmergencySoundbank.newInstrument(sf2, "Sax", new Patch(0, 67), sax);
        EmergencySoundbank.newInstrument(sf2, "Oboe", new Patch(0, 68), oboe);
        EmergencySoundbank.newInstrument(sf2, "Horn", new Patch(0, 69), horn);
        EmergencySoundbank.newInstrument(sf2, "Bassoon", new Patch(0, 70), bassoon);
        EmergencySoundbank.newInstrument(sf2, "Clarinet", new Patch(0, 71), clarinet);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 72), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 73), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 74), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 75), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 76), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 77), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 78), flute);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 79), flute);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 80), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 81), organ);
        EmergencySoundbank.newInstrument(sf2, "Flute", new Patch(0, 82), flute);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 83), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 84), organ);
        EmergencySoundbank.newInstrument(sf2, "Choir", new Patch(0, 85), choir);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 86), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 87), organ);
        EmergencySoundbank.newInstrument(sf2, "Synth Strings", new Patch(0, 88), string2);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 89), organ);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 90), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Choir", new Patch(0, 91), choir);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 92), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 93), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 94), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 95), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 96), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 97), organ);
        EmergencySoundbank.newInstrument(sf2, "Bell", new Patch(0, 98), bell);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 99), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 100), organ);
        EmergencySoundbank.newInstrument(sf2, "Organ", new Patch(0, 101), organ);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 102), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Synth Strings", new Patch(0, 103), string2);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 104), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 105), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 106), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 107), defaultsound);
        EmergencySoundbank.newInstrument(sf2, "Marimba", new Patch(0, 108), bell);
        EmergencySoundbank.newInstrument(sf2, "Sax", new Patch(0, 109), sax);
        EmergencySoundbank.newInstrument(sf2, "Solo String", new Patch(0, 110), string2, solostring);
        EmergencySoundbank.newInstrument(sf2, "Oboe", new Patch(0, 111), oboe);
        EmergencySoundbank.newInstrument(sf2, "Bell", new Patch(0, 112), bell);
        EmergencySoundbank.newInstrument(sf2, "Melodic Toms", new Patch(0, 113), melodic_toms);
        EmergencySoundbank.newInstrument(sf2, "Marimba", new Patch(0, 114), bell);
        EmergencySoundbank.newInstrument(sf2, "Melodic Toms", new Patch(0, 115), melodic_toms);
        EmergencySoundbank.newInstrument(sf2, "Melodic Toms", new Patch(0, 116), melodic_toms);
        EmergencySoundbank.newInstrument(sf2, "Melodic Toms", new Patch(0, 117), melodic_toms);
        EmergencySoundbank.newInstrument(sf2, "Reverse Cymbal", new Patch(0, 118), reverse_cymbal);
        EmergencySoundbank.newInstrument(sf2, "Reverse Cymbal", new Patch(0, 119), reverse_cymbal);
        EmergencySoundbank.newInstrument(sf2, "Guitar", new Patch(0, 120), guitar);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 121), defaultsound);
        ins2 = EmergencySoundbank.newInstrument(sf2, "Seashore/Reverse Cymbal", new Patch(0, 122), reverse_cymbal);
        region = ins2.getRegions().get(0);
        region.putInteger(37, 1000);
        region.putInteger(36, 18500);
        region.putInteger(38, 4500);
        region.putInteger(8, -4500);
        ins2 = EmergencySoundbank.newInstrument(sf2, "Bird/Flute", new Patch(0, 123), flute);
        region = ins2.getRegions().get(0);
        region.putInteger(51, 24);
        region.putInteger(36, -3000);
        region.putInteger(37, 1000);
        EmergencySoundbank.newInstrument(sf2, "Def", new Patch(0, 124), side_stick);
        ins2 = EmergencySoundbank.newInstrument(sf2, "Seashore/Reverse Cymbal", new Patch(0, 125), reverse_cymbal);
        region = ins2.getRegions().get(0);
        region.putInteger(37, 1000);
        region.putInteger(36, 18500);
        region.putInteger(38, 4500);
        region.putInteger(8, -4500);
        EmergencySoundbank.newInstrument(sf2, "Applause/crash_cymbal", new Patch(0, 126), crash_cymbal);
        EmergencySoundbank.newInstrument(sf2, "Gunshot/side_stick", new Patch(0, 127), side_stick);
        for (SF2Instrument instrument : sf2.getInstruments()) {
            Patch patch = instrument.getPatch();
            if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) continue;
            instrument.setName(general_midi_instruments[patch.getProgram()]);
        }
        return sf2;
    }

    public static SF2Layer new_bell(SF2Soundbank sf2) {
        Random random = new Random(102030201L);
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.01;
        double end_w = 0.05;
        double start_a = 0.2;
        double end_a = 1.0E-5;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            double detune = 1.0 + (random.nextDouble() * 2.0 - 1.0) * 0.01;
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1) * detune, w, a);
            a *= a_step;
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "EPiano", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "EPiano", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, 1200);
        region.putInteger(30, 12000);
        region.putInteger(11, -9000);
        region.putInteger(8, 16000);
        return layer;
    }

    public static SF2Layer new_guitar1(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.01;
        double end_w = 0.01;
        double start_a = 2.0;
        double end_a = 0.01;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        double[] aa = new double[40];
        for (i = 0; i < 40; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = 2.0;
        aa[1] = 0.5;
        aa[2] = 0.45;
        aa[3] = 0.2;
        aa[4] = 1.0;
        aa[5] = 0.5;
        aa[6] = 2.0;
        aa[7] = 1.0;
        aa[8] = 0.5;
        aa[9] = 1.0;
        aa[9] = 0.5;
        aa[10] = 0.2;
        aa[11] = 1.0;
        aa[12] = 0.7;
        aa[13] = 0.5;
        aa[14] = 1.0;
        for (i = 0; i < 40; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Guitar", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Guitar", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 2400);
        region.putInteger(37, 1000);
        region.putInteger(26, -100);
        region.putInteger(30, 12000);
        region.putInteger(11, -6000);
        region.putInteger(8, 16000);
        region.putInteger(48, -20);
        return layer;
    }

    public static SF2Layer new_guitar_dist(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.01;
        double end_w = 0.01;
        double start_a = 2.0;
        double end_a = 0.01;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        double[] aa = new double[40];
        for (i = 0; i < 40; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = 5.0;
        aa[1] = 2.0;
        aa[2] = 0.45;
        aa[3] = 0.2;
        aa[4] = 1.0;
        aa[5] = 0.5;
        aa[6] = 2.0;
        aa[7] = 1.0;
        aa[8] = 0.5;
        aa[9] = 1.0;
        aa[9] = 0.5;
        aa[10] = 0.2;
        aa[11] = 1.0;
        aa[12] = 0.7;
        aa[13] = 0.5;
        aa[14] = 1.0;
        for (i = 0; i < 40; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample_dist(sf2, "Distorted Guitar", data, base, 10000.0);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Distorted Guitar", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(8, 8000);
        return layer;
    }

    public static SF2Layer new_guitar_pick(SF2Soundbank sf2) {
        int i;
        int m = 2;
        int fftlen = 4096 * m;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5);
        }
        EmergencySoundbank.fft(data);
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 2048 * m; ++i) {
            int n = i;
            data[n] = data[n] * (Math.exp(-Math.abs((double)(i - 23) / (double)m) * 1.2) + Math.exp(-Math.abs((double)(i - 40) / (double)m) * 0.9));
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.8);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i2 = 0;
        while (i2 < data.length) {
            int n = i2++;
            data[n] = data[n] * gain;
            gain *= 0.9994;
        }
        double[] datab = data;
        EmergencySoundbank.fadeUp(data, 80);
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Guitar Noise", datab);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Guitar Noise");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_gpiano(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.06666666666666667);
        double[] aa = new double[30];
        for (i = 0; i < 30; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 2.0;
        aa[4] = aa[4] * 2.0;
        aa[12] = aa[12] * 0.9;
        aa[13] = aa[13] * 0.7;
        i = 14;
        while (i < 30) {
            int n = i++;
            aa[n] = aa[n] * 0.5;
        }
        for (i = 0; i < 30; ++i) {
            double w = 0.2;
            double ai = aa[i];
            if (i > 10) {
                w = 5.0;
                ai *= 10.0;
            }
            int adjust = 0;
            if (i > 5) {
                adjust = (i - 5) * 7;
            }
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1) + (double)adjust, w, ai);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Grand Piano", data, base, 200);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Grand Piano", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -7000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, -6000);
        region.putInteger(30, 12000);
        region.putInteger(11, -5500);
        region.putInteger(8, 18000);
        return layer;
    }

    public static SF2Layer new_gpiano2(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.05);
        double[] aa = new double[30];
        for (i = 0; i < 30; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 1.0;
        aa[4] = aa[4] * 2.0;
        aa[12] = aa[12] * 0.9;
        aa[13] = aa[13] * 0.7;
        i = 14;
        while (i < 30) {
            int n = i++;
            aa[n] = aa[n] * 0.5;
        }
        for (i = 0; i < 30; ++i) {
            double w = 0.2;
            double ai = aa[i];
            if (i > 10) {
                w = 5.0;
                ai *= 10.0;
            }
            int adjust = 0;
            if (i > 5) {
                adjust = (i - 5) * 7;
            }
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1) + (double)adjust, w, ai);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Grand Piano", data, base, 200);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Grand Piano", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -7000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, -6000);
        region.putInteger(30, 12000);
        region.putInteger(11, -5500);
        region.putInteger(8, 18000);
        return layer;
    }

    public static SF2Layer new_piano_hammer(SF2Soundbank sf2) {
        int i;
        int m = 2;
        int fftlen = 4096 * m;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5);
        }
        EmergencySoundbank.fft(data);
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 2048 * m; ++i) {
            int n = i;
            data[n] = data[n] * Math.exp(-Math.abs((double)(i - 37) / (double)m) * 0.05);
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.6);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i2 = 0;
        while (i2 < data.length) {
            int n = i2++;
            data[n] = data[n] * gain;
            gain *= 0.9997;
        }
        double[] datab = data;
        EmergencySoundbank.fadeUp(data, 80);
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Piano Hammer", datab);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Piano Hammer");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_piano1(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_a = 0.2;
        double end_a = 1.0E-4;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        double[] aa = new double[30];
        for (i = 0; i < 30; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 5.0;
        aa[2] = aa[2] * 0.1;
        aa[7] = aa[7] * 5.0;
        for (i = 0; i < 30; ++i) {
            double w = 0.2;
            double ai = aa[i];
            if (i > 12) {
                w = 5.0;
                ai *= 10.0;
            }
            int adjust = 0;
            if (i > 5) {
                adjust = (i - 5) * 7;
            }
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1) + (double)adjust, w, ai);
        }
        EmergencySoundbank.complexGaussianDist(data, base * 15.5, 1.0, 0.1);
        EmergencySoundbank.complexGaussianDist(data, base * 17.5, 1.0, 0.01);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "EPiano", data, base, 200);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "EPiano", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, -1200);
        region.putInteger(30, 12000);
        region.putInteger(11, -5500);
        region.putInteger(8, 16000);
        return layer;
    }

    public static SF2Layer new_epiano1(SF2Soundbank sf2) {
        Random random = new Random(302030201L);
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.05;
        double end_w = 0.05;
        double start_a = 0.2;
        double end_a = 1.0E-4;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            double detune = 1.0 + (random.nextDouble() * 2.0 - 1.0) * 1.0E-4;
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1) * detune, w, a);
            a *= a_step;
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "EPiano", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "EPiano", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, 1200);
        region.putInteger(30, 12000);
        region.putInteger(11, -9000);
        region.putInteger(8, 16000);
        return layer;
    }

    public static SF2Layer new_epiano2(SF2Soundbank sf2) {
        Random random = new Random(302030201L);
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.01;
        double end_w = 0.05;
        double start_a = 0.2;
        double end_a = 1.0E-5;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            double detune = 1.0 + (random.nextDouble() * 2.0 - 1.0) * 1.0E-4;
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1) * detune, w, a);
            a *= a_step;
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "EPiano", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "EPiano", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 8000);
        region.putInteger(37, 1000);
        region.putInteger(26, 2400);
        region.putInteger(30, 12000);
        region.putInteger(11, -9000);
        region.putInteger(8, 16000);
        region.putInteger(48, -100);
        return layer;
    }

    public static SF2Layer new_bass1(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.05;
        double end_w = 0.05;
        double start_a = 0.2;
        double end_a = 0.02;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.04);
        double[] aa = new double[25];
        for (i = 0; i < 25; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 8.0;
        aa[1] = aa[1] * 4.0;
        aa[3] = aa[3] * 8.0;
        aa[5] = aa[5] * 8.0;
        for (i = 0; i < 25; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Bass", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Bass", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, -3000);
        region.putInteger(30, 12000);
        region.putInteger(11, -5000);
        region.putInteger(8, 11000);
        region.putInteger(48, -100);
        return layer;
    }

    public static SF2Layer new_synthbass(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.05;
        double end_w = 0.05;
        double start_a = 0.2;
        double end_a = 0.02;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.04);
        double[] aa = new double[25];
        for (i = 0; i < 25; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 16.0;
        aa[1] = aa[1] * 4.0;
        aa[3] = aa[3] * 16.0;
        aa[5] = aa[5] * 8.0;
        for (i = 0; i < 25; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Bass", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Bass", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -12000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, -3000);
        region.putInteger(30, 12000);
        region.putInteger(11, -3000);
        region.putInteger(9, 100);
        region.putInteger(8, 8000);
        region.putInteger(48, -100);
        return layer;
    }

    public static SF2Layer new_bass2(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 0.05;
        double end_w = 0.05;
        double start_a = 0.2;
        double end_a = 0.002;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.04);
        double[] aa = new double[25];
        for (i = 0; i < 25; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 8.0;
        aa[1] = aa[1] * 4.0;
        aa[3] = aa[3] * 8.0;
        aa[5] = aa[5] * 8.0;
        for (i = 0; i < 25; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Bass2", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Bass2", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -8000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, 1000);
        region.putInteger(26, -6000);
        region.putInteger(30, 12000);
        region.putInteger(8, 5000);
        region.putInteger(48, -100);
        return layer;
    }

    public static SF2Layer new_solostring(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 2.0;
        double end_w = 2.0;
        double start_a = 0.2;
        double end_a = 0.01;
        double[] aa = new double[18];
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (i = 0; i < aa.length; ++i) {
            aa[i] = a *= a_step;
        }
        aa[0] = aa[0] * 5.0;
        aa[1] = aa[1] * 5.0;
        aa[2] = aa[2] * 5.0;
        aa[3] = aa[3] * 4.0;
        aa[4] = aa[4] * 4.0;
        aa[5] = aa[5] * 3.0;
        aa[6] = aa[6] * 3.0;
        aa[7] = aa[7] * 2.0;
        for (i = 0; i < aa.length; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, a);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Strings", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Strings", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -5000);
        region.putInteger(38, 1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        region.putInteger(24, -1000);
        region.putInteger(6, 15);
        return layer;
    }

    public static SF2Layer new_orchhit(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 2.0;
        double end_w = 80.0;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, a);
            a *= a_step;
        }
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 300.0, 1.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Och Strings", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Och Strings", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -5000);
        region.putInteger(38, 200);
        region.putInteger(36, 200);
        region.putInteger(37, 1000);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_string2(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 2.0;
        double end_w = 80.0;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, a);
            a *= a_step;
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Strings", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Strings", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -5000);
        region.putInteger(38, 1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_choir(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 25;
        double start_w = 2.0;
        double end_w = 80.0;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        double[] aa = new double[40];
        for (i = 0; i < aa.length; ++i) {
            aa[i] = a *= a_step;
        }
        aa[5] = aa[5] * 0.1;
        aa[6] = aa[6] * 0.01;
        aa[7] = aa[7] * 0.1;
        aa[8] = aa[8] * 0.1;
        for (i = 0; i < aa.length; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Strings", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Strings", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -5000);
        region.putInteger(38, 1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_organ(SF2Soundbank sf2) {
        Random random = new Random(102030201L);
        int x = 1;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_w = 0.01;
        double end_w = 0.01;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 12; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, a * (0.5 + 3.0 * random.nextDouble()));
            a *= a_step;
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Organ", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Organ", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_ch_organ(SF2Soundbank sf2) {
        int i;
        int x = 1;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_w = 0.01;
        double end_w = 0.01;
        double start_a = 0.2;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.016666666666666666);
        double[] aa = new double[60];
        for (i = 0; i < aa.length; ++i) {
            aa[i] = a *= a_step;
        }
        aa[0] = aa[0] * 5.0;
        aa[1] = aa[1] * 2.0;
        aa[2] = 0.0;
        aa[4] = 0.0;
        aa[5] = 0.0;
        aa[7] = aa[7] * 7.0;
        aa[9] = 0.0;
        aa[10] = 0.0;
        aa[12] = 0.0;
        aa[15] = aa[15] * 7.0;
        aa[18] = 0.0;
        aa[20] = 0.0;
        aa[24] = 0.0;
        aa[27] = aa[27] * 5.0;
        aa[29] = 0.0;
        aa[30] = 0.0;
        aa[33] = 0.0;
        aa[36] = aa[36] * 4.0;
        aa[37] = 0.0;
        aa[39] = 0.0;
        aa[42] = 0.0;
        aa[43] = 0.0;
        aa[47] = 0.0;
        aa[50] = aa[50] * 4.0;
        aa[52] = 0.0;
        aa[55] = 0.0;
        aa[57] = 0.0;
        aa[10] = aa[10] * 0.1;
        aa[11] = aa[11] * 0.1;
        aa[12] = aa[12] * 0.1;
        aa[13] = aa[13] * 0.1;
        aa[17] = aa[17] * 0.1;
        aa[18] = aa[18] * 0.1;
        aa[19] = aa[19] * 0.1;
        aa[20] = aa[20] * 0.1;
        for (i = 0; i < 60; ++i) {
            double w = start_w + (end_w - start_w) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), w, aa[i]);
            a *= a_step;
        }
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Organ", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Organ", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -10000);
        region.putInteger(38, -1000);
        return layer;
    }

    public static SF2Layer new_flute(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        EmergencySoundbank.complexGaussianDist(data, base * 1.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 100.0, 120.0);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 100.0, 40.0);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 100.0, 80.0);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 0.001, 0.05);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 0.001, 0.06);
        EmergencySoundbank.complexGaussianDist(data, base * 7.0, 0.001, 0.04);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 0.005, 0.06);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 0.005, 0.06);
        EmergencySoundbank.complexGaussianDist(data, base * 10.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 0.08, 0.7);
        EmergencySoundbank.complexGaussianDist(data, base * 12.0, 0.08, 0.6);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 0.08, 0.6);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 0.08, 0.6);
        EmergencySoundbank.complexGaussianDist(data, base * 15.0, 0.08, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 16.0, 0.08, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 17.0, 0.08, 0.2);
        EmergencySoundbank.complexGaussianDist(data, base * 1.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 7.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 20.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 10.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 12.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 15.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(data, base * 16.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(data, base * 17.0, 30.0, 6.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Flute", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Flute", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_horn(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_a = 0.5;
        double end_a = 1.0E-11;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            if (i == 0) {
                EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1, a * 0.2);
            } else {
                EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1, a);
            }
            a *= a_step;
        }
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 100.0, 1.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Horn", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Horn", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(26, -500);
        region.putInteger(30, 12000);
        region.putInteger(11, 5000);
        region.putInteger(8, 4500);
        return layer;
    }

    public static SF2Layer new_trumpet(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_a = 0.5;
        double end_a = 1.0E-5;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.0125);
        double[] aa = new double[80];
        for (i = 0; i < 80; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 0.05;
        aa[1] = aa[1] * 0.2;
        aa[2] = aa[2] * 0.5;
        aa[3] = aa[3] * 0.85;
        for (i = 0; i < 80; ++i) {
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1, aa[i]);
        }
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 300.0, 3.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Trumpet", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Trumpet", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -10000);
        region.putInteger(38, 0);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(26, -4000);
        region.putInteger(30, -2500);
        region.putInteger(11, 5000);
        region.putInteger(8, 4500);
        region.putInteger(9, 10);
        return layer;
    }

    public static SF2Layer new_brass_section(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_a = 0.5;
        double end_a = 0.005;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.03333333333333333);
        double[] aa = new double[30];
        for (int i = 0; i < 30; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 0.8;
        aa[1] = aa[1] * 0.9;
        double w = 5.0;
        for (int i = 0; i < 30; ++i) {
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1 * w, aa[i] * w);
            w += 6.0;
        }
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 300.0, 2.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Brass Section", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Brass Section", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -9200);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(26, -3000);
        region.putInteger(30, 12000);
        region.putInteger(11, 5000);
        region.putInteger(8, 4500);
        return layer;
    }

    public static SF2Layer new_trombone(SF2Soundbank sf2) {
        int i;
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_a = 0.5;
        double end_a = 0.001;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.0125);
        double[] aa = new double[80];
        for (i = 0; i < 80; ++i) {
            aa[i] = a;
            a *= a_step;
        }
        aa[0] = aa[0] * 0.3;
        aa[1] = aa[1] * 0.7;
        for (i = 0; i < 80; ++i) {
            EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1, aa[i]);
        }
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 300.0, 2.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Trombone", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Trombone", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -8000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(26, -2000);
        region.putInteger(30, 12000);
        region.putInteger(11, 5000);
        region.putInteger(8, 4500);
        region.putInteger(9, 10);
        return layer;
    }

    public static SF2Layer new_sax(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        double start_a = 0.5;
        double end_a = 0.01;
        double a = start_a;
        double a_step = Math.pow(end_a / start_a, 0.025);
        for (int i = 0; i < 40; ++i) {
            if (i == 0 || i == 2) {
                EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1, a * 4.0);
            } else {
                EmergencySoundbank.complexGaussianDist(data, base * (double)(i + 1), 0.1, a);
            }
            a *= a_step;
        }
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 200.0, 1.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Sax", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Sax", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(26, -3000);
        region.putInteger(30, 12000);
        region.putInteger(11, 5000);
        region.putInteger(8, 4500);
        return layer;
    }

    public static SF2Layer new_oboe(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 100.0, 80.0);
        EmergencySoundbank.complexGaussianDist(data, base * 1.0, 0.01, 0.53);
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 0.01, 0.49);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 0.01, 5.0);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 7.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 0.01, 0.59);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 0.01, 0.61);
        EmergencySoundbank.complexGaussianDist(data, base * 10.0, 0.01, 0.52);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 0.01, 0.49);
        EmergencySoundbank.complexGaussianDist(data, base * 12.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 15.0, 0.01, 0.46);
        EmergencySoundbank.complexGaussianDist(data, base * 16.0, 0.01, 0.35);
        EmergencySoundbank.complexGaussianDist(data, base * 17.0, 0.01, 0.2);
        EmergencySoundbank.complexGaussianDist(data, base * 18.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(data, base * 19.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 20.0, 0.01, 0.1);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Oboe", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Oboe", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_bassoon(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 100.0, 40.0);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 100.0, 20.0);
        EmergencySoundbank.complexGaussianDist(data, base * 1.0, 0.01, 0.53);
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 0.01, 5.0);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 0.01, 1.49);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 7.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 0.01, 0.59);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 0.01, 0.61);
        EmergencySoundbank.complexGaussianDist(data, base * 10.0, 0.01, 0.52);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 0.01, 0.49);
        EmergencySoundbank.complexGaussianDist(data, base * 12.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(data, base * 15.0, 0.01, 0.46);
        EmergencySoundbank.complexGaussianDist(data, base * 16.0, 0.01, 0.35);
        EmergencySoundbank.complexGaussianDist(data, base * 17.0, 0.01, 0.2);
        EmergencySoundbank.complexGaussianDist(data, base * 18.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(data, base * 19.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 20.0, 0.01, 0.1);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Flute", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Flute", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_clarinet(SF2Soundbank sf2) {
        int x = 8;
        int fftsize = 4096 * x;
        double[] data = new double[fftsize * 2];
        double base = x * 15;
        EmergencySoundbank.complexGaussianDist(data, base * 1.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 0.001, 0.02);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 0.001, 0.2);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 100.0, 60.0);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 100.0, 20.0);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 100.0, 20.0);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 0.001, 0.1);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 0.001, 0.09);
        EmergencySoundbank.complexGaussianDist(data, base * 7.0, 0.001, 0.02);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 0.005, 0.16);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 0.005, 0.96);
        EmergencySoundbank.complexGaussianDist(data, base * 10.0, 0.01, 0.9);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 0.08, 1.2);
        EmergencySoundbank.complexGaussianDist(data, base * 12.0, 0.08, 1.8);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 0.08, 1.6);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 0.08, 1.2);
        EmergencySoundbank.complexGaussianDist(data, base * 15.0, 0.08, 0.9);
        EmergencySoundbank.complexGaussianDist(data, base * 16.0, 0.08, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 17.0, 0.08, 0.2);
        EmergencySoundbank.complexGaussianDist(data, base * 1.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 4.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 7.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 20.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 10.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 12.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(data, base * 15.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(data, base * 16.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(data, base * 17.0, 30.0, 6.0);
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Clarinet", data, base);
        SF2Layer layer = EmergencySoundbank.newLayer(sf2, "Clarinet", sample);
        SF2Region region = layer.getRegions().get(0);
        region.putInteger(54, 1);
        region.putInteger(34, -6000);
        region.putInteger(38, -1000);
        region.putInteger(36, 4000);
        region.putInteger(37, -100);
        region.putInteger(8, 9500);
        return layer;
    }

    public static SF2Layer new_timpani(SF2Soundbank sf2) {
        int i;
        int fftlen = 32768;
        double[] data = new double[2 * fftlen];
        double base = 48.0;
        EmergencySoundbank.complexGaussianDist(data, base * 2.0, 0.2, 1.0);
        EmergencySoundbank.complexGaussianDist(data, base * 3.0, 0.2, 0.7);
        EmergencySoundbank.complexGaussianDist(data, base * 5.0, 10.0, 1.0);
        EmergencySoundbank.complexGaussianDist(data, base * 6.0, 9.0, 1.0);
        EmergencySoundbank.complexGaussianDist(data, base * 8.0, 15.0, 1.0);
        EmergencySoundbank.complexGaussianDist(data, base * 9.0, 18.0, 0.8);
        EmergencySoundbank.complexGaussianDist(data, base * 11.0, 21.0, 0.5);
        EmergencySoundbank.complexGaussianDist(data, base * 13.0, 28.0, 0.3);
        EmergencySoundbank.complexGaussianDist(data, base * 14.0, 22.0, 0.1);
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.5);
        data = EmergencySoundbank.realPart(data);
        double d_len = data.length;
        int i2 = 0;
        while (i2 < data.length) {
            double g = 1.0 - (double)i2 / d_len;
            int n = i2++;
            data[n] = data[n] * (g * g);
        }
        EmergencySoundbank.fadeUp(data, 40);
        double[] datab = data;
        fftlen = 16384;
        data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 4096; i < 8192; ++i) {
            data[i] = 1.0 - (double)(i - 4096) / 4096.0;
        }
        i = 0;
        while (i < 300) {
            double g = 1.0 - (double)i / 300.0;
            int n = i++;
            data[n] = data[n] * (1.0 + 20.0 * g * g);
        }
        for (i = 0; i < 24; ++i) {
            data[i] = 0.0;
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i3 = 0;
        while (i3 < data.length) {
            int n = i3++;
            data[n] = data[n] * gain;
            gain *= 0.9998;
        }
        double[] datah = data;
        for (int i4 = 0; i4 < datah.length; ++i4) {
            int n = i4;
            datab[n] = datab[n] + datah[i4] * 0.02;
        }
        EmergencySoundbank.normalize(datab, 0.9);
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Timpani", datab);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Timpani");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(48, -100);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_melodic_toms(SF2Soundbank sf2) {
        int i;
        int i2;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        EmergencySoundbank.complexGaussianDist(data, 30.0, 0.5, 1.0);
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.8);
        data = EmergencySoundbank.realPart(data);
        double d_len = data.length;
        for (int i3 = 0; i3 < data.length; ++i3) {
            int n = i3;
            data[n] = data[n] * (1.0 - (double)i3 / d_len);
        }
        double[] datab = data;
        fftlen = 16384;
        data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i2 = 0; i2 < data.length; i2 += 2) {
            data[i2] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i2 = fftlen / 2; i2 < data.length; ++i2) {
            data[i2] = 0.0;
        }
        for (i2 = 4096; i2 < 8192; ++i2) {
            data[i2] = 1.0 - (double)(i2 - 4096) / 4096.0;
        }
        i2 = 0;
        while (i2 < 200) {
            double g = 1.0 - (double)i2 / 200.0;
            int n = i2++;
            data[n] = data[n] * (1.0 + 20.0 * g * g);
        }
        for (i2 = 0; i2 < 30; ++i2) {
            data[i2] = 0.0;
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i4 = 0;
        while (i4 < data.length) {
            int n = i4++;
            data[n] = data[n] * gain;
            gain *= 0.9996;
        }
        double[] datah = data;
        for (i = 0; i < datah.length; ++i) {
            int n = i;
            datab[n] = datab[n] + datah[i] * 0.5;
        }
        for (i = 0; i < 5; ++i) {
            int n = i;
            datab[n] = datab[n] * ((double)i / 5.0);
        }
        EmergencySoundbank.normalize(datab, 0.99);
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Melodic Toms", datab);
        sample.setOriginalPitch(63);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Melodic Toms");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(48, -100);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_reverse_cymbal(SF2Soundbank sf2) {
        int i;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5);
        }
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 100; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 1024; ++i) {
            double gain = (double)i / 1024.0;
            data[i] = 1.0 - gain;
        }
        double[] datah = data;
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Reverse Cymbal", datah, 100.0, 20);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Reverse Cymbal");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(34, -200);
        region.putInteger(36, -12000);
        region.putInteger(54, 1);
        region.putInteger(38, -1000);
        region.putInteger(37, 1000);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_snare_drum(SF2Soundbank sf2) {
        int i;
        int i2;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        EmergencySoundbank.complexGaussianDist(data, 24.0, 0.5, 1.0);
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.5);
        data = EmergencySoundbank.realPart(data);
        double d_len = data.length;
        for (int i3 = 0; i3 < data.length; ++i3) {
            int n = i3;
            data[n] = data[n] * (1.0 - (double)i3 / d_len);
        }
        double[] datab = data;
        fftlen = 16384;
        data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i2 = 0; i2 < data.length; i2 += 2) {
            data[i2] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i2 = fftlen / 2; i2 < data.length; ++i2) {
            data[i2] = 0.0;
        }
        for (i2 = 4096; i2 < 8192; ++i2) {
            data[i2] = 1.0 - (double)(i2 - 4096) / 4096.0;
        }
        i2 = 0;
        while (i2 < 300) {
            double g = 1.0 - (double)i2 / 300.0;
            int n = i2++;
            data[n] = data[n] * (1.0 + 20.0 * g * g);
        }
        for (i2 = 0; i2 < 24; ++i2) {
            data[i2] = 0.0;
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i4 = 0;
        while (i4 < data.length) {
            int n = i4++;
            data[n] = data[n] * gain;
            gain *= 0.9998;
        }
        double[] datah = data;
        for (i = 0; i < datah.length; ++i) {
            int n = i;
            datab[n] = datab[n] + datah[i];
        }
        for (i = 0; i < 5; ++i) {
            int n = i;
            datab[n] = datab[n] * ((double)i / 5.0);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Snare Drum", datab);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Snare Drum");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(56, 0);
        region.putInteger(48, -100);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_bass_drum(SF2Soundbank sf2) {
        int i;
        int i2;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        EmergencySoundbank.complexGaussianDist(data, 10.0, 2.0, 1.0);
        EmergencySoundbank.complexGaussianDist(data, 17.2, 2.0, 1.0);
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double d_len = data.length;
        for (int i3 = 0; i3 < data.length; ++i3) {
            int n = i3;
            data[n] = data[n] * (1.0 - (double)i3 / d_len);
        }
        double[] datab = data;
        fftlen = 4096;
        data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i2 = 0; i2 < data.length; i2 += 2) {
            data[i2] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i2 = fftlen / 2; i2 < data.length; ++i2) {
            data[i2] = 0.0;
        }
        for (i2 = 1024; i2 < 2048; ++i2) {
            data[i2] = 1.0 - (double)(i2 - 1024) / 1024.0;
        }
        for (i2 = 0; i2 < 512; ++i2) {
            data[i2] = (double)(10 * i2) / 512.0;
        }
        for (i2 = 0; i2 < 10; ++i2) {
            data[i2] = 0.0;
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i4 = 0;
        while (i4 < data.length) {
            int n = i4++;
            data[n] = data[n] * gain;
            gain *= 0.999;
        }
        double[] datah = data;
        for (i = 0; i < datah.length; ++i) {
            int n = i;
            datab[n] = datab[n] + datah[i] * 0.5;
        }
        for (i = 0; i < 5; ++i) {
            int n = i;
            datab[n] = datab[n] * ((double)i / 5.0);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Bass Drum", datab);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Bass Drum");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(56, 0);
        region.putInteger(48, -100);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_tom(SF2Soundbank sf2) {
        int i;
        int i2;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        EmergencySoundbank.complexGaussianDist(data, 30.0, 0.5, 1.0);
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.8);
        data = EmergencySoundbank.realPart(data);
        double d_len = data.length;
        for (int i3 = 0; i3 < data.length; ++i3) {
            int n = i3;
            data[n] = data[n] * (1.0 - (double)i3 / d_len);
        }
        double[] datab = data;
        fftlen = 16384;
        data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i2 = 0; i2 < data.length; i2 += 2) {
            data[i2] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i2 = fftlen / 2; i2 < data.length; ++i2) {
            data[i2] = 0.0;
        }
        for (i2 = 4096; i2 < 8192; ++i2) {
            data[i2] = 1.0 - (double)(i2 - 4096) / 4096.0;
        }
        i2 = 0;
        while (i2 < 200) {
            double g = 1.0 - (double)i2 / 200.0;
            int n = i2++;
            data[n] = data[n] * (1.0 + 20.0 * g * g);
        }
        for (i2 = 0; i2 < 30; ++i2) {
            data[i2] = 0.0;
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i4 = 0;
        while (i4 < data.length) {
            int n = i4++;
            data[n] = data[n] * gain;
            gain *= 0.9996;
        }
        double[] datah = data;
        for (i = 0; i < datah.length; ++i) {
            int n = i;
            datab[n] = datab[n] + datah[i] * 0.5;
        }
        for (i = 0; i < 5; ++i) {
            int n = i;
            datab[n] = datab[n] * ((double)i / 5.0);
        }
        EmergencySoundbank.normalize(datab, 0.99);
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Tom", datab);
        sample.setOriginalPitch(50);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Tom");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(48, -100);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_closed_hihat(SF2Soundbank sf2) {
        int i;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 4096; i < 8192; ++i) {
            data[i] = 1.0 - (double)(i - 4096) / 4096.0;
        }
        for (i = 0; i < 2048; ++i) {
            data[i] = 0.2 + 0.8 * ((double)i / 2048.0);
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i2 = 0;
        while (i2 < data.length) {
            int n = i2++;
            data[n] = data[n] * gain;
            gain *= 0.9996;
        }
        double[] datah = data;
        for (int i3 = 0; i3 < 5; ++i3) {
            int n = i3;
            datah[n] = datah[n] * ((double)i3 / 5.0);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Closed Hi-Hat", datah);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Closed Hi-Hat");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(56, 0);
        region.putInteger(57, 1);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_open_hihat(SF2Soundbank sf2) {
        int i;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5);
        }
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 200; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 8192; ++i) {
            double gain;
            data[i] = gain = (double)i / 8192.0;
        }
        double[] datah = data;
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Open Hi-Hat", datah, 1000.0, 5);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Open Hi-Hat");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(36, 1500);
        region.putInteger(54, 1);
        region.putInteger(38, 1500);
        region.putInteger(37, 1000);
        region.putInteger(56, 0);
        region.putInteger(57, 1);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_crash_cymbal(SF2Soundbank sf2) {
        int i;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5);
        }
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 100; ++i) {
            data[i] = 0.0;
        }
        for (i = 0; i < 1024; ++i) {
            double gain;
            data[i] = gain = (double)i / 1024.0;
        }
        double[] datah = data;
        SF2Sample sample = EmergencySoundbank.newSimpleFFTSample(sf2, "Crash Cymbal", datah, 1000.0, 5);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Crash Cymbal");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(36, 1800);
        region.putInteger(54, 1);
        region.putInteger(38, 1800);
        region.putInteger(37, 1000);
        region.putInteger(56, 0);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Layer new_side_stick(SF2Soundbank sf2) {
        int i;
        int fftlen = 16384;
        double[] data = new double[2 * fftlen];
        Random random = new Random(3049912L);
        for (i = 0; i < data.length; i += 2) {
            data[i] = 2.0 * (random.nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft(data);
        for (i = fftlen / 2; i < data.length; ++i) {
            data[i] = 0.0;
        }
        for (i = 4096; i < 8192; ++i) {
            data[i] = 1.0 - (double)(i - 4096) / 4096.0;
        }
        i = 0;
        while (i < 200) {
            double g = 1.0 - (double)i / 200.0;
            int n = i++;
            data[n] = data[n] * (1.0 + 20.0 * g * g);
        }
        for (i = 0; i < 30; ++i) {
            data[i] = 0.0;
        }
        EmergencySoundbank.randomPhase(data, new Random(3049912L));
        EmergencySoundbank.ifft(data);
        EmergencySoundbank.normalize(data, 0.9);
        data = EmergencySoundbank.realPart(data);
        double gain = 1.0;
        int i2 = 0;
        while (i2 < data.length) {
            int n = i2++;
            data[n] = data[n] * gain;
            gain *= 0.9996;
        }
        double[] datab = data;
        for (int i3 = 0; i3 < 10; ++i3) {
            int n = i3;
            datab[n] = datab[n] * ((double)i3 / 10.0);
        }
        SF2Sample sample = EmergencySoundbank.newSimpleDrumSample(sf2, "Side Stick", datab);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName("Side Stick");
        SF2GlobalRegion global = new SF2GlobalRegion();
        layer.setGlobalZone(global);
        sf2.addResource(layer);
        SF2LayerRegion region = new SF2LayerRegion();
        region.putInteger(38, 12000);
        region.putInteger(56, 0);
        region.putInteger(48, -50);
        region.setSample(sample);
        layer.getRegions().add(region);
        return layer;
    }

    public static SF2Sample newSimpleFFTSample(SF2Soundbank sf2, String name, double[] data, double base) {
        return EmergencySoundbank.newSimpleFFTSample(sf2, name, data, base, 10);
    }

    public static SF2Sample newSimpleFFTSample(SF2Soundbank sf2, String name, double[] data, double base, int fadeuptime) {
        int fftsize = data.length / 2;
        AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
        double basefreq = base / (double)fftsize * (double)format.getSampleRate() * 0.5;
        EmergencySoundbank.randomPhase(data);
        EmergencySoundbank.ifft(data);
        data = EmergencySoundbank.realPart(data);
        EmergencySoundbank.normalize(data, 0.9);
        float[] fdata = EmergencySoundbank.toFloat(data);
        fdata = EmergencySoundbank.loopExtend(fdata, fdata.length + 512);
        EmergencySoundbank.fadeUp(fdata, fadeuptime);
        byte[] bdata = EmergencySoundbank.toBytes(fdata, format);
        SF2Sample sample = new SF2Sample(sf2);
        sample.setName(name);
        sample.setData(bdata);
        sample.setStartLoop(256L);
        sample.setEndLoop(fftsize + 256);
        sample.setSampleRate((long)format.getSampleRate());
        double orgnote = 81.0 + 12.0 * Math.log(basefreq / 440.0) / Math.log(2.0);
        sample.setOriginalPitch((int)orgnote);
        sample.setPitchCorrection((byte)(-(orgnote - (double)((int)orgnote)) * 100.0));
        sf2.addResource(sample);
        return sample;
    }

    public static SF2Sample newSimpleFFTSample_dist(SF2Soundbank sf2, String name, double[] data, double base, double preamp) {
        int fftsize = data.length / 2;
        AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
        double basefreq = base / (double)fftsize * (double)format.getSampleRate() * 0.5;
        EmergencySoundbank.randomPhase(data);
        EmergencySoundbank.ifft(data);
        data = EmergencySoundbank.realPart(data);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (1.0 - Math.exp(-Math.abs(data[i] * preamp))) * Math.signum(data[i]);
        }
        EmergencySoundbank.normalize(data, 0.9);
        float[] fdata = EmergencySoundbank.toFloat(data);
        fdata = EmergencySoundbank.loopExtend(fdata, fdata.length + 512);
        EmergencySoundbank.fadeUp(fdata, 80);
        byte[] bdata = EmergencySoundbank.toBytes(fdata, format);
        SF2Sample sample = new SF2Sample(sf2);
        sample.setName(name);
        sample.setData(bdata);
        sample.setStartLoop(256L);
        sample.setEndLoop(fftsize + 256);
        sample.setSampleRate((long)format.getSampleRate());
        double orgnote = 81.0 + 12.0 * Math.log(basefreq / 440.0) / Math.log(2.0);
        sample.setOriginalPitch((int)orgnote);
        sample.setPitchCorrection((byte)(-(orgnote - (double)((int)orgnote)) * 100.0));
        sf2.addResource(sample);
        return sample;
    }

    public static SF2Sample newSimpleDrumSample(SF2Soundbank sf2, String name, double[] data) {
        int fftsize = data.length;
        AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
        byte[] bdata = EmergencySoundbank.toBytes(EmergencySoundbank.toFloat(EmergencySoundbank.realPart(data)), format);
        SF2Sample sample = new SF2Sample(sf2);
        sample.setName(name);
        sample.setData(bdata);
        sample.setStartLoop(256L);
        sample.setEndLoop(fftsize + 256);
        sample.setSampleRate((long)format.getSampleRate());
        sample.setOriginalPitch(60);
        sf2.addResource(sample);
        return sample;
    }

    public static SF2Layer newLayer(SF2Soundbank sf2, String name, SF2Sample sample) {
        SF2LayerRegion region = new SF2LayerRegion();
        region.setSample(sample);
        SF2Layer layer = new SF2Layer(sf2);
        layer.setName(name);
        layer.getRegions().add(region);
        sf2.addResource(layer);
        return layer;
    }

    public static SF2Instrument newInstrument(SF2Soundbank sf2, String name, Patch patch, SF2Layer ... layers) {
        SF2Instrument ins = new SF2Instrument(sf2);
        ins.setPatch(patch);
        ins.setName(name);
        sf2.addInstrument(ins);
        for (int i = 0; i < layers.length; ++i) {
            SF2InstrumentRegion insregion = new SF2InstrumentRegion();
            insregion.setLayer(layers[i]);
            ins.getRegions().add(insregion);
        }
        return ins;
    }

    public static void ifft(double[] data) {
        new FFT(data.length / 2, 1).transform(data);
    }

    public static void fft(double[] data) {
        new FFT(data.length / 2, -1).transform(data);
    }

    public static void complexGaussianDist(double[] cdata, double m, double s, double v) {
        for (int x = 0; x < cdata.length / 4; ++x) {
            int n = x * 2;
            cdata[n] = cdata[n] + v * (1.0 / (s * Math.sqrt(Math.PI * 2)) * Math.exp(-0.5 * Math.pow(((double)x - m) / s, 2.0)));
        }
    }

    public static void randomPhase(double[] data) {
        for (int i = 0; i < data.length; i += 2) {
            double phase = Math.random() * 2.0 * Math.PI;
            double d = data[i];
            data[i] = Math.sin(phase) * d;
            data[i + 1] = Math.cos(phase) * d;
        }
    }

    public static void randomPhase(double[] data, Random random) {
        for (int i = 0; i < data.length; i += 2) {
            double phase = random.nextDouble() * 2.0 * Math.PI;
            double d = data[i];
            data[i] = Math.sin(phase) * d;
            data[i + 1] = Math.cos(phase) * d;
        }
    }

    public static void normalize(double[] data, double target) {
        double maxvalue = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] > maxvalue) {
                maxvalue = data[i];
            }
            if (!(-data[i] > maxvalue)) continue;
            maxvalue = -data[i];
        }
        if (maxvalue == 0.0) {
            return;
        }
        double gain = target / maxvalue;
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] * gain;
        }
    }

    public static void normalize(float[] data, double target) {
        double maxvalue = 0.5;
        for (int i = 0; i < data.length; ++i) {
            if ((double)data[i * 2] > maxvalue) {
                maxvalue = data[i * 2];
            }
            if (!((double)(-data[i * 2]) > maxvalue)) continue;
            maxvalue = -data[i * 2];
        }
        double gain = target / maxvalue;
        for (int i = 0; i < data.length; ++i) {
            int n = i * 2;
            data[n] = (float)((double)data[n] * gain);
        }
    }

    public static double[] realPart(double[] in) {
        double[] out = new double[in.length / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[i * 2];
        }
        return out;
    }

    public static double[] imgPart(double[] in) {
        double[] out = new double[in.length / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[i * 2];
        }
        return out;
    }

    public static float[] toFloat(double[] in) {
        float[] out = new float[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (float)in[i];
        }
        return out;
    }

    public static byte[] toBytes(float[] in, AudioFormat format) {
        byte[] out = new byte[in.length * format.getFrameSize()];
        return AudioFloatConverter.getConverter(format).toByteArray(in, out);
    }

    public static void fadeUp(double[] data, int samples) {
        double dsamples = samples;
        for (int i = 0; i < samples; ++i) {
            int n = i;
            data[n] = data[n] * ((double)i / dsamples);
        }
    }

    public static void fadeUp(float[] data, int samples) {
        double dsamples = samples;
        for (int i = 0; i < samples; ++i) {
            int n = i;
            data[n] = (float)((double)data[n] * ((double)i / dsamples));
        }
    }

    public static double[] loopExtend(double[] data, int newsize) {
        double[] outdata = new double[newsize];
        int p_len = data.length;
        int p_ps = 0;
        for (int i = 0; i < outdata.length; ++i) {
            outdata[i] = data[p_ps];
            if (++p_ps != p_len) continue;
            p_ps = 0;
        }
        return outdata;
    }

    public static float[] loopExtend(float[] data, int newsize) {
        float[] outdata = new float[newsize];
        int p_len = data.length;
        int p_ps = 0;
        for (int i = 0; i < outdata.length; ++i) {
            outdata[i] = data[p_ps];
            if (++p_ps != p_len) continue;
            p_ps = 0;
        }
        return outdata;
    }
}

