/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import com.bene.media.sound.ModelDirectedPlayer;
import com.bene.media.sound.ModelDirector;
import com.bene.media.sound.ModelInstrument;
import com.bene.media.sound.ModelPerformer;
import com.bene.media.sound.SoftPerformer;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;

public final class SoftInstrument
extends Instrument {
    private SoftPerformer[] performers;
    private ModelPerformer[] modelperformers;
    private final Object data;
    private final ModelInstrument ins;

    public SoftInstrument(ModelInstrument ins) {
        super(ins.getSoundbank(), ins.getPatch(), ins.getName(), ins.getDataClass());
        this.data = ins.getData();
        this.ins = ins;
        this.initPerformers(ins.getPerformers());
    }

    public SoftInstrument(ModelInstrument ins, ModelPerformer[] overrideperformers) {
        super(ins.getSoundbank(), ins.getPatch(), ins.getName(), ins.getDataClass());
        this.data = ins.getData();
        this.ins = ins;
        this.initPerformers(overrideperformers);
    }

    private void initPerformers(ModelPerformer[] modelperformers) {
        this.modelperformers = modelperformers;
        this.performers = new SoftPerformer[modelperformers.length];
        for (int i = 0; i < modelperformers.length; ++i) {
            this.performers[i] = new SoftPerformer(modelperformers[i]);
        }
    }

    public ModelDirector getDirector(MidiChannel channel, ModelDirectedPlayer player) {
        return this.ins.getDirector(this.modelperformers, channel, player);
    }

    public ModelInstrument getSourceInstrument() {
        return this.ins;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public SoftPerformer getPerformer(int index) {
        return this.performers[index];
    }
}

