/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import com.bene.media.sound.SoftAudioBuffer;
import com.bene.media.sound.SoftAudioProcessor;

public final class SoftLimiter
implements SoftAudioProcessor {
    float lastmax = 0.0f;
    float gain = 1.0f;
    float[] temp_bufferL;
    float[] temp_bufferR;
    boolean mix = false;
    SoftAudioBuffer bufferL;
    SoftAudioBuffer bufferR;
    SoftAudioBuffer bufferLout;
    SoftAudioBuffer bufferRout;
    float controlrate;
    double silentcounter = 0.0;

    @Override
    public void init(float samplerate, float controlrate) {
        this.controlrate = controlrate;
    }

    @Override
    public void setInput(int pin, SoftAudioBuffer input) {
        if (pin == 0) {
            this.bufferL = input;
        }
        if (pin == 1) {
            this.bufferR = input;
        }
    }

    @Override
    public void setOutput(int pin, SoftAudioBuffer output) {
        if (pin == 0) {
            this.bufferLout = output;
        }
        if (pin == 1) {
            this.bufferRout = output;
        }
    }

    @Override
    public void setMixMode(boolean mix) {
        this.mix = mix;
    }

    @Override
    public void globalParameterControlChange(int[] slothpath, long param, long value) {
    }

    @Override
    public void processAudio() {
        int i;
        float[] bufferRout;
        if (this.bufferL.isSilent() && (this.bufferR == null || this.bufferR.isSilent())) {
            this.silentcounter += (double)(1.0f / this.controlrate);
            if (this.silentcounter > 60.0) {
                if (!this.mix) {
                    this.bufferLout.clear();
                    if (this.bufferRout != null) {
                        this.bufferRout.clear();
                    }
                }
                return;
            }
        } else {
            this.silentcounter = 0.0;
        }
        float[] bufferL = this.bufferL.array();
        float[] bufferR = this.bufferR == null ? null : this.bufferR.array();
        float[] bufferLout = this.bufferLout.array();
        float[] fArray = bufferRout = this.bufferRout == null ? null : this.bufferRout.array();
        if (this.temp_bufferL == null || this.temp_bufferL.length < bufferL.length) {
            this.temp_bufferL = new float[bufferL.length];
        }
        if (bufferR != null && (this.temp_bufferR == null || this.temp_bufferR.length < bufferR.length)) {
            this.temp_bufferR = new float[bufferR.length];
        }
        float max = 0.0f;
        int len = bufferL.length;
        if (bufferR == null) {
            for (i = 0; i < len; ++i) {
                if (bufferL[i] > max) {
                    max = bufferL[i];
                }
                if (!(-bufferL[i] > max)) continue;
                max = -bufferL[i];
            }
        } else {
            for (i = 0; i < len; ++i) {
                if (bufferL[i] > max) {
                    max = bufferL[i];
                }
                if (bufferR[i] > max) {
                    max = bufferR[i];
                }
                if (-bufferL[i] > max) {
                    max = -bufferL[i];
                }
                if (!(-bufferR[i] > max)) continue;
                max = -bufferR[i];
            }
        }
        float lmax = this.lastmax;
        this.lastmax = max;
        if (lmax > max) {
            max = lmax;
        }
        float newgain = 1.0f;
        newgain = max > 0.99f ? 0.99f / max : 1.0f;
        if (newgain > this.gain) {
            newgain = (newgain + this.gain * 9.0f) / 10.0f;
        }
        float gaindelta = (newgain - this.gain) / (float)len;
        if (this.mix) {
            if (bufferR == null) {
                int i2 = 0;
                while (i2 < len) {
                    this.gain += gaindelta;
                    float bL = bufferL[i2];
                    float tL = this.temp_bufferL[i2];
                    this.temp_bufferL[i2] = bL;
                    int n = i2++;
                    bufferLout[n] = bufferLout[n] + tL * this.gain;
                }
            } else {
                int i3 = 0;
                while (i3 < len) {
                    this.gain += gaindelta;
                    float bL = bufferL[i3];
                    float bR = bufferR[i3];
                    float tL = this.temp_bufferL[i3];
                    float tR = this.temp_bufferR[i3];
                    this.temp_bufferL[i3] = bL;
                    this.temp_bufferR[i3] = bR;
                    int n = i3;
                    bufferLout[n] = bufferLout[n] + tL * this.gain;
                    int n2 = i3++;
                    bufferRout[n2] = bufferRout[n2] + tR * this.gain;
                }
            }
        } else if (bufferR == null) {
            for (int i4 = 0; i4 < len; ++i4) {
                this.gain += gaindelta;
                float bL = bufferL[i4];
                float tL = this.temp_bufferL[i4];
                this.temp_bufferL[i4] = bL;
                bufferLout[i4] = tL * this.gain;
            }
        } else {
            for (int i5 = 0; i5 < len; ++i5) {
                this.gain += gaindelta;
                float bL = bufferL[i5];
                float bR = bufferR[i5];
                float tL = this.temp_bufferL[i5];
                float tR = this.temp_bufferR[i5];
                this.temp_bufferL[i5] = bL;
                this.temp_bufferR[i5] = bR;
                bufferLout[i5] = tL * this.gain;
                bufferRout[i5] = tR * this.gain;
            }
        }
        this.gain = newgain;
    }

    @Override
    public void processControlLogic() {
    }
}

