/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import com.bene.media.sound.SoftProcess;
import com.bene.media.sound.SoftSynthesizer;

public final class SoftLowFrequencyOscillator
implements SoftProcess {
    private final int max_count = 10;
    private int used_count = 0;
    private final double[][] out = new double[10][1];
    private final double[][] delay = new double[10][1];
    private final double[][] delay2 = new double[10][1];
    private final double[][] freq = new double[10][1];
    private final int[] delay_counter = new int[10];
    private final double[] sin_phase = new double[10];
    private final double[] sin_stepfreq = new double[10];
    private final double[] sin_step = new double[10];
    private double control_time = 0.0;
    private double sin_factor = 0.0;
    private static final double PI2 = Math.PI * 2;

    public SoftLowFrequencyOscillator() {
        for (int i = 0; i < this.sin_stepfreq.length; ++i) {
            this.sin_stepfreq[i] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.used_count; ++i) {
            this.out[i][0] = 0.0;
            this.delay[i][0] = 0.0;
            this.delay2[i][0] = 0.0;
            this.freq[i][0] = 0.0;
            this.delay_counter[i] = 0;
            this.sin_phase[i] = 0.0;
            this.sin_stepfreq[i] = Double.NEGATIVE_INFINITY;
            this.sin_step[i] = 0.0;
        }
        this.used_count = 0;
    }

    @Override
    public void init(SoftSynthesizer synth) {
        this.control_time = 1.0 / (double)synth.getControlRate();
        this.sin_factor = this.control_time * 2.0 * Math.PI;
        for (int i = 0; i < this.used_count; ++i) {
            this.delay_counter[i] = (int)(Math.pow(2.0, this.delay[i][0] / 1200.0) / this.control_time);
            int n = i;
            this.delay_counter[n] = this.delay_counter[n] + (int)(this.delay2[i][0] / (this.control_time * 1000.0));
        }
        this.processControlLogic();
    }

    @Override
    public void processControlLogic() {
        for (int i = 0; i < this.used_count; ++i) {
            if (this.delay_counter[i] > 0) {
                int n = i;
                this.delay_counter[n] = this.delay_counter[n] - 1;
                this.out[i][0] = 0.5;
                continue;
            }
            double f = this.freq[i][0];
            if (this.sin_stepfreq[i] != f) {
                this.sin_stepfreq[i] = f;
                double fr = 440.0 * Math.exp((f - 6900.0) * (Math.log(2.0) / 1200.0));
                this.sin_step[i] = fr * this.sin_factor;
            }
            double p = this.sin_phase[i];
            p += this.sin_step[i];
            while (p > Math.PI * 2) {
                p -= Math.PI * 2;
            }
            this.out[i][0] = 0.5 + Math.sin(p) * 0.5;
            this.sin_phase[i] = p;
        }
    }

    @Override
    public double[] get(int instance, String name) {
        if (instance >= this.used_count) {
            this.used_count = instance + 1;
        }
        if (name == null) {
            return this.out[instance];
        }
        if (name.equals("delay")) {
            return this.delay[instance];
        }
        if (name.equals("delay2")) {
            return this.delay2[instance];
        }
        if (name.equals("freq")) {
            return this.freq[instance];
        }
        return null;
    }
}

