/*
 * Decompiled with CFR 0.152.
 */
package com.bene.media.sound;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.sound.midi.Patch;

public final class SoftTuning {
    private String name = null;
    private final double[] tuning = new double[128];
    private Patch patch = null;

    public SoftTuning() {
        this.name = "12-TET";
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
    }

    public SoftTuning(byte[] data) {
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
        this.load(data);
    }

    public SoftTuning(Patch patch) {
        this.patch = patch;
        this.name = "12-TET";
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
    }

    public SoftTuning(Patch patch, byte[] data) {
        this.patch = patch;
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
        this.load(data);
    }

    private boolean checksumOK(byte[] data) {
        int x = data[1] & 0xFF;
        for (int i = 2; i < data.length - 2; ++i) {
            x ^= data[i] & 0xFF;
        }
        return (data[data.length - 2] & 0xFF) == (x & 0x7F);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void load(byte[] data) {
        if (data.length < 2) {
            return;
        }
        if ((data[1] & 0xFF) != 126) {
            if ((data[1] & 0xFF) != 127) return;
        }
        if (data.length < 4) {
            return;
        }
        int subid1 = data[3] & 0xFF;
        switch (subid1) {
            case 8: {
                if (data.length < 5) {
                    return;
                }
                int subid2 = data[4] & 0xFF;
                switch (subid2) {
                    case 1: {
                        int r = 22;
                        if (data.length < 384 + r) return;
                        this.name = new String(data, 6, 16, StandardCharsets.US_ASCII);
                        int i = 0;
                        while (i < 128) {
                            int xx = data[r++] & 0xFF;
                            int yy = data[r++] & 0xFF;
                            int zz = data[r++] & 0xFF;
                            if (xx != 127 || yy != 127 || zz != 127) {
                                this.tuning[i] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            ++i;
                        }
                        return;
                    }
                    case 2: {
                        int r;
                        int ll;
                        if (data.length < 7 || data.length < (ll = data[6] & 0xFF) * 4 + (r = 7)) return;
                        int i = 0;
                        while (i < ll) {
                            int kk = data[r++] & 0xFF;
                            int xx = data[r++] & 0xFF;
                            int yy = data[r++] & 0xFF;
                            int zz = data[r++] & 0xFF;
                            if (xx != 127 || yy != 127 || zz != 127) {
                                this.tuning[kk] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            ++i;
                        }
                        return;
                    }
                    case 4: {
                        if (!this.checksumOK(data) || data.length < 407) return;
                        this.name = new String(data, 7, 16, StandardCharsets.US_ASCII);
                        int r = 23;
                        int i = 0;
                        while (i < 128) {
                            int xx = data[r++] & 0xFF;
                            int yy = data[r++] & 0xFF;
                            int zz = data[r++] & 0xFF;
                            if (xx != 127 || yy != 127 || zz != 127) {
                                this.tuning[i] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            ++i;
                        }
                        return;
                    }
                    case 5: {
                        int i;
                        if (!this.checksumOK(data) || data.length < 35) return;
                        this.name = new String(data, 7, 16, StandardCharsets.US_ASCII);
                        int[] octave_tuning = new int[12];
                        for (i = 0; i < 12; ++i) {
                            octave_tuning[i] = (data[i + 23] & 0xFF) - 64;
                        }
                        i = 0;
                        while (i < this.tuning.length) {
                            this.tuning[i] = i * 100 + octave_tuning[i % 12];
                            ++i;
                        }
                        return;
                    }
                    case 6: {
                        int i;
                        if (!this.checksumOK(data) || data.length < 47) return;
                        this.name = new String(data, 7, 16, StandardCharsets.US_ASCII);
                        double[] octave_tuning = new double[12];
                        for (i = 0; i < 12; ++i) {
                            int v = (data[i * 2 + 23] & 0xFF) * 128 + (data[i * 2 + 24] & 0xFF);
                            octave_tuning[i] = ((double)v / 8192.0 - 1.0) * 100.0;
                        }
                        i = 0;
                        while (i < this.tuning.length) {
                            this.tuning[i] = (double)(i * 100) + octave_tuning[i % 12];
                            ++i;
                        }
                        return;
                    }
                    case 7: {
                        int ll;
                        if (data.length < 8 || data.length < (ll = data[7] & 0xFF) * 4 + 8) return;
                        int r = 8;
                        int i = 0;
                        while (i < ll) {
                            int kk = data[r++] & 0xFF;
                            int xx = data[r++] & 0xFF;
                            int yy = data[r++] & 0xFF;
                            int zz = data[r++] & 0xFF;
                            if (xx != 127 || yy != 127 || zz != 127) {
                                this.tuning[kk] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            ++i;
                        }
                        return;
                    }
                    case 8: {
                        int i;
                        if (data.length < 20) return;
                        int[] octave_tuning = new int[12];
                        for (i = 0; i < 12; ++i) {
                            octave_tuning[i] = (data[i + 8] & 0xFF) - 64;
                        }
                        i = 0;
                        while (i < this.tuning.length) {
                            this.tuning[i] = i * 100 + octave_tuning[i % 12];
                            ++i;
                        }
                        return;
                    }
                    case 9: {
                        int i;
                        if (data.length < 32) return;
                        double[] octave_tuning = new double[12];
                        for (i = 0; i < 12; ++i) {
                            int v = (data[i * 2 + 8] & 0xFF) * 128 + (data[i * 2 + 9] & 0xFF);
                            octave_tuning[i] = ((double)v / 8192.0 - 1.0) * 100.0;
                        }
                        i = 0;
                        while (i < this.tuning.length) {
                            this.tuning[i] = (double)(i * 100) + octave_tuning[i % 12];
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
        }
    }

    public double[] getTuning() {
        return Arrays.copyOf(this.tuning, this.tuning.length);
    }

    public double getTuning(int noteNumber) {
        return this.tuning[noteNumber];
    }

    public Patch getPatch() {
        return this.patch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

