/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Timer;
import com.spacekiller.util.TimerQueue;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.workbench.Workbench;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceRegistry;
import com.waxmonster.studio.Layout;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.PresetRegistry;
import com.waxmonster.studio.PresetStore;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.impl.InvalidConnection;
import com.waxmonster.studio.impl.MissingPort;
import com.waxmonster.studio.impl.MissingPortType;
import com.waxmonster.studio.impl.StudioXmlUtil;
import com.waxmonster.studio.view.StudioView;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.undo.UndoManager;

public class DefaultStudio
extends Studio {
    private static final Logger logger = Logger.getLogger(DefaultStudio.class.getName());
    private final DeviceRegistry deviceRegistry;
    private final PresetRegistry presetRegistry;
    private final PresetStore presetStore;
    private final Clock clock;
    private final ThreadManager threadManager;
    private final TimerQueue timerQueue;
    private final StudioView studioView;
    private Icon missingPortTypeIconColor16;
    private int timerInterval = 100;

    public DefaultStudio(DeviceRegistry deviceRegistry, PresetRegistry presetRegistry, PresetStore presetStore, Clock clock, TimerQueue timerQueue, ThreadManager threadManager, StudioView studioView) {
        this.deviceRegistry = deviceRegistry;
        this.presetRegistry = presetRegistry;
        this.presetStore = presetStore;
        this.clock = clock;
        this.timerQueue = timerQueue;
        this.threadManager = threadManager;
        this.studioView = studioView;
        if (timerQueue != null) {
            timerQueue.start();
        }
    }

    public final DeviceRegistry getDeviceRegistry() {
        return this.deviceRegistry;
    }

    public final PresetRegistry getPresetRegistry() {
        return this.presetRegistry;
    }

    public final PresetStore getPresetStore() {
        return this.presetStore;
    }

    public final long getTime() {
        return this.clock.nanos();
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final ThreadManager getThreadManager() {
        return this.threadManager;
    }

    protected void setPortId(Port port, String id) {
        super.setPortId(port, id);
    }

    protected void setDeviceId(Device device, String id) {
        super.setDeviceId(device, id);
    }

    protected void setLayoutId(Layout layout, String id) {
        super.setLayoutId(layout, id);
    }

    protected void handleConnectionAdded(Connection conn) {
    }

    protected void handleConnectionRemoved(Connection conn) {
    }

    protected void handleDeviceAdded(Device device) {
    }

    protected void handleDeviceRemoved(Device device) {
    }

    protected void handleDeviceRenamed(Device device, String name) {
    }

    protected void handleDeviceTitleChanged(Device device, String title) {
    }

    protected void handleDeviceEnabled(Device device) {
    }

    protected void handleDeviceDisabled(Device device) {
    }

    protected void handlePortAdded(Port port, Device device) {
    }

    protected void handlePortRemoved(Port port, Device device) {
    }

    protected void handlePortRenamed(Port port) {
    }

    protected void handleControlAdded(Control control, int index, Device device) {
    }

    protected void handleControlRemoved(Control control, int index, Device device) {
    }

    public void setDirectory(File directory) {
        super.setDirectory(directory);
    }

    public void load(File sourceFile) throws StudioException, IOException {
        this.load(sourceFile, null);
    }

    public void load(File sourceFile, Runnable postStudioSettingsHook) throws StudioException, IOException {
        StudioXmlUtil util = new StudioXmlUtil(postStudioSettingsHook);
        util.loadStudioConfig(this, sourceFile);
    }

    public void load(InputStream sourceStream, Runnable postStudioSettingsHook) throws StudioException, IOException {
        StudioXmlUtil util = new StudioXmlUtil(postStudioSettingsHook);
        util.loadStudioConfig(this, sourceStream);
    }

    public void save(File targetFile) throws StudioException, IOException {
        this.generateDeviceIds();
        this.generatePortIds();
        StudioXmlUtil util = new StudioXmlUtil();
        util.saveStudioConfig(this, targetFile);
    }

    protected void generatePortIds() throws StudioException {
        HashSet<String> portIds = new HashSet<String>();
        long nextPortId = 1L;
        Device[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            String id;
            Port port;
            int k;
            Device device = devices[i];
            Port[] ports = device.getPorts();
            for (k = 0; k < ports.length; ++k) {
                port = ports[k];
                id = this.getPortId(port);
                if (id != null && portIds.add(id)) continue;
                while (!portIds.add(id = "Port#" + String.valueOf(nextPortId++))) {
                }
                this.setPortId(port, id);
            }
            ports = device.getMissingPorts();
            for (k = 0; k < ports.length; ++k) {
                port = ports[k];
                id = this.getPortId(port);
                if (id != null && portIds.add(id)) continue;
                while (!portIds.add(id = "Port#" + String.valueOf(nextPortId++))) {
                }
                this.setPortId(port, id);
            }
        }
    }

    protected void generateDeviceIds() throws StudioException {
        HashSet<String> devIds = new HashSet<String>();
        long nextDevId = 1L;
        Device[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            Device device = devices[i];
            String id = this.getDeviceId(device);
            if (id != null && devIds.add(id)) continue;
            while (!devIds.add(id = "Device#" + String.valueOf(nextDevId++))) {
            }
            this.setDeviceId(device, id);
        }
    }

    protected void reportDeviceError(Device device, LogRecord error) {
        super.reportDeviceError(device, error);
    }

    public PortType createMissingPortType(String name, String tooltip, Object preferredLayoutConstraint) throws StudioException {
        Icon iconColor16 = this.getMissingPortTypeIconColor16();
        return new MissingPortType(name, tooltip, iconColor16, preferredLayoutConstraint);
    }

    public Port createMissingPort(Device device, PortType type, String name, String title, String tooltip) throws StudioException {
        MissingPort port = new MissingPort(name, type, device);
        port.setTitle(title);
        port.setTooltip(tooltip);
        return port;
    }

    protected void addMissingPort(Port port, Device device) throws StudioException {
        super.addMissingPort(port, device);
    }

    protected void removeMissingPort(Port port, Device device) throws StudioException {
        super.removeMissingPort(port, device);
    }

    protected void addMissingControl(Control control, Device device) {
        super.addMissingControl(control, device);
    }

    protected void removeMissingControl(Control control, Device device) {
        super.removeMissingControl(control, device);
    }

    public Connection addInvalidConnection(Port source, Port target) throws StudioException {
        InvalidConnection conn = new InvalidConnection(source, target);
        super.addInvalidConnection((Connection)conn);
        return conn;
    }

    protected synchronized void registerDevice(Device device) {
        super.registerDevice(device);
    }

    protected synchronized void unregisterDevice(Device device) {
        super.unregisterDevice(device);
    }

    protected Icon getMissingPortTypeIconColor16() {
        if (this.missingPortTypeIconColor16 == null) {
            this.setMissingPortTypeIconColor16(Tools.getIcon(StudioXmlUtil.class, (String)"/com/waxmonster/studio/impl/icons/missing_port_icon16.png"));
        }
        return this.missingPortTypeIconColor16;
    }

    protected void setMissingPortTypeIconColor16(Icon missingPortTypeIconColor16) {
        this.missingPortTypeIconColor16 = missingPortTypeIconColor16;
    }

    public synchronized Connection resolveInvalidConnection(Connection conn) throws StudioException {
        Port port;
        int i;
        Port[] ports;
        String portName;
        if (conn == null) {
            return null;
        }
        Port oldSource = conn.getSource();
        Port oldTarget = conn.getTarget();
        if (oldSource == null || oldTarget == null) {
            return null;
        }
        Device sourceDev = oldSource.getDevice();
        Device targetDev = oldTarget.getDevice();
        if (sourceDev == null || targetDev == null) {
            return null;
        }
        if (!this.isInvalidConnection(conn)) {
            return null;
        }
        Port newSource = null;
        Port newTarget = null;
        if (sourceDev.isMissingPort(oldSource) && (portName = oldSource.getName()) != null) {
            ports = sourceDev.getPorts();
            for (i = 0; i < ports.length; ++i) {
                port = ports[i];
                if (!portName.equals(port.getName())) continue;
                newSource = port;
                break;
            }
        }
        if (targetDev.isMissingPort(oldTarget) && (portName = oldTarget.getName()) != null) {
            ports = targetDev.getPorts();
            for (i = 0; i < ports.length; ++i) {
                port = ports[i];
                if (!portName.equals(port.getName())) continue;
                newTarget = port;
                break;
            }
        }
        Port source = oldSource;
        Port target = oldTarget;
        if (newSource != null) {
            source = newSource;
            if (newTarget != null) {
                target = newTarget;
            }
        } else if (newTarget != null) {
            target = newTarget;
        } else {
            return null;
        }
        Connection newConnection = null;
        if (this.isConnectable(source, target)) {
            try {
                newConnection = this.connect(source, target);
                if (newConnection != null) {
                    this.removeInvalidConnection(conn);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (newConnection == null) {
            this.removeInvalidConnection(conn);
            newConnection = this.addInvalidConnection(source, target);
        }
        if (newConnection != null) {
            this.cleanupMissingPorts(sourceDev);
            this.cleanupMissingPorts(targetDev);
        }
        return newConnection;
    }

    public UndoManager getUndoManager() {
        Workbench workbench;
        if (this.studioView != null && (workbench = this.studioView.getWorkbench()) != null) {
            return workbench.getUndoManager();
        }
        return null;
    }

    public Timer createTimer(Runnable target) {
        return this.timerQueue.createTimer(target, this.timerInterval, true);
    }

    public Timer createTimer(Runnable target, int millis) {
        return this.timerQueue.createTimer(target, millis, true);
    }

    public int getTimerInterval() {
        return this.timerInterval;
    }

    public void setTimerInterval(int timerInterval) {
        this.timerInterval = timerInterval;
    }
}

