/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.impl;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.Platform;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceInfoListener;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.DeviceRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceRegistryImpl
implements DeviceRegistry {
    private static final Logger logger = Platform.getLogger(DeviceRegistryImpl.class);
    private final ListenerList<DeviceInfoListener> deviceInfoListeners = new ListenerList(DeviceInfoListener.class);
    private List wrapperList = new LinkedList();
    private Map deviceProviderMap = new HashMap();
    private Map deviceInfoMap = new HashMap();

    public void addDeviceInfoListener(DeviceInfoListener listener) {
        if (listener == null) {
            return;
        }
        this.deviceInfoListeners.add((Object)listener);
    }

    public void removeDeviceInfoListener(DeviceInfoListener listener) {
        if (listener == null) {
            return;
        }
        this.deviceInfoListeners.remove((Object)listener);
    }

    protected void fireDeviceInfoAdded(DeviceInfo info) {
        for (DeviceInfoListener l : (DeviceInfoListener[])this.deviceInfoListeners.array()) {
            l.deviceInfoAdded(info);
        }
    }

    protected void fireDeviceInfoRemoved(DeviceInfo info) {
        for (DeviceInfoListener l : (DeviceInfoListener[])this.deviceInfoListeners.array()) {
            l.deviceInfoRemoved(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeviceInfoAdded(DeviceProviderWrapper wrapper, DeviceInfo info) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleDeviceInfoAdded: provider=" + wrapper.getProvider() + ", info=" + info);
        }
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            if (this.deviceInfoMap.containsKey(info)) {
                return;
            }
            this.deviceInfoMap.put(info, wrapper);
        }
        wrapper.addDeviceInfo(info);
        this.fireDeviceInfoAdded(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeviceInfoRemoved(DeviceProviderWrapper wrapper, DeviceInfo info) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleDeviceInfoRemoved: provider=" + wrapper.getProvider() + ", info=" + info);
        }
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            DeviceProviderWrapper w = (DeviceProviderWrapper)this.deviceInfoMap.get(info);
            if (w == null || w != wrapper) {
                return;
            }
            this.deviceInfoMap.remove(info);
        }
        wrapper.removeDeviceInfo(info);
        this.fireDeviceInfoRemoved(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeviceProvider(DeviceProvider provider) {
        DeviceProviderWrapper wrapper;
        if (provider == null) {
            return;
        }
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            wrapper = (DeviceProviderWrapper)this.deviceProviderMap.get(provider);
            if (wrapper != null) {
                return;
            }
            wrapper = new DeviceProviderWrapper(provider);
            this.wrapperList.add(wrapper);
            this.deviceProviderMap.put(provider, wrapper);
        }
        try {
            provider.addDeviceInfoListener((DeviceInfoListener)wrapper);
        }
        finally {
            this.updateDeviceInfo(wrapper, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeviceProvider(DeviceProvider provider) {
        DeviceProviderWrapper wrapper;
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            wrapper = (DeviceProviderWrapper)this.deviceProviderMap.remove(provider);
            if (wrapper == null) {
                return;
            }
            this.wrapperList.remove(wrapper);
        }
        try {
            provider.removeDeviceInfoListener((DeviceInfoListener)wrapper);
        }
        finally {
            this.updateDeviceInfo(wrapper, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDeviceInfo() {
        DeviceProviderWrapper[] wrappers;
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            wrappers = this.wrapperList.toArray(new DeviceProviderWrapper[this.wrapperList.size()]);
        }
        int n = wrappers.length;
        for (int i = 0; i < n; ++i) {
            this.updateDeviceInfo(wrappers[i], true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDeviceInfo(DeviceProvider provider) {
        DeviceProviderWrapper wrapper;
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            wrapper = (DeviceProviderWrapper)this.deviceProviderMap.get(provider);
        }
        if (wrapper != null && wrapper.getProvider() == provider) {
            this.updateDeviceInfo(wrapper, true, true);
        }
    }

    protected void updateDeviceInfo(DeviceProviderWrapper wrapper, boolean active, boolean refresh) {
        DeviceProvider provider = wrapper.getProvider();
        DeviceInfo[] infos = null;
        if (active) {
            if (refresh) {
                provider.refreshDeviceInfo();
            }
            infos = provider.getDeviceInfo();
        }
        HashSet oldInfo = new HashSet();
        wrapper.getDeviceInfos(oldInfo);
        LinkedList<DeviceInfo> newInfo = new LinkedList<DeviceInfo>();
        int num = infos == null ? 0 : infos.length;
        for (int i = 0; i < num; ++i) {
            DeviceInfo info = infos[i];
            if (info == null || oldInfo.remove(info)) continue;
            newInfo.add(info);
        }
        for (DeviceInfo info : newInfo) {
            this.handleDeviceInfoAdded(wrapper, info);
        }
        for (DeviceInfo info : oldInfo) {
            this.handleDeviceInfoRemoved(wrapper, info);
        }
    }

    public synchronized DeviceInfo[] getDeviceInfo() {
        LinkedList dest = new LinkedList();
        for (DeviceProviderWrapper wrapper : this.wrapperList) {
            wrapper.getDeviceInfos(dest);
        }
        return dest.toArray(new DeviceInfo[dest.size()]);
    }

    public DeviceProvider getDeviceProvider(DeviceInfo info) {
        DeviceProviderWrapper wrapper = (DeviceProviderWrapper)this.deviceInfoMap.get(info);
        if (wrapper != null) {
            return wrapper.getProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceProvider getDeviceProvider(String name) {
        DeviceProviderWrapper[] wrappers;
        if (name == null) {
            return null;
        }
        DeviceRegistryImpl deviceRegistryImpl = this;
        synchronized (deviceRegistryImpl) {
            wrappers = this.wrapperList.toArray(new DeviceProviderWrapper[this.wrapperList.size()]);
        }
        int n = wrappers.length;
        for (int i = 0; i < n; ++i) {
            DeviceProvider provider = wrappers[i].getProvider();
            if (!name.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    protected class DeviceProviderWrapper
    implements DeviceInfoListener {
        private final DeviceProvider provider;
        private List deviceInfoList;

        public DeviceProviderWrapper(DeviceProvider provider) {
            this.provider = provider;
            this.deviceInfoList = new LinkedList();
        }

        public void deviceInfoAdded(DeviceInfo info) {
            DeviceRegistryImpl.this.handleDeviceInfoAdded(this, info);
        }

        public void deviceInfoRemoved(DeviceInfo info) {
            DeviceRegistryImpl.this.handleDeviceInfoRemoved(this, info);
        }

        protected final DeviceProvider getProvider() {
            return this.provider;
        }

        protected synchronized void addDeviceInfo(DeviceInfo info) {
            if (info == null) {
                return;
            }
            this.deviceInfoList.add(info);
        }

        protected synchronized void removeDeviceInfo(DeviceInfo info) {
            this.deviceInfoList.remove(info);
        }

        protected synchronized void getDeviceInfos(Collection dest) {
            dest.addAll(this.deviceInfoList);
        }

        public String toString() {
            return super.toString() + "[" + this.provider + "]";
        }
    }
}

