/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.impl;

import com.spacekiller.util.Platform;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.PresetProvider;
import com.waxmonster.studio.PresetRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PresetRegistryImpl
implements PresetRegistry {
    private static final Logger logger = Platform.getLogger(PresetRegistryImpl.class);
    private List providers = new ArrayList();

    public synchronized void addPresetProvider(PresetProvider provider) {
        if (provider == null) {
            return;
        }
        if (this.providers.contains(provider)) {
            return;
        }
        this.providers.add(provider);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("PresetProvider added: " + provider);
        }
    }

    public synchronized void removePresetProvider(PresetProvider provider) {
        if (this.providers.remove(provider) && logger.isLoggable(Level.FINER)) {
            logger.finer("PresetProvider removed: " + provider);
        }
    }

    public synchronized void searchByDeviceName(String deviceName, Collection dst) {
        if (deviceName == null) {
            return;
        }
        int providerCount = this.providers.size();
        for (int i = 0; i < providerCount; ++i) {
            PresetProvider provider = (PresetProvider)this.providers.get(i);
            Preset[] presets = provider.getPresets();
            if (presets == null) continue;
            for (Preset preset : presets) {
                if (preset == null || !deviceName.equals(preset.getDeviceName())) continue;
                dst.add(preset);
            }
        }
    }

    public synchronized void searchByPresetName(Pattern presetNamePattern, String deviceName, Collection dst) {
        if (presetNamePattern == null) {
            return;
        }
        int providerCount = this.providers.size();
        for (int i = 0; i < providerCount; ++i) {
            PresetProvider provider = (PresetProvider)this.providers.get(i);
            Preset[] presets = provider.getPresets();
            if (presets == null) continue;
            for (Preset preset : presets) {
                Matcher matcher;
                String name;
                if (preset == null || deviceName != null && !deviceName.equals(preset.getDeviceName()) || (name = preset.getPresetName()) == null || !(matcher = presetNamePattern.matcher(name)).matches()) continue;
                dst.add(preset);
            }
        }
    }
}

