/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.impl;

import com.spacekiller.util.media.control.Control;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.DeviceRegistry;
import com.waxmonster.studio.Layout;
import com.waxmonster.studio.LayoutPanel;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.impl.DefaultStudio;
import com.waxmonster.studio.impl.MissingControl;
import com.waxmonster.studio.impl.MissingDevice;
import com.waxmonster.studio.impl.MissingPort;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StudioXmlUtil {
    public static final String NAMESPACE = "https://waxmonster.com/studio/";
    public static final String XSD_URLS = "https://waxmonster.com/schema/ waxmonster_studio_V1.xsd";
    private static final Logger logger = Logger.getLogger(StudioXmlUtil.class.getName());
    private Runnable postStudioSettingsHook;
    private DocumentBuilder documentBuilder;
    private Map loadedDevicesById = new HashMap();
    private Map loadedPortsById = new HashMap();

    public StudioXmlUtil() {
    }

    public StudioXmlUtil(Runnable postStudioSettingsHook) {
        this();
        this.postStudioSettingsHook = postStudioSettingsHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStudioConfig(DefaultStudio studio, File file) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element elStudio = this.createStudioElement(doc, studio, file);
            doc.appendChild(elStudio);
            DOMSource source = new DOMSource(doc);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            FileOutputStream fos = new FileOutputStream(file);
            try {
                StreamResult result = new StreamResult(fos);
                trans.transform(source, result);
            }
            finally {
                fos.close();
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element createStudioElement(Document doc, DefaultStudio studio, File studioFile) {
        String layoutId;
        Element elConn;
        Connection conn;
        int i;
        Rectangle viewBounds;
        Element elStudio = doc.createElementNS(NAMESPACE, "studio");
        elStudio.setPrefix("tns");
        Attr attr = doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
        attr.setValue(XSD_URLS);
        elStudio.setAttributeNode(attr);
        String comment = studio.getComment();
        if (comment != null) {
            elStudio.setAttribute("comment", comment);
        }
        if ((viewBounds = studio.getViewBounds()) != null) {
            elStudio.setAttribute("viewBounds", String.valueOf(viewBounds.x) + ", " + String.valueOf(viewBounds.y) + ", " + String.valueOf(viewBounds.width) + ", " + String.valueOf(viewBounds.height));
        }
        Device[] devices = studio.getDevices();
        for (int i2 = 0; i2 < devices.length; ++i2) {
            Device device = devices[i2];
            Element elDevice = this.createDeviceElement(doc, studio, device);
            if (elDevice == null) continue;
            elStudio.appendChild(elDevice);
        }
        Connection[] conns = studio.getConnections();
        for (i = 0; i < conns.length; ++i) {
            conn = conns[i];
            elConn = this.createConnectionElement(doc, studio, conn);
            if (elConn == null) continue;
            elStudio.appendChild(elConn);
        }
        conns = studio.getInvalidConnections();
        for (i = 0; i < conns.length; ++i) {
            conn = conns[i];
            elConn = this.createConnectionElement(doc, studio, conn);
            if (elConn == null) continue;
            elStudio.appendChild(elConn);
        }
        Preset[] presets = studio.getPresets();
        for (int i3 = 0; i3 < presets.length; ++i3) {
            Preset preset = presets[i3];
            Element elPreset = this.createPresetElement(doc, studio, preset);
            if (elPreset == null) continue;
            elStudio.appendChild(elPreset);
        }
        Layout[] layouts = studio.getLayouts();
        for (int i4 = 0; i4 < layouts.length; ++i4) {
            Layout layout = layouts[i4];
            Element elLayout = this.createLayoutElement(doc, studio, layout);
            if (elLayout == null) continue;
            elStudio.appendChild(elLayout);
        }
        Layout layout = studio.getLayout();
        if (layout != null && (layoutId = studio.getLayoutId(layout)) != null) {
            elStudio.setAttribute("layoutId", layoutId);
        }
        return elStudio;
    }

    protected Element createDeviceElement(Document doc, DefaultStudio studio, Device device) {
        Element elPort;
        int i;
        Control[] controls;
        Properties props;
        Point position;
        String presetName;
        String deviceId = studio.getDeviceId(device);
        if (deviceId == null) {
            logger.warning("Missing device identifier: device=" + device);
        }
        String deviceName = device.getName();
        DeviceProvider provider = device.getProvider();
        String providerName = provider.getName();
        Element el = doc.createElement("device");
        el.setAttribute("id", String.valueOf(deviceId));
        el.setAttribute("provider", String.valueOf(providerName));
        el.setAttribute("name", String.valueOf(deviceName));
        String title = device.getTitle();
        if (title != null) {
            el.setAttribute("title", title);
        }
        if (!device.isEnabled()) {
            el.setAttribute("enabled", String.valueOf(device.isEnabled()));
        }
        if ((presetName = device.getPresetName()) != null) {
            el.setAttribute("presetName", presetName);
        }
        if ((position = device.getPosition()) != null) {
            el.setAttribute("position", String.valueOf(position.x) + ", " + String.valueOf(position.y));
        }
        if ((props = device.getProperties()) != null) {
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(props);
            for (Map.Entry<Object, Object> me : map.entrySet()) {
                Element prop = this.createPropertyElement(doc, me, "property");
                if (prop == null) continue;
                el.appendChild(prop);
            }
        }
        if ((controls = device.getControls()) != null) {
            for (Control control : controls) {
                if (control == null) continue;
                try {
                    Element ctrl = this.createControlElement(doc, control, "control");
                    if (ctrl == null) continue;
                    el.appendChild(ctrl);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        Port[] ports = device.getPorts();
        for (i = 0; i < ports.length; ++i) {
            Port port = ports[i];
            elPort = this.createPortElement(doc, studio, device, port);
            if (elPort == null) continue;
            el.appendChild(elPort);
        }
        ports = device.getMissingPorts();
        for (i = 0; i < ports.length; ++i) {
            Port port = ports[i];
            elPort = this.createPortElement(doc, studio, device, port);
            if (elPort == null) continue;
            el.appendChild(elPort);
        }
        return el;
    }

    protected Element createPortElement(Document doc, DefaultStudio studio, Device device, Port port) {
        String portId = studio.getPortId(port);
        if (portId == null) {
            logger.warning("Missing port identifier: port=" + port + ", device=" + device);
        }
        String portName = port.getName();
        String portTitle = port.getTitle();
        PortType portType = port.getType();
        String portTypeName = portType.getName();
        Element el = doc.createElement("port");
        el.setAttribute("id", String.valueOf(portId));
        el.setAttribute("type", String.valueOf(portTypeName));
        el.setAttribute("name", String.valueOf(portName));
        if (portTitle != null) {
            el.setAttribute("title", portTitle);
        }
        return el;
    }

    protected Element createConnectionElement(Document doc, DefaultStudio studio, Connection conn) {
        Port sourcePort = conn.getSource();
        String sourcePortId = studio.getPortId(sourcePort);
        Port targetPort = conn.getTarget();
        String targetPortId = studio.getPortId(targetPort);
        Element el = doc.createElement("connection");
        el.setAttribute("sourcePortId", String.valueOf(sourcePortId));
        el.setAttribute("targetPortId", String.valueOf(targetPortId));
        return el;
    }

    protected Element createPresetElement(Document doc, DefaultStudio studio, Preset preset) {
        Map controlMap;
        Element el = doc.createElement("preset");
        el.setAttribute("name", String.valueOf(preset.getPresetName()));
        el.setAttribute("deviceName", String.valueOf(preset.getDeviceName()));
        el.setAttribute("providerName", String.valueOf(preset.getProviderName()));
        Properties props = preset.getProperties();
        if (props != null) {
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(props);
            for (Map.Entry<Object, Object> me : map.entrySet()) {
                Element prop = this.createPropertyElement(doc, me, "property");
                if (prop == null) continue;
                el.appendChild(prop);
            }
        }
        if ((controlMap = preset.getControls()) != null) {
            TreeMap map = new TreeMap(controlMap);
            for (Map.Entry me : map.entrySet()) {
                Element prop = this.createControlElement(doc, me, "control");
                if (prop == null) continue;
                el.appendChild(prop);
            }
        }
        return el;
    }

    protected Element createPropertyElement(Document doc, Map.Entry entry, String tagName) {
        Object key = entry.getKey();
        Object value = entry.getValue();
        if (key == null || value == null) {
            return null;
        }
        Element el = doc.createElement(tagName);
        el.setAttribute("key", String.valueOf(key));
        el.setAttribute("value", String.valueOf(value));
        return el;
    }

    protected Element createControlElement(Document doc, Control control, String tagName) {
        String name = control.getName();
        Object value = control.getValue();
        Element el = doc.createElement(tagName);
        el.setAttribute("name", String.valueOf(name));
        el.setAttribute("value", String.valueOf(value));
        return el;
    }

    protected Element createControlElement(Document doc, Map.Entry entry, String tagName) {
        Object name = entry.getKey();
        Object value = entry.getValue();
        Element el = doc.createElement(tagName);
        el.setAttribute("name", String.valueOf(name));
        el.setAttribute("value", String.valueOf(value));
        return el;
    }

    protected Element createLayoutElement(Document doc, DefaultStudio studio, Layout layout) {
        Element el = doc.createElement("layout");
        String id = studio.getLayoutId(layout);
        el.setAttribute("id", String.valueOf(id));
        el.setAttribute("name", String.valueOf(layout.getName()));
        String title = layout.getTitle();
        if (title != null) {
            el.setAttribute("title", String.valueOf(layout.getTitle()));
        }
        int num = layout.getPanelCount();
        for (int i = 0; i < num; ++i) {
            Element elPanel;
            LayoutPanel panel = layout.getPanelAt(i);
            if (panel == null || (elPanel = this.createPanelElement(doc, studio, panel)) == null) continue;
            el.appendChild(elPanel);
        }
        return el;
    }

    protected Element createPanelElement(Document doc, DefaultStudio studio, LayoutPanel panel) {
        Rectangle detachedBounds;
        Device device = panel.getDevice();
        if (device == null) {
            return null;
        }
        String deviceId = studio.getDeviceId(device);
        if (deviceId == null) {
            return null;
        }
        Element el = doc.createElement("panel");
        el.setAttribute("deviceId", deviceId);
        Rectangle editorBounds = panel.getEditorBounds();
        if (editorBounds != null) {
            el.setAttribute("editorBounds", StudioXmlUtil.formatRectangle(editorBounds));
        }
        if (panel.isEditorVisible()) {
            el.setAttribute("editorVisible", String.valueOf(true));
            if (panel.isEditorIconified()) {
                el.setAttribute("editorIconified", String.valueOf(true));
            }
        }
        if (panel.isEditorDetached()) {
            el.setAttribute("editorDetached", String.valueOf(true));
        }
        if ((detachedBounds = panel.getEditorDetachedBounds()) != null) {
            el.setAttribute("editorDetachedBounds", StudioXmlUtil.formatRectangle(detachedBounds));
        }
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStudioConfig(DefaultStudio studio, File file) throws StudioException, IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.loadStudioConfig(studio, fis);
        }
        finally {
            fis.close();
        }
    }

    public void loadStudioConfig(DefaultStudio studio, InputStream in) throws StudioException, IOException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList list = doc.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                if ("studio".equals(node.getLocalName())) {
                    this.readStudio(studio, node);
                    continue;
                }
                logger.warning("Unexpected element name: " + node.getLocalName());
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isStudioFile(InputStream in) throws StudioException, IOException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList list = doc.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                if (!"studio".equals(node.getLocalName()) || !(node instanceof Element)) continue;
                return true;
            }
            return false;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String readStudioComment(InputStream in) throws StudioException, IOException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList list = doc.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                if (!"studio".equals(node.getLocalName()) || !(node instanceof Element)) continue;
                Element studioElement = (Element)node;
                String comment = this.getAttribute(studioElement, "comment");
                return comment;
            }
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readStudio(DefaultStudio studio, Node studioNode) throws StudioException {
        Layout defaultLayout = studio.getLayout();
        if (defaultLayout != null) {
            studio.removeLayout(defaultLayout);
        }
        String layoutId = null;
        if (studioNode instanceof Element) {
            Element studioElement = (Element)studioNode;
            String comment = this.getAttribute(studioElement, "comment");
            studio.setComment(comment);
            String sViewBounds = this.getAttribute(studioElement, "viewBounds");
            if (sViewBounds != null) {
                try {
                    studio.setViewBounds(StudioXmlUtil.parseRectangle(sViewBounds));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            layoutId = this.getAttribute(studioElement, "layoutId");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Studio settings loaded: " + (Object)((Object)studio));
        }
        if (this.postStudioSettingsHook != null) {
            this.postStudioSettingsHook.run();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading devices: " + (Object)((Object)studio));
        }
        LinkedList<Device> deviceList = new LinkedList<Device>();
        HashMap<String, Device> deviceMap = new HashMap<String, Device>();
        NodeList list = studioNode.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String name = el.getNodeName();
            if ("device".equals(name)) {
                Device device = this.loadDevice(studio, el);
                if (device == null) continue;
                deviceList.add(device);
                String devId = studio.getDeviceId(device);
                if (devId == null) continue;
                deviceMap.put(devId, device);
                continue;
            }
            if ("connection".equals(name)) {
                this.loadConnection(studio, el);
                continue;
            }
            if ("preset".equals(name)) {
                this.loadPreset(studio, el);
                continue;
            }
            if ("layout".equals(name)) {
                this.loadLayout(studio, el);
                continue;
            }
            logger.warning("Unexpected element name: " + name);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Devices loaded: " + deviceList.size());
        }
        int addedDeviceCount = 0;
        for (Device device : deviceList) {
            try {
                studio.unregisterDevice(device);
                studio.addDevice(device);
                ++addedDeviceCount;
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Device added: " + device);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Devices added: " + addedDeviceCount);
        }
        for (Device device : deviceList) {
            studio.validateDevice(device);
        }
        Layout layout = null;
        int num = studio.getLayoutCount();
        for (int i = 0; i < num; ++i) {
            Layout lay = studio.getLayoutAt(i);
            if (lay == null || layoutId == null || !layoutId.equals(studio.getLayoutId(lay))) continue;
            layout = lay;
        }
        if (layout == null) {
            if (studio.getLayoutCount() > 0) {
                layout = studio.getLayoutAt(0);
            }
            if (layout == null) {
                layout = defaultLayout;
                if (layout == null) {
                    layout = this.loadDefaultLayout(studio);
                } else {
                    studio.addLayout(layout);
                }
            }
        }
        studio.setLayout(layout);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Studio loaded: " + (Object)((Object)studio));
        }
    }

    protected Device loadDevice(DefaultStudio studio, Element elDevice) throws StudioException {
        String portName;
        String value;
        String deviceId = this.getAttribute(elDevice, "id");
        if (this.loadedDevicesById.containsKey(deviceId)) {
            logger.warning("Duplicate device id: " + deviceId);
            return null;
        }
        String providerName = this.getAttribute(elDevice, "provider");
        String deviceName = this.getAttribute(elDevice, "name");
        String deviceTitle = this.getAttribute(elDevice, "title");
        boolean enabled = true;
        String sEnabled = this.getAttribute(elDevice, "enabled");
        if (sEnabled != null) {
            enabled = Boolean.valueOf(sEnabled);
        }
        String presetName = this.getAttribute(elDevice, "presetName");
        Point position = null;
        String sPos = this.getAttribute(elDevice, "position");
        if (sPos != null) {
            try {
                position = StudioXmlUtil.parsePoint(sPos);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        boolean legacyLayout = false;
        String s = this.getAttribute(elDevice, "editorBounds");
        if (s != null) {
            legacyLayout = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading Device: id=" + deviceId + ", name=" + deviceName + ", title=" + deviceTitle + ", provider=" + providerName + ", enabled=" + enabled + ", position=" + position);
        }
        Properties devProps = new Properties();
        HashMap<String, String> devControls = new HashMap<String, String>();
        HashMap<String, PortInfo> portInfoByName = new HashMap<String, PortInfo>();
        LinkedList<PortInfo> portInfoList = new LinkedList<PortInfo>();
        NodeList list = elDevice.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String name = el.getNodeName();
            if ("property".equals(name)) {
                String key = this.getAttribute(el, "key");
                value = this.getAttribute(el, "value");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Property: key=" + key + ", value=" + value);
                }
                if (key == null) continue;
                devProps.put(key, value);
                continue;
            }
            if ("control".equals(name)) {
                name = this.getAttribute(el, "name");
                String value2 = this.getAttribute(el, "value");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Control: name=" + name + ", value=" + value2);
                }
                if (name == null) continue;
                devControls.put(name, value2);
                continue;
            }
            if ("port".equals(name)) {
                String portId = this.getAttribute(el, "id");
                String portType = this.getAttribute(el, "type");
                portName = this.getAttribute(el, "name");
                String portTitle = this.getAttribute(el, "title");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Port: id=" + portId + ", type=" + portType + ", name=" + portName);
                }
                PortInfo portInfo = new PortInfo();
                portInfo.portId = portId;
                portInfo.portType = portType;
                portInfo.portName = portName;
                portInfo.portTitle = portTitle;
                portInfoList.add(portInfo);
                portInfoByName.put(portName, portInfo);
                continue;
            }
            logger.warning("Unexpected element name: " + name);
        }
        LinkedList<LogRecord> deviceErrors = new LinkedList<LogRecord>();
        DeviceProvider provider = null;
        try {
            DeviceRegistry registry = studio.getDeviceRegistry();
            if (registry != null) {
                provider = registry.getDeviceProvider(providerName);
            }
        }
        catch (Throwable e) {
            LogRecord record = new LogRecord(Level.SEVERE, e.getMessage());
            record.setThrown(e);
            logger.log(record);
            deviceErrors.add(record);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating device: " + deviceName + " -> " + provider);
        }
        MissingDevice device = null;
        if (deviceName != null && provider != null) {
            try {
                DeviceInfo info;
                DeviceInfo[] infos = provider.getDeviceInfo();
                for (int i = 0; !(i >= infos.length || deviceName.equals((info = infos[i]).getDeviceName()) && (device = provider.createDevice(info)) != null); ++i) {
                }
            }
            catch (Throwable e) {
                LogRecord record = new LogRecord(Level.SEVERE, e.getMessage());
                record.setThrown(e);
                logger.log(record);
                deviceErrors.add(record);
            }
        }
        if (device == null) {
            device = new MissingDevice(provider, deviceName);
        }
        this.loadedDevicesById.put(deviceId, device);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Device created: " + deviceName + " -> " + (Object)((Object)device));
        }
        device.setPresetName(presetName);
        if (deviceTitle != null) {
            device.setTitle(deviceTitle);
        }
        if (position != null) {
            studio.setDevicePosition(device, position.x, position.y);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Initializing device: " + (Object)((Object)device));
        }
        studio.registerDevice(device);
        device.setProperties(devProps);
        if (!devControls.isEmpty()) {
            for (Map.Entry me : devControls.entrySet()) {
                String name = (String)me.getKey();
                value = me.getValue();
                Control control = device.getControl(name);
                if (control == null) {
                    MissingControl missingControl = new MissingControl(name);
                    missingControl.setValue(value);
                    studio.addMissingControl((Control)missingControl, device);
                    continue;
                }
                try {
                    control.setValue((Object)value);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    LogRecord record = new LogRecord(Level.SEVERE, e.getMessage());
                    record.setThrown(e);
                    studio.reportDeviceError(device, record);
                }
            }
        }
        studio.unregisterDevice(device);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Device initialized: " + (Object)((Object)device));
        }
        Port[] ports = device.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            Port port = ports[i];
            portName = port.getName();
            PortInfo portInfo = (PortInfo)portInfoByName.remove(portName);
            if (portInfo == null) continue;
            portInfoList.remove(portInfo);
            String portId = portInfo.portId;
            this.loadedPortsById.put(portId, port);
            studio.setPortId(port, portId);
            port.setTitle(portInfo.portTitle);
        }
        for (PortInfo portInfo : portInfoList) {
            String portId = portInfo.portId;
            String portName2 = portInfo.portName;
            String portTypeName = portInfo.portType;
            String portTitle = portInfo.portTitle;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Missing port: id=" + portId + ", name=" + portName2 + ", type=" + portTypeName + ", device=" + (Object)((Object)device));
            }
            String prefLayoutConstraint = null;
            if (portTypeName != null) {
                if (portTypeName.toLowerCase().indexOf("input") >= 0) {
                    prefLayoutConstraint = "West";
                } else if (portTypeName.toLowerCase().indexOf("output") >= 0) {
                    prefLayoutConstraint = "East";
                }
            }
            String tooltip = "Missing port type: " + portTypeName;
            PortType portType = studio.createMissingPortType(portTypeName, tooltip, prefLayoutConstraint);
            Port port = studio.createMissingPort(device, portType, portName2, portTitle, tooltip = "Missing port: " + portName2);
            if (port == null) continue;
            this.loadedPortsById.put(portId, port);
            studio.setPortId(port, portId);
        }
        if (deviceId != null) {
            studio.setDeviceId(device, deviceId);
        }
        if (position != null) {
            studio.setDevicePosition(device, position.x, position.y);
        }
        if (legacyLayout) {
            Layout layout = studio.getLayout();
            if (layout == null) {
                layout = this.loadDefaultLayout(studio);
            }
            this.loadPanel(studio, layout, elDevice, device);
        }
        studio.registerDevice(device);
        if (!enabled) {
            studio.disableDevice(device);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Device loaded: id=" + deviceId + ", name=" + deviceName + ", title=" + deviceTitle + " -> " + (Object)((Object)device));
        }
        if (!deviceErrors.isEmpty()) {
            Iterator i = deviceErrors.iterator();
            while (i.hasNext()) {
                studio.reportDeviceError(device, (LogRecord)i.next());
            }
        }
        return device;
    }

    protected Connection loadConnection(DefaultStudio studio, Element el) throws StudioException {
        MissingPort mp;
        Port sourcePort;
        String sourcePortId = this.getAttribute(el, "sourcePortId");
        String targetPortId = this.getAttribute(el, "targetPortId");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loading Connection: sourcePortId=" + sourcePortId + ", targetPortId=" + targetPortId);
        }
        if ((sourcePort = this.getLoadedPort(sourcePortId)) == null) {
            logger.warning("Missing source port for id: " + sourcePortId);
            return null;
        }
        Port targetPort = this.getLoadedPort(targetPortId);
        if (targetPort == null) {
            logger.warning("Missing target port for id: " + targetPortId);
            return null;
        }
        if (sourcePort.getDevice() == null && sourcePort instanceof MissingPort) {
            mp = (MissingPort)sourcePort;
            studio.addMissingPort(mp, mp.getOwner());
        }
        if (targetPort.getDevice() == null && targetPort instanceof MissingPort) {
            mp = (MissingPort)targetPort;
            studio.addMissingPort(mp, mp.getOwner());
        }
        if (!sourcePort.isConnectable(targetPort)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Ports are not connectable: " + sourcePort + ", " + targetPort);
            }
            return studio.addInvalidConnection(sourcePort, targetPort);
        }
        if (!targetPort.isConnectable(sourcePort)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Ports are not connectable: " + targetPort + ", " + sourcePort);
            }
            return studio.addInvalidConnection(sourcePort, targetPort);
        }
        try {
            return studio.connect(sourcePort, targetPort);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return studio.addInvalidConnection(sourcePort, targetPort);
        }
    }

    protected Preset loadPreset(DefaultStudio studio, Element elPreset) throws StudioException {
        String presetName = this.getAttribute(elPreset, "name");
        if (presetName == null) {
            logger.warning("Missing preset name: " + elPreset);
            return null;
        }
        String deviceName = this.getAttribute(elPreset, "deviceName");
        String providerName = this.getAttribute(elPreset, "providerName");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loading Preset: name=" + presetName + ", device=" + deviceName + ", provider=" + providerName);
        }
        Properties properties = new Properties();
        HashMap<String, String> controlMap = new HashMap<String, String>();
        NodeList list = elPreset.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String name = el.getNodeName();
            if ("property".equals(name)) {
                String key = this.getAttribute(el, "key");
                String value = this.getAttribute(el, "value");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Property: key=" + key + ", value=" + value);
                }
                if (key == null) continue;
                properties.put(key, value);
                continue;
            }
            if ("control".equals(name)) {
                name = this.getAttribute(el, "name");
                String value = this.getAttribute(el, "value");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Control: name=" + name + ", value=" + value);
                }
                if (name == null) continue;
                controlMap.put(name, value);
                continue;
            }
            logger.warning("Unexpected element name: " + name);
        }
        Preset preset = new Preset();
        preset.setPresetName(presetName);
        preset.setDeviceName(deviceName);
        preset.setProviderName(providerName);
        preset.setProperties(properties);
        preset.setControls(controlMap);
        studio.addPreset(preset);
        return preset;
    }

    protected Layout loadDefaultLayout(DefaultStudio studio) throws StudioException {
        String layoutId = "layout1";
        String layoutName = "Layout 1";
        Layout layout = new Layout(layoutName);
        studio.setLayoutId(layout, layoutId);
        studio.addLayout(layout);
        studio.setLayout(layout);
        return layout;
    }

    protected Layout loadLayout(DefaultStudio studio, Element elLayout) throws StudioException {
        String layoutId = this.getAttribute(elLayout, "id");
        if (layoutId == null) {
            logger.warning("Missing layout id: " + elLayout);
            return null;
        }
        String layoutName = this.getAttribute(elLayout, "name");
        if (layoutName == null) {
            logger.warning("Missing layout name: " + elLayout);
            return null;
        }
        String layoutTitle = this.getAttribute(elLayout, "title");
        Layout layout = new Layout(layoutName);
        layout.setName(layoutName);
        layout.setTitle(layoutTitle);
        studio.setLayoutId(layout, layoutId);
        NodeList list = elLayout.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String name = el.getNodeName();
            if ("panel".equals(name)) {
                this.loadPanel(studio, layout, el);
                continue;
            }
            logger.warning("Unexpected element name: " + name);
        }
        studio.addLayout(layout);
        return layout;
    }

    protected LayoutPanel loadPanel(DefaultStudio studio, Layout layout, Element elPanel) throws StudioException {
        String deviceId = this.getAttribute(elPanel, "deviceId");
        if (deviceId == null) {
            return null;
        }
        Device device = (Device)this.loadedDevicesById.get(deviceId);
        if (device == null) {
            return null;
        }
        return this.loadPanel(studio, layout, elPanel, device);
    }

    protected LayoutPanel loadPanel(DefaultStudio studio, Layout layout, Element elPanel, Device device) throws StudioException {
        if (device == null) {
            return null;
        }
        Rectangle editorBounds = null;
        String s = this.getAttribute(elPanel, "editorBounds");
        if (s != null) {
            try {
                editorBounds = StudioXmlUtil.parseRectangle(s);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        boolean editorVisible = false;
        s = this.getAttribute(elPanel, "editorVisible");
        if (s != null) {
            editorVisible = Boolean.valueOf(s);
        }
        boolean editorIconified = false;
        s = this.getAttribute(elPanel, "editorIconified");
        if (s != null) {
            editorIconified = Boolean.valueOf(s);
        }
        boolean editorDetached = false;
        s = this.getAttribute(elPanel, "editorDetached");
        if (s != null) {
            editorDetached = Boolean.valueOf(s);
        }
        Rectangle editorDetachedBounds = null;
        s = this.getAttribute(elPanel, "editorDetachedBounds");
        if (s != null) {
            try {
                editorDetachedBounds = StudioXmlUtil.parseRectangle(s);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        LayoutPanel panel = new LayoutPanel(device);
        panel.setEditorBounds(editorBounds);
        panel.setEditorVisible(editorVisible);
        panel.setEditorIconified(editorIconified);
        panel.setEditorDetached(editorDetached);
        panel.setEditorDetachedBounds(editorDetachedBounds);
        layout.addPanel(panel);
        return panel;
    }

    private Port getLoadedPort(String portId) throws StudioException {
        return (Port)this.loadedPortsById.get(portId);
    }

    protected void readProperty(Studio studio, Element el, Properties dest) {
        String key = this.getAttribute(el, "key");
        String value = this.getAttribute(el, "value");
        if (key != null && value != null) {
            dest.setProperty(key, value);
        }
    }

    protected String getAttribute(Element el, String name) {
        Attr attr = el.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static Point parsePoint(String s) {
        if (s == null) {
            return null;
        }
        int[] arr = StudioXmlUtil.splitIntegers(s, ",");
        if (arr.length != 2) {
            throw new IllegalArgumentException("Invalid point format: " + s);
        }
        return new Point(arr[0], arr[1]);
    }

    public static Rectangle parseRectangle(String s) {
        if (s == null) {
            return null;
        }
        int[] arr = StudioXmlUtil.splitIntegers(s, ",");
        if (arr.length != 4) {
            throw new IllegalArgumentException("Invalid rectangle format: " + s);
        }
        return new Rectangle(arr[0], arr[1], arr[2], arr[3]);
    }

    public static String formatRectangle(Rectangle r) {
        return String.valueOf(r.x) + ", " + String.valueOf(r.y) + ", " + String.valueOf(r.width) + ", " + String.valueOf(r.height);
    }

    public static int[] splitIntegers(String value, String delim) {
        StringTokenizer tok = new StringTokenizer(value, delim, false);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        int num = list.size();
        int[] arr = new int[num];
        for (int i = 0; i < num; ++i) {
            String s = (String)list.get(i);
            arr[i] = Integer.parseInt(s.trim());
        }
        return arr;
    }

    protected synchronized DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            this.documentBuilder = factory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    protected synchronized void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    protected static class PortInfo {
        public String portId;
        public String portType;
        public String portName;
        public String portTitle;

        protected PortInfo() {
        }
    }
}

