/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.impl;

import com.spacekiller.util.zip.ZipBackup;
import com.spacekiller.util.zip.ZipRestore;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class StudioZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStudioProjectToZipFile(File projectDirectory, File targetZipFile) throws IOException {
        if (projectDirectory == null) {
            throw new NullPointerException("projectDirectory");
        }
        boolean success = false;
        FileOutputStream fos = new FileOutputStream(targetZipFile);
        try {
            this.exportStudioProjectToZipStream(projectDirectory, fos);
            success = true;
        }
        finally {
            fos.close();
            if (!success) {
                targetZipFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStudioProjectToZipStream(File projectDirectory, OutputStream outputStream) throws IOException {
        ZipBackup zipBackup = new ZipBackup(outputStream);
        try {
            ZipEntry entry = new ZipEntry("/");
            entry.setTime(projectDirectory.lastModified());
            FileFilter filter = null;
            boolean recursive = true;
            zipBackup.writeDirectory(entry, projectDirectory, filter, recursive);
        }
        finally {
            zipBackup.flush();
            zipBackup.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStudioProjectFromZipFile(File sourceZipFile, File targetDirectory) throws IOException {
        FileInputStream fis = new FileInputStream(sourceZipFile);
        try {
            this.importStudioProjectFromZipStream(fis, targetDirectory);
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStudioProjectFromZipStream(InputStream inputStream, File targetDirectory) throws IOException {
        ZipRestore zipRestore = new ZipRestore(inputStream);
        try {
            FileFilter targetFilter = null;
            boolean ignoreExisting = true;
            boolean overwrite = false;
            zipRestore.restoreRecursive(targetDirectory, targetFilter, ignoreExisting, overwrite);
        }
        finally {
            zipRestore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStudioProjectZipFile(File sourceZipFile) throws IOException {
        ZipFile zipFile = new ZipFile(sourceZipFile);
        try {
            ZipEntry studioFileEntry = zipFile.getEntry("waxmonster.xml");
            if (studioFileEntry == null) {
                throw new IOException("Invalid studio project zip file: " + sourceZipFile);
            }
        }
        finally {
            zipFile.close();
        }
    }
}

