/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.AbstractExecution;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.DeviceRegistry;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.view.StudioToolContext;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddDeviceExecution
extends AbstractExecution {
    private static final Logger logger = Logger.getLogger(AddDeviceExecution.class.getName());
    private final StudioToolContext context;
    private final DeviceRegistry deviceRegistry;
    private final DeviceInfo deviceInfo;
    private final Point location;

    public AddDeviceExecution(String name, String descr, StudioToolContext context, DeviceRegistry deviceRegistry, DeviceInfo deviceInfo, Point location) {
        super(name, descr);
        this.context = context;
        this.deviceRegistry = deviceRegistry;
        this.deviceInfo = deviceInfo;
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            Device device;
            DeviceProvider provider = this.deviceRegistry.getDeviceProvider(this.deviceInfo);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating device: deviceInfo=" + this.deviceInfo + ", deviceProvider=" + provider);
            }
            if ((device = provider.createDevice(this.deviceInfo)) == null) {
                throw new StudioException("Failed to create device: info=" + this.deviceInfo + ", provider=" + provider);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding device: deviceInfo=" + this.deviceInfo + ", device=" + device);
            }
            if (this.location == null) {
                this.context.addDevice(device);
            } else {
                this.context.addDevice(device, this.location.x, this.location.y);
            }
        }
        finally {
            this.setProgress(1.0);
        }
    }
}

