/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.TMenu;
import com.spacekiller.util.tooling.Tool;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceInfoListener;
import com.waxmonster.studio.DeviceRegistry;
import com.waxmonster.studio.view.AddDeviceExecution;
import com.waxmonster.studio.view.StudioPlugin;
import com.waxmonster.studio.view.StudioToolContext;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class AddDeviceMenu
extends TMenu {
    private static final Logger logger = Logger.getLogger(AddDeviceMenu.class.getName());
    private DeviceRegistry deviceRegistry;
    private DeviceInfoHandler deviceInfoHandler = new DeviceInfoHandler();

    public AddDeviceMenu() {
        this.initDeviceMenu();
    }

    protected void initDeviceMenu() {
        try {
            this.setDeviceRegistry(StudioPlugin.getInstance().getDeviceRegistry());
            SwingUtilities.invokeLater(this.deviceInfoHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DeviceRegistry getDeviceRegistry() {
        return this.deviceRegistry;
    }

    public synchronized void setDeviceRegistry(DeviceRegistry newDeviceRegistry) {
        if (this.deviceRegistry == newDeviceRegistry) {
            return;
        }
        if (this.deviceRegistry != null) {
            this.deviceRegistry.removeDeviceInfoListener((DeviceInfoListener)this.deviceInfoHandler);
        }
        this.deviceRegistry = newDeviceRegistry;
        if (this.deviceRegistry != null) {
            this.deviceRegistry.addDeviceInfoListener((DeviceInfoListener)this.deviceInfoHandler);
        }
    }

    public void refreshDevices() {
        this.removeAll();
        TreeMap<String, LinkedList<DeviceInfo>> categoryDeviceInfoMap = new TreeMap<String, LinkedList<DeviceInfo>>();
        DeviceRegistry registry = this.getDeviceRegistry();
        if (registry != null) {
            DeviceInfo[] infos = registry.getDeviceInfo();
            for (int i = 0; i < infos.length; ++i) {
                DeviceInfo info = infos[i];
                String category = info.getDeviceCategory();
                LinkedList<DeviceInfo> list = (LinkedList<DeviceInfo>)categoryDeviceInfoMap.get(category);
                if (list == null) {
                    list = new LinkedList<DeviceInfo>();
                    categoryDeviceInfoMap.put(category, list);
                }
                list.add(info);
            }
        }
        long nextToolPrio = 0x1FFFFFFFFFFFFFFFL;
        long nextMenuPrio = 0x3FFFFFFFFFFFFFFFL;
        for (Map.Entry me : categoryDeviceInfoMap.entrySet()) {
            String category = (String)me.getKey();
            List list = (List)me.getValue();
            TMenu categoryMenu = null;
            if (category != null && category.length() > 0) {
                categoryMenu = new TMenu();
                categoryMenu.setName(category);
                categoryMenu.setPriority((double)nextMenuPrio--);
                categoryMenu.setText(category);
                this.addChild((Tool)categoryMenu);
            }
            DeviceInfo[] infos = list.toArray(new DeviceInfo[list.size()]);
            for (int k = 0; k < infos.length; ++k) {
                DeviceInfo info = infos[k];
                String name = String.valueOf(info.getDeviceName());
                AddDeviceAction tool = new AddDeviceAction(info);
                tool.setName(name);
                tool.setPriority(nextToolPrio--);
                tool.setText(name);
                tool.setTooltip(info.getTooltip());
                tool.setIcon(info.getIcon(1));
                if (categoryMenu == null) {
                    this.addChild((Tool)tool);
                    continue;
                }
                categoryMenu.addChild((Tool)tool);
            }
        }
    }

    protected void addDeviceAsync(StudioToolContext context, DeviceInfo deviceInfo, Point pos) {
        String devName = deviceInfo.getDeviceName();
        String title = "Add Device: " + devName;
        String descr = "Adding device: " + devName;
        AddDeviceExecution exec = new AddDeviceExecution(title, descr, context, this.deviceRegistry, deviceInfo, pos);
        ExecutionManager execManager = Platform.getInstance().getExecutionManager();
        if (execManager != null) {
            execManager.addExecution((Execution)exec);
        }
        exec.start();
    }

    protected class AddDeviceAction
    extends TAction {
        private DeviceInfo deviceInfo;

        public AddDeviceAction(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
        }

        public void invoke(Object instance) {
            try {
                StudioToolContext ctx = (StudioToolContext)this.getToolContext(instance);
                if (ctx == null) {
                    return;
                }
                Point pos = ctx.getPreferredDeviceLocation();
                AddDeviceMenu.this.addDeviceAsync(ctx, this.deviceInfo, pos);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class DeviceInfoHandler
    implements DeviceInfoListener,
    Runnable {
        protected DeviceInfoHandler() {
        }

        public void deviceInfoAdded(DeviceInfo info) {
            SwingUtilities.invokeLater(this);
        }

        public void deviceInfoRemoved(DeviceInfo info) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            AddDeviceMenu.this.refreshDevices();
        }
    }
}

