/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.visual.LineStyle;
import com.spacekiller.util.visual.VisualUtil;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.view.DeviceComponent;
import com.waxmonster.studio.view.PortConnector;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ConnectionLine {
    private final Connection connection;
    private final DeviceComponent sourceDevice;
    private final PortConnector sourceConnector;
    private final DeviceComponent targetDevice;
    private final PortConnector targetConnector;
    private LineStyle lineStyle;
    private boolean selected;

    public ConnectionLine(Connection connection, DeviceComponent sourceDevice, PortConnector sourceConnector, DeviceComponent targetDevice, PortConnector targetConnector, LineStyle lineStyle) {
        this.connection = connection;
        this.sourceDevice = sourceDevice;
        this.sourceConnector = sourceConnector;
        this.targetDevice = targetDevice;
        this.targetConnector = targetConnector;
        this.lineStyle = lineStyle;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final DeviceComponent getSourceDevice() {
        return this.sourceDevice;
    }

    public final DeviceComponent getTargetDevice() {
        return this.targetDevice;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void paint(Graphics g) {
        LineStyle style = this.lineStyle;
        if (style == null) {
            return;
        }
        Rectangle sourceBounds = this.sourceDevice.getConnectorBounds(this.sourceConnector);
        Rectangle targetBounds = this.targetDevice.getConnectorBounds(this.targetConnector);
        int x1 = sourceBounds.x + sourceBounds.width / 2;
        int y1 = sourceBounds.y + sourceBounds.height / 2;
        int x2 = targetBounds.x + targetBounds.width / 2;
        int y2 = targetBounds.y + targetBounds.height / 2;
        style.drawLine(g, x1, y1, x2, y2, this.selected, 0, 1);
    }

    public double distance(int x, int y) {
        Rectangle sourceBounds = this.sourceDevice.getConnectorBounds(this.sourceConnector);
        Rectangle targetBounds = this.targetDevice.getConnectorBounds(this.targetConnector);
        int x1 = sourceBounds.x + sourceBounds.width / 2;
        int y1 = sourceBounds.y + sourceBounds.height / 2;
        int x2 = targetBounds.x + targetBounds.width / 2;
        int y2 = targetBounds.y + targetBounds.height / 2;
        return VisualUtil.distance((double)x1, (double)y1, (double)x2, (double)y2, (double)x, (double)y);
    }
}

