/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.EditorContext;
import com.spacekiller.util.visual.Connector;
import com.spacekiller.util.visual.VisualComponent;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.LayoutPanel;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.view.DeviceCustomizerView;
import com.waxmonster.studio.view.PortConnector;
import com.waxmonster.studio.view.RoutingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogRecord;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;

public class DeviceComponent
extends JComponent
implements VisualComponent {
    private static final long serialVersionUID = 3266239241399278737L;
    private RoutingPanel studioPanel;
    private Device device;
    private DeviceCustomizerView deviceCustomizerView;
    private int iconKind = 1;
    private String deviceName;
    private List connectors = new ArrayList();
    private Map portConnectorMap = new HashMap();
    private boolean selected;
    private boolean disabled;
    private LogRecord[] errors;
    private Paint backgroundPaint = Color.MAGENTA;
    private Paint selectedBackgroundPaint = Color.YELLOW;
    private Paint disabledBackgroundPaint = Color.LIGHT_GRAY;
    private Paint errorBackgroundPaint = Color.RED;
    private Stroke outlineStroke;
    private Stroke selectedOutlineStroke;
    private Cursor connectCursor;
    private Map panels;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JLabel subtitleLabel;
    private JTextField titleTextField;
    private boolean titleTextFieldVisible;
    private boolean titleTextFieldEnabled;
    private Properties oldDeviceProperties;
    private Map oldDeviceControls;
    private LayoutPanel oldDeviceLayoutPanel;

    public DeviceComponent() {
        this.initDeviceComponent();
    }

    private void initDeviceComponent() {
        this.panels = new HashMap();
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setOpaque(false);
        this.add((Component)northPanel, "North");
        this.panels.put("North", northPanel);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.setOpaque(false);
        this.add((Component)southPanel, "South");
        this.panels.put("South", southPanel);
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BoxLayout(eastPanel, 1));
        eastPanel.setOpaque(false);
        this.add((Component)eastPanel, "East");
        this.panels.put("East", eastPanel);
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BoxLayout(westPanel, 1));
        westPanel.setOpaque(false);
        this.add((Component)westPanel, "West");
        this.panels.put("West", westPanel);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 2));
        centerPanel.setOpaque(false);
        this.add((Component)centerPanel, "Center");
        this.panels.put("Center", centerPanel);
        this.titleLabel = new JLabel();
        this.titleLabel.setOpaque(false);
        this.titleTextField = new JTextField();
        this.titleTextField.setOpaque(false);
        this.titleTextField.addActionListener(new TitleActionHandler());
        this.titleTextField.addFocusListener(new TitleFocusHandler());
        this.titleTextField.setBorder(new CompoundBorder());
        this.titleTextField.setFont(this.titleLabel.getFont());
        this.subtitleLabel = new JLabel();
        this.subtitleLabel.setOpaque(false);
        Font font = this.subtitleLabel.getFont();
        if (font != null) {
            this.subtitleLabel.setFont(new Font(font.getName(), 0, font.getSize()));
        }
        this.titlePanel = new JPanel();
        this.titlePanel.setOpaque(false);
        this.titlePanel.setLayout(new GridBagLayout());
        centerPanel.add(this.titlePanel);
        this.addMouseListener(new MouseHandler());
        this.setOpaque(false);
        this.setFocusable(true);
        this.setBackground(Color.WHITE);
        this.setToolTipText("Device");
    }

    public RoutingPanel getStudioPanel() {
        return this.studioPanel;
    }

    protected void setStudioPanel(RoutingPanel studioPanel) {
        this.studioPanel = studioPanel;
    }

    public Device getDevice() {
        return this.device;
    }

    public synchronized void setDevice(Device device) {
        if (this.device == device) {
            return;
        }
        this.device = device;
    }

    public void refresh() {
        EditorContext editorContext;
        DeviceCustomizerView customView;
        String devName = null;
        String devTitle = null;
        String devSubtitle = null;
        HashMap<Port, PortConnector> newConnectorMap = new HashMap<Port, PortConnector>();
        ArrayList<PortConnector> newConnectorList = new ArrayList<PortConnector>();
        for (JPanel panel : this.panels.values()) {
            panel.removeAll();
        }
        JPanel centerPanel = (JPanel)this.panels.get("Center");
        LogRecord[] devErrors = null;
        Device dev = this.device;
        if (dev != null) {
            this.setDisabled(!dev.isEnabled());
            devName = dev.getName();
            devTitle = dev.getTitle();
            devSubtitle = dev.getSubtitle();
            Port[] normalPorts = dev.getPorts();
            Port[] missingPorts = dev.getMissingPorts();
            Port[] ports = new Port[normalPorts.length + missingPorts.length];
            System.arraycopy(normalPorts, 0, ports, 0, normalPorts.length);
            System.arraycopy(missingPorts, 0, ports, normalPorts.length, missingPorts.length);
            if (ports != null) {
                for (int i = 0; i < ports.length; ++i) {
                    JPanel panel;
                    Icon icon;
                    Port port = ports[i];
                    PortConnector connector = (PortConnector)this.portConnectorMap.get(port);
                    if (connector == null) {
                        icon = this.getPortIcon(port);
                        connector = new PortConnector(this, port, icon);
                        Dimension prefSize = new Dimension(16, 16);
                        if (icon != null) {
                            prefSize.width = icon.getIconWidth();
                            prefSize.height = icon.getIconHeight();
                        }
                        connector.setPreferredSize(prefSize);
                    }
                    newConnectorList.add(connector);
                    newConnectorMap.put(port, connector);
                    Object prefLayout = null;
                    PortType portType = port.getType();
                    if (portType != null) {
                        prefLayout = portType.getPreferredLayoutConstraint();
                    }
                    if (prefLayout == null) {
                        prefLayout = "Center";
                    }
                    Rectangle relBounds = new Rectangle();
                    relBounds.width = 10;
                    relBounds.height = 10;
                    icon = connector.getIcon();
                    if (icon != null) {
                        relBounds.width = icon.getIconWidth();
                        relBounds.height = icon.getIconHeight();
                    }
                    if (this.connectCursor != null) {
                        connector.setCursor(this.connectCursor);
                    }
                    if ((panel = (JPanel)this.panels.get(prefLayout)) == null) {
                        panel = centerPanel;
                    }
                    panel.add(connector);
                }
            }
            devErrors = dev.getErrors();
        }
        this.setErrors(devErrors);
        if (devTitle == null && (devTitle = devName) == null) {
            devTitle = "" + dev;
        }
        if ((customView = this.deviceCustomizerView) != null && (editorContext = customView.getEditorContext()) != null) {
            editorContext.setTitle(devTitle);
        }
        this.titleLabel.setText(devTitle);
        this.titleTextField.setText(devTitle);
        if (devSubtitle == null) {
            devSubtitle = "";
        }
        this.subtitleLabel.setText(devSubtitle);
        boolean subtitleVisible = devSubtitle.length() > 0;
        this.titlePanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = subtitleVisible ? new Insets(6, 4, 0, 4) : new Insets(4, 4, 4, 4);
        if (this.titleTextFieldVisible) {
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.titlePanel.add((Component)this.titleTextField, gbc);
        } else {
            this.titlePanel.add((Component)this.titleLabel, gbc);
        }
        if (subtitleVisible) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 4, 4, 4);
            this.titlePanel.add((Component)this.subtitleLabel, gbc);
        }
        centerPanel.add(this.titlePanel);
        this.deviceName = devName;
        this.connectors = newConnectorList;
        this.portConnectorMap = newConnectorMap;
    }

    protected Icon getPortIcon(Port port) {
        if (port == null) {
            return null;
        }
        PortType portType = port.getType();
        if (portType == null) {
            return null;
        }
        return portType.getIcon(this.iconKind);
    }

    public Connector getConnectorAt(int index) {
        return (PortConnector)this.connectors.get(index);
    }

    public Connector getConnectorAtPosition(int x, int y) {
        JPanel panel;
        Component comp = this.getComponentAt(x -= this.getX(), y -= this.getY());
        if (comp instanceof JPanel && (comp = (panel = (JPanel)comp).getComponentAt(x -= panel.getX(), y -= panel.getY())) != null && comp instanceof PortConnector) {
            return (PortConnector)comp;
        }
        return null;
    }

    public Rectangle getConnectorBounds(Connector c) {
        PortConnector pc = (PortConnector)c;
        Rectangle rect = pc.getBounds();
        for (Container parent = pc.getParent(); parent != null && parent != this; parent = parent.getParent()) {
            rect.x += parent.getX();
            rect.y += parent.getY();
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    public Rectangle getConnectorBounds(int index) {
        return this.getConnectorBounds(this.getConnectorAt(index));
    }

    public int getConnectorCount() {
        return this.connectors.size();
    }

    public PortConnector getPortConnector(Port port) {
        return (PortConnector)this.portConnectorMap.get(port);
    }

    public int getIconKind() {
        return this.iconKind;
    }

    public void setIconKind(int iconKind) {
        this.iconKind = iconKind;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        int arc = 10;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Paint backPaint = this.disabled ? this.disabledBackgroundPaint : (this.selected ? this.selectedBackgroundPaint : (this.errors != null && this.errors.length > 0 ? this.errorBackgroundPaint : this.backgroundPaint));
        g2d.setPaint(backPaint);
        g2d.fillRoundRect(0, 0, w - 1, h - 1, arc, arc);
        Stroke stroke = g2d.getStroke();
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.selected ? this.selectedOutlineStroke : this.outlineStroke);
        g2d.drawRoundRect(0, 0, w - 1, h - 1, arc, arc);
        g2d.setStroke(stroke);
        super.paintComponent(g);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        PortConnector pc;
        Port port;
        int cy;
        int cx = this.getX() + event.getX();
        Connector conn = this.getConnectorAtPosition(cx, cy = this.getY() + event.getY());
        if (conn != null && conn instanceof PortConnector && (port = (pc = (PortConnector)conn).getPort()) != null) {
            String tooltip = port.getTooltip();
            if (!(tooltip != null && tooltip.trim().length() >= 1 || (tooltip = port.getTitle()) != null && tooltip.trim().length() >= 1)) {
                tooltip = port.getName();
            }
            return tooltip;
        }
        return super.getToolTipText(event);
    }

    @Override
    public String getToolTipText() {
        String tip = null;
        Device dev = this.device;
        if (dev != null) {
            tip = dev.getTooltip();
        }
        if (tip == null) {
            tip = this.deviceName;
        }
        if (dev != null) {
            int errorCount;
            if (!dev.isEnabled()) {
                tip = "Disabled: " + tip;
            }
            if ((errorCount = dev.getErrorCount()) > 0) {
                if (errorCount == 1) {
                    LogRecord[] errors = dev.getErrors();
                    LogRecord error = null;
                    if (errors.length > 0) {
                        error = errors[0];
                    }
                    tip = error != null ? tip + " (Error: " + error.getMessage() + ")" : tip + " (1 error)";
                } else {
                    tip = tip + " (" + errorCount + " errors)";
                }
            }
        }
        return tip;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setTitleTextFieldVisible(boolean show) {
        if (this.titleTextFieldVisible == show) {
            return;
        }
        this.titleTextFieldVisible = show;
        this.refresh();
        this.validate();
        this.repaint();
        if (show) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceComponent.this.titleTextField.requestFocus();
                }
            });
        }
    }

    protected void applyTitle() {
        if (!this.titleTextFieldVisible) {
            return;
        }
        Device dev = this.device;
        if (dev != null) {
            String newTitle = this.titleTextField.getText().trim();
            if (newTitle.length() < 1) {
                newTitle = null;
            }
            dev.setTitle(newTitle);
        }
        this.setTitleTextFieldVisible(false);
    }

    public DeviceCustomizerView getDeviceCustomizerView() {
        return this.deviceCustomizerView;
    }

    public void setDeviceCustomizerView(DeviceCustomizerView deviceCustomizerView) {
        this.deviceCustomizerView = deviceCustomizerView;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public Paint getSelectedBackgroundPaint() {
        return this.selectedBackgroundPaint;
    }

    public void setSelectedBackgroundPaint(Paint selectedBackgroundPaint) {
        this.selectedBackgroundPaint = selectedBackgroundPaint;
    }

    public Paint getDisabledBackgroundPaint() {
        return this.disabledBackgroundPaint;
    }

    public void setDisabledBackgroundPaint(Paint disabledBackgroundPaint) {
        this.disabledBackgroundPaint = disabledBackgroundPaint;
    }

    public Paint getErrorBackgroundPaint() {
        return this.errorBackgroundPaint;
    }

    public void setErrorBackgroundPaint(Paint errorBackgroundPaint) {
        this.errorBackgroundPaint = errorBackgroundPaint;
    }

    public LogRecord[] getErrors() {
        return this.errors;
    }

    public void setErrors(LogRecord[] errors) {
        this.errors = errors;
    }

    public Properties getOldDeviceProperties() {
        return this.oldDeviceProperties;
    }

    public void setOldDeviceProperties(Properties oldDeviceProperties) {
        this.oldDeviceProperties = oldDeviceProperties;
    }

    public Map getOldDeviceControls() {
        return this.oldDeviceControls;
    }

    public void setOldDeviceControls(Map oldDeviceControls) {
        this.oldDeviceControls = oldDeviceControls;
    }

    public Cursor getConnectCursor() {
        return this.connectCursor;
    }

    public void setConnectCursor(Cursor connectCursor) {
        this.connectCursor = connectCursor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public Stroke getSelectedOutlineStroke() {
        return this.selectedOutlineStroke;
    }

    public void setSelectedOutlineStroke(Stroke selectedOutlineStroke) {
        this.selectedOutlineStroke = selectedOutlineStroke;
    }

    public boolean isTitleTextFieldEnabled() {
        return this.titleTextFieldEnabled;
    }

    public void setTitleTextFieldEnabled(boolean titleTextFieldEnabled) {
        this.titleTextFieldEnabled = titleTextFieldEnabled;
    }

    public LayoutPanel getOldDeviceLayoutPanel() {
        return this.oldDeviceLayoutPanel;
    }

    public void setOldDeviceLayoutPanel(LayoutPanel oldDeviceLayoutPanel) {
        this.oldDeviceLayoutPanel = oldDeviceLayoutPanel;
    }

    protected class TitleFocusHandler
    extends FocusAdapter {
        private boolean owner = false;

        protected TitleFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.owner = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            if (this.owner) {
                this.owner = false;
                DeviceComponent.this.applyTitle();
            }
        }
    }

    protected class TitleActionHandler
    implements ActionListener {
        protected TitleActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceComponent.this.applyTitle();
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JPanel centerPanel;
            int y;
            int x;
            Component comp;
            super.mousePressed(e);
            if (e.isConsumed()) {
                return;
            }
            if (e.isPopupTrigger()) {
                return;
            }
            if (DeviceComponent.this.titleTextFieldEnabled && e.getClickCount() == 1 && DeviceComponent.this.isSelected() && (comp = DeviceComponent.this.getComponentAt(x = e.getX(), y = e.getY())) != null && comp == (centerPanel = (JPanel)DeviceComponent.this.panels.get("Center"))) {
                Component comp2 = centerPanel.getComponentAt(x - comp.getX(), y - comp.getY());
                if (comp2 == DeviceComponent.this.titlePanel && !DeviceComponent.this.titleTextFieldVisible) {
                    DeviceComponent.this.setTitleTextFieldVisible(true);
                    return;
                }
                if (DeviceComponent.this.titleTextFieldVisible) {
                    DeviceComponent.this.setTitleTextFieldVisible(false);
                    return;
                }
            }
        }
    }
}

