/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.waxmonster.studio.Layout;
import com.waxmonster.studio.Studio;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeviceLayoutManagerPanel
extends JPanel {
    private static final long serialVersionUID = 3174405814262102981L;
    private static final Logger logger = Logger.getLogger(DeviceLayoutManagerPanel.class.getName());
    private Studio studio;
    private Layout selectedLayout;
    private DefaultListModel layoutListModel;
    private JTextField textFieldName;
    private JTextField textFieldTitle;
    private JButton btnClone;
    private JButton btnRemove;
    private JList listLayouts;
    private JButton btnApply;
    private JButton btnActivate;

    public DeviceLayoutManagerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelLayouts = new JPanel();
        panelLayouts.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Layouts", 4, 2, null, null));
        GridBagConstraints gbc_panelLayouts = new GridBagConstraints();
        gbc_panelLayouts.insets = new Insets(4, 4, 0, 5);
        gbc_panelLayouts.weighty = 1.0;
        gbc_panelLayouts.weightx = 1.0;
        gbc_panelLayouts.fill = 1;
        gbc_panelLayouts.gridx = 0;
        gbc_panelLayouts.gridy = 0;
        this.add((Component)panelLayouts, gbc_panelLayouts);
        GridBagLayout gbl_panelLayouts = new GridBagLayout();
        gbl_panelLayouts.columnWidths = new int[]{0, 0};
        gbl_panelLayouts.rowHeights = new int[]{0, 0, 0};
        gbl_panelLayouts.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelLayouts.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelLayouts.setLayout(gbl_panelLayouts);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.insets = new Insets(4, 4, 5, 4);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelLayouts.add((Component)scrollPane, gbc_scrollPane);
        this.listLayouts = new JList();
        this.listLayouts.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceLayoutManagerPanel.this.handleLayoutSelected();
            }
        });
        scrollPane.setViewportView(this.listLayouts);
        JPanel panelActions = new JPanel();
        GridBagConstraints gbc_panelActions = new GridBagConstraints();
        gbc_panelActions.insets = new Insets(0, 4, 4, 4);
        gbc_panelActions.fill = 2;
        gbc_panelActions.gridx = 0;
        gbc_panelActions.gridy = 1;
        panelLayouts.add((Component)panelActions, gbc_panelActions);
        GridBagLayout gbl_panelActions = new GridBagLayout();
        gbl_panelActions.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelActions.rowHeights = new int[]{0, 0};
        gbl_panelActions.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelActions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelActions.setLayout(gbl_panelActions);
        JButton btnAdd = new JButton("Add");
        btnAdd.setToolTipText("Add new layout");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceLayoutManagerPanel.this.actionAddLayout();
            }
        });
        GridBagConstraints gbc_btnAdd = new GridBagConstraints();
        gbc_btnAdd.insets = new Insets(0, 0, 0, 5);
        gbc_btnAdd.gridx = 0;
        gbc_btnAdd.gridy = 0;
        panelActions.add((Component)btnAdd, gbc_btnAdd);
        this.btnClone = new JButton("Clone");
        this.btnClone.setToolTipText("Clone selected layout");
        this.btnClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceLayoutManagerPanel.this.actionCloneLayout();
            }
        });
        GridBagConstraints gbc_btnClone = new GridBagConstraints();
        gbc_btnClone.insets = new Insets(0, 0, 0, 5);
        gbc_btnClone.gridx = 1;
        gbc_btnClone.gridy = 0;
        panelActions.add((Component)this.btnClone, gbc_btnClone);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.setToolTipText("Remove selected layout(s)");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceLayoutManagerPanel.this.actionRemoveLayout();
            }
        });
        GridBagConstraints gbc_btnRemove = new GridBagConstraints();
        gbc_btnRemove.anchor = 13;
        gbc_btnRemove.weightx = 1.0;
        gbc_btnRemove.gridx = 2;
        gbc_btnRemove.gridy = 0;
        panelActions.add((Component)this.btnRemove, gbc_btnRemove);
        JPanel panelDetails = new JPanel();
        panelDetails.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Details", 4, 2, null, null));
        GridBagConstraints gbc_panelDetails = new GridBagConstraints();
        gbc_panelDetails.insets = new Insets(4, 4, 0, 4);
        gbc_panelDetails.weighty = 1.0;
        gbc_panelDetails.weightx = 1.0;
        gbc_panelDetails.fill = 1;
        gbc_panelDetails.gridx = 1;
        gbc_panelDetails.gridy = 0;
        this.add((Component)panelDetails, gbc_panelDetails);
        GridBagLayout gbl_panelDetails = new GridBagLayout();
        gbl_panelDetails.columnWidths = new int[]{0, 0, 0};
        gbl_panelDetails.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panelDetails.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelDetails.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelDetails.setLayout(gbl_panelDetails);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.anchor = 17;
        gbc_lblName.insets = new Insets(4, 4, 5, 5);
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        panelDetails.add((Component)lblName, gbc_lblName);
        this.textFieldName = new JTextField();
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.insets = new Insets(4, 4, 5, 4);
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        panelDetails.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(20);
        JLabel lblTitle = new JLabel("Title:");
        GridBagConstraints gbc_lblTitle = new GridBagConstraints();
        gbc_lblTitle.anchor = 17;
        gbc_lblTitle.insets = new Insets(4, 4, 5, 5);
        gbc_lblTitle.gridx = 0;
        gbc_lblTitle.gridy = 1;
        panelDetails.add((Component)lblTitle, gbc_lblTitle);
        this.textFieldTitle = new JTextField();
        GridBagConstraints gbc_textFieldTitle = new GridBagConstraints();
        gbc_textFieldTitle.insets = new Insets(4, 4, 5, 4);
        gbc_textFieldTitle.fill = 2;
        gbc_textFieldTitle.gridx = 1;
        gbc_textFieldTitle.gridy = 1;
        panelDetails.add((Component)this.textFieldTitle, gbc_textFieldTitle);
        this.textFieldTitle.setColumns(20);
        JPanel panelApply = new JPanel();
        GridBagConstraints gbc_panelApply = new GridBagConstraints();
        gbc_panelApply.anchor = 12;
        gbc_panelApply.weighty = 1.0;
        gbc_panelApply.weightx = 1.0;
        gbc_panelApply.insets = new Insets(4, 4, 4, 4);
        gbc_panelApply.gridx = 1;
        gbc_panelApply.gridy = 2;
        panelDetails.add((Component)panelApply, gbc_panelApply);
        GridBagLayout gbl_panelApply = new GridBagLayout();
        gbl_panelApply.columnWidths = new int[]{0, 0};
        gbl_panelApply.rowHeights = new int[]{0, 0};
        gbl_panelApply.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelApply.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelApply.setLayout(gbl_panelApply);
        this.btnApply = new JButton("Apply");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceLayoutManagerPanel.this.actionApplyLayout();
            }
        });
        this.btnApply.setToolTipText("Apply details");
        GridBagConstraints gbc_btnApply = new GridBagConstraints();
        gbc_btnApply.gridx = 0;
        gbc_btnApply.gridy = 0;
        panelApply.add((Component)this.btnApply, gbc_btnApply);
        JPanel panelLayoutAction = new JPanel();
        GridBagConstraints gbc_panelLayoutAction = new GridBagConstraints();
        gbc_panelLayoutAction.gridwidth = 2;
        gbc_panelLayoutAction.insets = new Insets(4, 4, 4, 5);
        gbc_panelLayoutAction.fill = 1;
        gbc_panelLayoutAction.anchor = 14;
        gbc_panelLayoutAction.gridx = 0;
        gbc_panelLayoutAction.gridy = 3;
        panelDetails.add((Component)panelLayoutAction, gbc_panelLayoutAction);
        GridBagLayout gbl_panelLayoutAction = new GridBagLayout();
        gbl_panelLayoutAction.columnWidths = new int[]{0, 0};
        gbl_panelLayoutAction.rowHeights = new int[]{0, 0};
        gbl_panelLayoutAction.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelLayoutAction.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelLayoutAction.setLayout(gbl_panelLayoutAction);
        this.btnActivate = new JButton("Activate");
        this.btnActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceLayoutManagerPanel.this.actionActivateLayout();
            }
        });
        this.btnActivate.setToolTipText("Activate selected layout");
        GridBagConstraints gbc_btnActivate = new GridBagConstraints();
        gbc_btnActivate.anchor = 13;
        gbc_btnActivate.weightx = 1.0;
        gbc_btnActivate.gridx = 0;
        gbc_btnActivate.gridy = 0;
        panelLayoutAction.add((Component)this.btnActivate, gbc_btnActivate);
        this.initDeviceLayoutManagerPanel();
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JTextField getTextFieldTitle() {
        return this.textFieldTitle;
    }

    protected JButton getBtnClone() {
        return this.btnClone;
    }

    protected JButton getBtnRemove() {
        return this.btnRemove;
    }

    protected void initDeviceLayoutManagerPanel() {
        this.layoutListModel = new DefaultListModel();
        this.listLayouts.setModel(this.layoutListModel);
        this.listLayouts.setCellRenderer(new LayoutListCellRenderer());
        this.checkEnable();
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
        this.refresh();
    }

    protected void refresh() {
        int selIndex = -1;
        this.layoutListModel.removeAllElements();
        if (this.studio != null) {
            for (Layout layout : this.studio.getLayouts()) {
                if (layout == null) continue;
                if (layout == this.selectedLayout) {
                    selIndex = this.layoutListModel.getSize();
                }
                this.layoutListModel.addElement(layout);
            }
        }
        if (selIndex >= 0) {
            this.listLayouts.setSelectedIndex(selIndex);
        }
        this.handleLayoutSelected();
    }

    protected void refreshDetails() {
        Layout layout = this.selectedLayout;
        this.btnApply.setEnabled(layout != null);
        this.btnActivate.setEnabled(layout != null);
        this.textFieldName.setEnabled(layout != null);
        this.textFieldTitle.setEnabled(layout != null);
        String name = null;
        String title = null;
        if (layout != null) {
            name = layout.getName();
            title = layout.getTitle();
        }
        if (name == null) {
            name = "";
        }
        this.textFieldName.setText(name);
        if (title == null) {
            title = "";
        }
        this.textFieldTitle.setText(title);
    }

    protected void handleLayoutSelected() {
        this.checkEnable();
        Layout layout = null;
        int[] sel = this.listLayouts.getSelectedIndices();
        if (sel.length == 1) {
            layout = (Layout)this.layoutListModel.getElementAt(sel[0]);
        }
        this.selectedLayout = layout;
        this.refreshDetails();
    }

    protected void checkEnable() {
        int[] sel = this.listLayouts.getSelectedIndices();
        this.btnClone.setEnabled(sel.length == 1);
        this.btnRemove.setEnabled(sel.length > 0);
    }

    protected void actionAddLayout() {
        try {
            Layout newLayout;
            Studio studio = this.getStudio();
            if (studio == null) {
                return;
            }
            String newName = "New Layout";
            this.selectedLayout = newLayout = new Layout(newName);
            studio.addLayout(newLayout);
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionCloneLayout() {
        try {
            Studio studio = this.getStudio();
            if (studio == null) {
                return;
            }
            Layout layout = this.selectedLayout;
            if (layout == null) {
                return;
            }
            Layout newLayout = layout.cloneLayout();
            if (newLayout == null) {
                return;
            }
            this.selectedLayout = newLayout;
            studio.addLayout(newLayout);
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionRemoveLayout() {
        try {
            Studio studio = this.getStudio();
            if (studio == null) {
                return;
            }
            int[] sel = this.listLayouts.getSelectedIndices();
            if (sel.length < 1) {
                return;
            }
            ArrayList<Layout> list = new ArrayList<Layout>(sel.length);
            for (int i = 0; i < sel.length; ++i) {
                Layout layout = (Layout)this.layoutListModel.getElementAt(sel[i]);
                if (layout == null) continue;
                list.add(layout);
            }
            Layout activeLayout = studio.getLayout();
            int num = list.size();
            for (int i = 0; i < num; ++i) {
                Layout layout = (Layout)list.get(i);
                studio.removeLayout(layout);
                if (layout != activeLayout) continue;
                activeLayout = null;
            }
            if (activeLayout == null) {
                num = studio.getLayoutCount();
                if (num > 0) {
                    activeLayout = studio.getLayoutAt(0);
                }
                if (activeLayout != null) {
                    studio.setLayout(activeLayout);
                }
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JList getListLayouts() {
        return this.listLayouts;
    }

    protected JButton getBtnApply() {
        return this.btnApply;
    }

    protected JButton getBtnActivate() {
        return this.btnActivate;
    }

    protected void actionApplyLayout() {
        try {
            Studio studio = this.getStudio();
            if (studio == null) {
                return;
            }
            Layout layout = this.selectedLayout;
            if (layout == null) {
                return;
            }
            String name = this.textFieldName.getText().trim();
            String title = this.textFieldTitle.getText().trim();
            this.selectedLayout.setName(name);
            this.selectedLayout.setTitle(title);
            this.listLayouts.validate();
            this.listLayouts.repaint();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionActivateLayout() {
        try {
            Studio studio = this.getStudio();
            if (studio == null) {
                return;
            }
            Layout layout = this.selectedLayout;
            if (layout == null) {
                return;
            }
            studio.setLayout(layout);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected class LayoutListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -1093246440210869434L;

        protected LayoutListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null && value instanceof Layout) {
                Layout layout = (Layout)value;
                text = layout.getName();
            }
            if (text == null) {
                text = "";
            }
            this.setText(text);
            return comp;
        }
    }
}

