/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.tooling.TMenu;
import com.spacekiller.util.tooling.ToolContext;
import com.waxmonster.studio.Layout;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.view.StudioToolContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class DeviceLayoutMenu
extends TMenu {
    private static final Logger logger = Logger.getLogger(DeviceLayoutMenu.class.getName());

    protected void refreshInstance(Object c) {
        super.refreshInstance(c);
        ToolContext tc = this.getToolContext(c);
        if (tc != null && tc instanceof StudioToolContext) {
            StudioToolContext stc = (StudioToolContext)tc;
            if (c instanceof JMenu) {
                JMenu menu = (JMenu)c;
                this.refreshLayoutMenu(menu, stc);
            }
        }
    }

    protected void refreshLayoutMenu(JMenu menu, StudioToolContext ctx) {
        menu.removeAll();
        Studio studio = ctx.getStudio();
        if (studio != null) {
            Layout currentLayout = studio.getLayout();
            for (Layout layout : studio.getLayouts()) {
                if (layout == null) continue;
                String text = layout.getTitle();
                if ((text == null || text.length() < 1) && (text = layout.getName()) == null) {
                    text = layout.toString();
                }
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(text);
                item.setOpaque(false);
                item.addActionListener(new SwitchLayoutActionHandler(ctx, layout, item));
                if (layout == currentLayout) {
                    item.setSelected(true);
                }
                menu.add(item);
            }
        }
        menu.addSeparator();
        JMenuItem itemNewLayout = new JMenuItem("Manage Layouts...");
        itemNewLayout.setOpaque(false);
        itemNewLayout.setToolTipText("Shows the layout manager dialog...");
        itemNewLayout.addActionListener(new ManageLayoutsActionHandler(ctx));
        menu.add(itemNewLayout);
    }

    protected class ManageLayoutsActionHandler
    implements ActionListener {
        private StudioToolContext ctx;

        public ManageLayoutsActionHandler(StudioToolContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                this.ctx.showLayoutManagerDialog();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class SwitchLayoutActionHandler
    implements ActionListener {
        private StudioToolContext ctx;
        private Layout layout;
        private JCheckBoxMenuItem item;

        public SwitchLayoutActionHandler(StudioToolContext ctx, Layout layout, JCheckBoxMenuItem item) {
            this.ctx = ctx;
            this.layout = layout;
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.item.setSelected(true);
            Studio studio = this.ctx.getStudio();
            if (studio != null) {
                if (studio.getLayout() == this.layout) {
                    return;
                }
                studio.setLayout(this.layout);
            }
        }
    }
}

