/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.media.control.Control;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.common.ControlListPanel;
import com.waxmonster.studio.common.DeviceStatusLabel;
import com.waxmonster.studio.common.PresetManagerPanel;
import com.waxmonster.studio.common.PresetProducer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class DeviceSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 63787629533224306L;
    private static final Logger logger = Logger.getLogger(DeviceSettingsPanel.class.getName());
    private final PresetProducerImpl presetProducer = new PresetProducerImpl();
    private Device device;
    private boolean refreshing;
    private DefaultTableModel propsTableModel;
    private DefaultTableColumnModel propsColumnModel;
    private DateFormat logDateFormat;
    private String newLine = "\n";
    private JLabel lblTypeInfo;
    private JTabbedPane tabbedPane;
    private JLabel lblPortInfo;
    private DeviceStatusLabel deviceStatusLabel;
    private JTextField textFieldTitle;
    private JButton btnApplyTitle;
    private JTable tableProps;
    private JTextArea textAreaDetails;
    private JLabel lblControlCount;
    private JLabel lblPropsCount;
    private ControlListPanel controlListPanel;
    private PresetManagerPanel presetManagerPanel;

    public DeviceSettingsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.tabbedPane = new JTabbedPane(1);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weighty = 1.0;
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 0;
        this.add((Component)this.tabbedPane, gbc_tabbedPane);
        JPanel panelDevice = new JPanel();
        this.tabbedPane.addTab("Device ", new ImageIcon(DeviceSettingsPanel.class.getResource("/com/waxmonster/studio/impl/icons/waxmonster_device_icon16.gif")), panelDevice, null);
        GridBagLayout gbl_panelDevice = new GridBagLayout();
        gbl_panelDevice.columnWidths = new int[]{0, 0};
        gbl_panelDevice.rowHeights = new int[]{0, 0, 0};
        gbl_panelDevice.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelDevice.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelDevice.setLayout(gbl_panelDevice);
        JPanel panelMain = new JPanel();
        GridBagConstraints gbc_panelMain = new GridBagConstraints();
        gbc_panelMain.insets = new Insets(4, 8, 5, 8);
        gbc_panelMain.weightx = 1.0;
        gbc_panelMain.fill = 1;
        gbc_panelMain.gridx = 0;
        gbc_panelMain.gridy = 0;
        panelDevice.add((Component)panelMain, gbc_panelMain);
        GridBagLayout gbl_panelMain = new GridBagLayout();
        gbl_panelMain.columnWidths = new int[]{0, 0, 0};
        gbl_panelMain.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panelMain.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMain.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelMain.setLayout(gbl_panelMain);
        JLabel lblTitle = new JLabel("Title:");
        GridBagConstraints gbc_lblTitle = new GridBagConstraints();
        gbc_lblTitle.anchor = 17;
        gbc_lblTitle.insets = new Insets(4, 0, 5, 5);
        gbc_lblTitle.gridx = 0;
        gbc_lblTitle.gridy = 0;
        panelMain.add((Component)lblTitle, gbc_lblTitle);
        JPanel panelTitle = new JPanel();
        GridBagConstraints gbc_panelTitle = new GridBagConstraints();
        gbc_panelTitle.insets = new Insets(4, 4, 5, 0);
        gbc_panelTitle.fill = 1;
        gbc_panelTitle.gridx = 1;
        gbc_panelTitle.gridy = 0;
        panelMain.add((Component)panelTitle, gbc_panelTitle);
        GridBagLayout gbl_panelTitle = new GridBagLayout();
        gbl_panelTitle.columnWidths = new int[]{0, 0, 0};
        gbl_panelTitle.rowHeights = new int[]{0, 0};
        gbl_panelTitle.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelTitle.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelTitle.setLayout(gbl_panelTitle);
        this.textFieldTitle = new JTextField();
        this.textFieldTitle.setToolTipText("Device title");
        this.textFieldTitle.setColumns(10);
        GridBagConstraints gbc_textFieldTitle = new GridBagConstraints();
        gbc_textFieldTitle.weightx = 1.0;
        gbc_textFieldTitle.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldTitle.fill = 1;
        gbc_textFieldTitle.gridx = 0;
        gbc_textFieldTitle.gridy = 0;
        panelTitle.add((Component)this.textFieldTitle, gbc_textFieldTitle);
        this.btnApplyTitle = new JButton("");
        this.btnApplyTitle.setIcon(new ImageIcon(DeviceSettingsPanel.class.getResource("/com/waxmonster/studio/impl/icons/waxmonster_apply_icon16.png")));
        this.btnApplyTitle.setMargin(new Insets(2, 2, 2, 2));
        this.btnApplyTitle.setToolTipText("Apply title");
        this.btnApplyTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSettingsPanel.this.applyTitle();
            }
        });
        GridBagConstraints gbc_btnApplyTitle = new GridBagConstraints();
        gbc_btnApplyTitle.gridx = 1;
        gbc_btnApplyTitle.gridy = 0;
        panelTitle.add((Component)this.btnApplyTitle, gbc_btnApplyTitle);
        JLabel lblType = new JLabel("Type:");
        GridBagConstraints gbc_lblType = new GridBagConstraints();
        gbc_lblType.anchor = 17;
        gbc_lblType.insets = new Insets(4, 0, 5, 5);
        gbc_lblType.gridx = 0;
        gbc_lblType.gridy = 1;
        panelMain.add((Component)lblType, gbc_lblType);
        this.lblTypeInfo = new JLabel("Type Info");
        GridBagConstraints gbc_lblTypeInfo = new GridBagConstraints();
        gbc_lblTypeInfo.insets = new Insets(4, 4, 5, 0);
        gbc_lblTypeInfo.weightx = 1.0;
        gbc_lblTypeInfo.fill = 2;
        gbc_lblTypeInfo.gridx = 1;
        gbc_lblTypeInfo.gridy = 1;
        panelMain.add((Component)this.lblTypeInfo, gbc_lblTypeInfo);
        JLabel lblPorts = new JLabel("Ports:");
        GridBagConstraints gbc_lblPorts = new GridBagConstraints();
        gbc_lblPorts.anchor = 17;
        gbc_lblPorts.insets = new Insets(4, 0, 5, 5);
        gbc_lblPorts.gridx = 0;
        gbc_lblPorts.gridy = 2;
        panelMain.add((Component)lblPorts, gbc_lblPorts);
        this.lblPortInfo = new JLabel("Port Info");
        GridBagConstraints gbc_lblPortInfo = new GridBagConstraints();
        gbc_lblPortInfo.fill = 2;
        gbc_lblPortInfo.insets = new Insets(4, 4, 5, 0);
        gbc_lblPortInfo.gridx = 1;
        gbc_lblPortInfo.gridy = 2;
        panelMain.add((Component)this.lblPortInfo, gbc_lblPortInfo);
        JLabel lblStatus = new JLabel("Status:");
        GridBagConstraints gbc_lblStatus = new GridBagConstraints();
        gbc_lblStatus.anchor = 17;
        gbc_lblStatus.insets = new Insets(4, 0, 0, 5);
        gbc_lblStatus.gridx = 0;
        gbc_lblStatus.gridy = 3;
        panelMain.add((Component)lblStatus, gbc_lblStatus);
        this.deviceStatusLabel = new DeviceStatusLabel("Status Info");
        GridBagConstraints gbc_lblStatusInfo = new GridBagConstraints();
        gbc_lblStatusInfo.fill = 2;
        gbc_lblStatusInfo.insets = new Insets(4, 4, 0, 0);
        gbc_lblStatusInfo.gridx = 1;
        gbc_lblStatusInfo.gridy = 3;
        panelMain.add((Component)this.deviceStatusLabel, gbc_lblStatusInfo);
        JPanel panelPresets = new JPanel();
        GridBagConstraints gbc_panelPresets = new GridBagConstraints();
        gbc_panelPresets.insets = new Insets(0, 8, 8, 8);
        gbc_panelPresets.weighty = 1.0;
        gbc_panelPresets.weightx = 1.0;
        gbc_panelPresets.fill = 1;
        gbc_panelPresets.gridx = 0;
        gbc_panelPresets.gridy = 1;
        panelDevice.add((Component)panelPresets, gbc_panelPresets);
        GridBagLayout gbl_panelPresets = new GridBagLayout();
        gbl_panelPresets.columnWidths = new int[]{0, 0};
        gbl_panelPresets.rowHeights = new int[]{0, 0};
        gbl_panelPresets.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelPresets.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelPresets.setLayout(gbl_panelPresets);
        this.presetManagerPanel = new PresetManagerPanel();
        this.presetManagerPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DeviceSettingsPanel.this.refreshing) {
                    DeviceSettingsPanel.this.actionLoadPreset();
                }
            }
        });
        GridBagConstraints gbc_presetChooserPanel = new GridBagConstraints();
        gbc_presetChooserPanel.weighty = 1.0;
        gbc_presetChooserPanel.weightx = 1.0;
        gbc_presetChooserPanel.fill = 1;
        gbc_presetChooserPanel.gridx = 0;
        gbc_presetChooserPanel.gridy = 0;
        panelPresets.add((Component)this.presetManagerPanel, gbc_presetChooserPanel);
        JPanel panelControls = new JPanel();
        this.tabbedPane.addTab("Controls ", new ImageIcon(DeviceSettingsPanel.class.getResource("/com/waxmonster/studio/impl/icons/waxmonster_studio_device_controls.png")), panelControls, null);
        GridBagLayout gbl_panelControls = new GridBagLayout();
        gbl_panelControls.columnWidths = new int[]{0, 0};
        gbl_panelControls.rowHeights = new int[]{0, 0, 0};
        gbl_panelControls.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelControls.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelControls.setLayout(gbl_panelControls);
        JPanel panelControlsInfo = new JPanel();
        GridBagConstraints gbc_panelControlsInfo = new GridBagConstraints();
        gbc_panelControlsInfo.weightx = 1.0;
        gbc_panelControlsInfo.insets = new Insets(8, 8, 8, 8);
        gbc_panelControlsInfo.fill = 1;
        gbc_panelControlsInfo.gridx = 0;
        gbc_panelControlsInfo.gridy = 0;
        panelControls.add((Component)panelControlsInfo, gbc_panelControlsInfo);
        GridBagLayout gbl_panelControlsInfo = new GridBagLayout();
        gbl_panelControlsInfo.columnWidths = new int[]{0, 0, 0};
        gbl_panelControlsInfo.rowHeights = new int[]{0, 0};
        gbl_panelControlsInfo.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelControlsInfo.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelControlsInfo.setLayout(gbl_panelControlsInfo);
        JLabel lblControls = new JLabel("Controls:");
        GridBagConstraints gbc_lblControls = new GridBagConstraints();
        gbc_lblControls.insets = new Insets(0, 0, 0, 5);
        gbc_lblControls.gridx = 0;
        gbc_lblControls.gridy = 0;
        panelControlsInfo.add((Component)lblControls, gbc_lblControls);
        this.lblControlCount = new JLabel("X");
        GridBagConstraints gbc_lblControlCount = new GridBagConstraints();
        gbc_lblControlCount.weightx = 1.0;
        gbc_lblControlCount.fill = 2;
        gbc_lblControlCount.gridx = 1;
        gbc_lblControlCount.gridy = 0;
        panelControlsInfo.add((Component)this.lblControlCount, gbc_lblControlCount);
        this.controlListPanel = new ControlListPanel();
        GridBagConstraints gbc_controlListPanel = new GridBagConstraints();
        gbc_controlListPanel.insets = new Insets(0, 8, 8, 8);
        gbc_controlListPanel.weighty = 1.0;
        gbc_controlListPanel.weightx = 1.0;
        gbc_controlListPanel.fill = 1;
        gbc_controlListPanel.gridx = 0;
        gbc_controlListPanel.gridy = 1;
        panelControls.add((Component)this.controlListPanel, gbc_controlListPanel);
        JPanel panelProps = new JPanel();
        this.tabbedPane.addTab("Properties ", new ImageIcon(DeviceSettingsPanel.class.getResource("/com/waxmonster/studio/impl/icons/waxmonster_studio_device_props.png")), panelProps, null);
        GridBagLayout gbl_panelProps = new GridBagLayout();
        gbl_panelProps.columnWidths = new int[]{0, 0};
        gbl_panelProps.rowHeights = new int[]{0, 0, 0};
        gbl_panelProps.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelProps.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        panelProps.setLayout(gbl_panelProps);
        JPanel panelPropsTable = new JPanel();
        GridBagConstraints gbc_panelPropsTable = new GridBagConstraints();
        gbc_panelPropsTable.insets = new Insets(0, 8, 8, 8);
        gbc_panelPropsTable.weighty = 1.0;
        gbc_panelPropsTable.weightx = 1.0;
        gbc_panelPropsTable.fill = 1;
        gbc_panelPropsTable.gridx = 0;
        gbc_panelPropsTable.gridy = 1;
        panelProps.add((Component)panelPropsTable, gbc_panelPropsTable);
        GridBagLayout gbl_panelPropsTable = new GridBagLayout();
        gbl_panelPropsTable.columnWidths = new int[]{0, 0};
        gbl_panelPropsTable.rowHeights = new int[]{0, 0};
        gbl_panelPropsTable.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelPropsTable.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelPropsTable.setLayout(gbl_panelPropsTable);
        JScrollPane scrollPanePropsTable = new JScrollPane();
        GridBagConstraints gbc_scrollPanePropsTable = new GridBagConstraints();
        gbc_scrollPanePropsTable.weighty = 1.0;
        gbc_scrollPanePropsTable.weightx = 1.0;
        gbc_scrollPanePropsTable.fill = 1;
        gbc_scrollPanePropsTable.gridx = 0;
        gbc_scrollPanePropsTable.gridy = 0;
        panelPropsTable.add((Component)scrollPanePropsTable, gbc_scrollPanePropsTable);
        this.tableProps = new JTable();
        scrollPanePropsTable.setViewportView(this.tableProps);
        JPanel panelPropsInfo = new JPanel();
        GridBagConstraints gbc_panelPropsInfo = new GridBagConstraints();
        gbc_panelPropsInfo.insets = new Insets(8, 8, 8, 8);
        gbc_panelPropsInfo.fill = 1;
        gbc_panelPropsInfo.gridx = 0;
        gbc_panelPropsInfo.gridy = 0;
        panelProps.add((Component)panelPropsInfo, gbc_panelPropsInfo);
        GridBagLayout gbl_panelPropsInfo = new GridBagLayout();
        gbl_panelPropsInfo.columnWidths = new int[]{0, 0, 0};
        gbl_panelPropsInfo.rowHeights = new int[]{0, 0};
        gbl_panelPropsInfo.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelPropsInfo.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelPropsInfo.setLayout(gbl_panelPropsInfo);
        JLabel lblProperties = new JLabel("Properties:");
        GridBagConstraints gbc_lblProperties = new GridBagConstraints();
        gbc_lblProperties.insets = new Insets(0, 0, 0, 5);
        gbc_lblProperties.gridx = 0;
        gbc_lblProperties.gridy = 0;
        panelPropsInfo.add((Component)lblProperties, gbc_lblProperties);
        this.lblPropsCount = new JLabel("X");
        GridBagConstraints gbc_lblPropsCount = new GridBagConstraints();
        gbc_lblPropsCount.weightx = 1.0;
        gbc_lblPropsCount.fill = 2;
        gbc_lblPropsCount.gridx = 1;
        gbc_lblPropsCount.gridy = 0;
        panelPropsInfo.add((Component)this.lblPropsCount, gbc_lblPropsCount);
        JPanel panelDetails = new JPanel();
        this.tabbedPane.addTab("Details ", new ImageIcon(DeviceSettingsPanel.class.getResource("/com/waxmonster/studio/impl/icons/waxmonster_details_icon16.gif")), panelDetails, null);
        GridBagLayout gbl_panelDetails = new GridBagLayout();
        gbl_panelDetails.columnWidths = new int[]{0, 0};
        gbl_panelDetails.rowHeights = new int[]{0, 0};
        gbl_panelDetails.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelDetails.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelDetails.setLayout(gbl_panelDetails);
        JPanel panelDetailsInfo = new JPanel();
        GridBagConstraints gbc_panelDetailsInfo = new GridBagConstraints();
        gbc_panelDetailsInfo.weighty = 1.0;
        gbc_panelDetailsInfo.weightx = 1.0;
        gbc_panelDetailsInfo.insets = new Insets(8, 8, 8, 8);
        gbc_panelDetailsInfo.fill = 1;
        gbc_panelDetailsInfo.gridx = 0;
        gbc_panelDetailsInfo.gridy = 0;
        panelDetails.add((Component)panelDetailsInfo, gbc_panelDetailsInfo);
        GridBagLayout gbl_panelDetailsInfo = new GridBagLayout();
        gbl_panelDetailsInfo.columnWidths = new int[]{0, 0};
        gbl_panelDetailsInfo.rowHeights = new int[]{0, 0};
        gbl_panelDetailsInfo.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelDetailsInfo.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelDetailsInfo.setLayout(gbl_panelDetailsInfo);
        JScrollPane scrollPaneDetails = new JScrollPane();
        GridBagConstraints gbc_scrollPaneDetails = new GridBagConstraints();
        gbc_scrollPaneDetails.weighty = 1.0;
        gbc_scrollPaneDetails.weightx = 1.0;
        gbc_scrollPaneDetails.fill = 1;
        gbc_scrollPaneDetails.gridx = 0;
        gbc_scrollPaneDetails.gridy = 0;
        panelDetailsInfo.add((Component)scrollPaneDetails, gbc_scrollPaneDetails);
        this.textAreaDetails = new JTextArea();
        this.textAreaDetails.setOpaque(false);
        this.textAreaDetails.setEditable(false);
        scrollPaneDetails.setViewportView(this.textAreaDetails);
        this.initDeviceSettingsPanel();
    }

    private void initDeviceSettingsPanel() {
        this.logDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        this.textFieldTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DeviceSettingsPanel.this.refreshing) {
                    DeviceSettingsPanel.this.titleChanged();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DeviceSettingsPanel.this.refreshing) {
                    DeviceSettingsPanel.this.titleChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DeviceSettingsPanel.this.refreshing) {
                    DeviceSettingsPanel.this.titleChanged();
                }
            }
        });
        DefaultCellEditor dummyCellEditor = new DefaultCellEditor(new JTextField());
        dummyCellEditor.setClickCountToStart(Integer.MAX_VALUE);
        this.propsTableModel = new DefaultTableModel();
        this.propsTableModel.addColumn("Key");
        this.propsTableModel.addColumn("Value");
        this.tableProps.setModel(this.propsTableModel);
        this.propsColumnModel = new DefaultTableColumnModel();
        TableColumn columnKey = new TableColumn(0);
        columnKey.setHeaderValue("Key");
        columnKey.setCellEditor(dummyCellEditor);
        this.propsColumnModel.addColumn(columnKey);
        TableColumn columnValue = new TableColumn(1);
        columnValue.setHeaderValue("Value");
        columnValue.setCellEditor(dummyCellEditor);
        this.propsColumnModel.addColumn(columnValue);
        this.tableProps.setColumnModel(this.propsColumnModel);
    }

    protected void titleChanged() {
        this.btnApplyTitle.setEnabled(true);
    }

    protected void applyTitle() {
        this.btnApplyTitle.setEnabled(false);
        Device dev = this.device;
        if (dev == null) {
            return;
        }
        String title = this.textFieldTitle.getText();
        if ((title = title.trim()).length() < 1) {
            title = null;
        }
        dev.setTitle(title);
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            Device dev = this.getDevice();
            Studio studio = null;
            String name = null;
            String title = null;
            String typeInfo = null;
            Icon typeIcon = null;
            String portInfo = null;
            String connInfo = null;
            Properties props = null;
            Control[] controls = null;
            Port[] ports = null;
            int portCount = 0;
            Port[] missingPorts = null;
            int missingPortCount = 0;
            Connection[] conns = null;
            int connCount = 0;
            Connection[] invalidConns = null;
            int invalidConnCount = 0;
            LogRecord[] errors = null;
            int errorCount = 0;
            String presetName = null;
            if (dev != null) {
                studio = dev.getStudio();
                name = dev.getName();
                title = dev.getTitle();
                typeInfo = name;
                if (title == null) {
                    title = typeInfo;
                }
                typeIcon = dev.getIcon(1);
                DeviceProvider provider = dev.getProvider();
                if (provider != null) {
                    typeInfo = typeInfo + " (" + provider.getName() + ")";
                }
                portCount = (ports = dev.getPorts()) == null ? 0 : ports.length;
                missingPorts = dev.getMissingPorts();
                missingPortCount = missingPorts == null ? 0 : missingPorts.length;
                portInfo = String.valueOf(portCount) + " ports";
                if (missingPortCount > 0) {
                    portInfo = portInfo + " (" + missingPortCount + " missing!)";
                }
                connCount = (conns = dev.getConnections()) == null ? 0 : conns.length;
                invalidConns = dev.getInvalidConnections();
                invalidConnCount = invalidConns == null ? 0 : invalidConns.length;
                connInfo = String.valueOf(connCount) + " connections";
                if (invalidConnCount > 0) {
                    connInfo = connInfo + " (" + invalidConnCount + " invalid!)";
                }
                errorCount = (errors = dev.getErrors()) == null ? 0 : errors.length;
                props = dev.getProperties();
                controls = dev.getControls();
                presetName = dev.getPresetName();
            }
            if (title == null) {
                title = "";
            }
            if (typeInfo == null) {
                typeInfo = "";
            }
            if (portInfo == null) {
                portInfo = "";
            }
            if (connInfo == null) {
                connInfo = "";
            }
            this.textFieldTitle.setText(title);
            this.btnApplyTitle.setEnabled(false);
            this.lblTypeInfo.setText(typeInfo);
            this.lblTypeInfo.setIcon(typeIcon);
            this.lblPortInfo.setText(portInfo + ", " + connInfo);
            this.deviceStatusLabel.updateStatus(dev);
            this.presetManagerPanel.setDeviceName(name);
            this.presetManagerPanel.setStudio(studio);
            this.presetManagerPanel.setPresetName(presetName);
            this.presetManagerPanel.setPresetProducer((PresetProducer)this.presetProducer);
            int controlCount = controls == null ? 0 : controls.length;
            this.lblControlCount.setText(String.valueOf(controlCount));
            this.controlListPanel.setControls(controls);
            TreeMap<Object, Object> propsMap = new TreeMap<Object, Object>();
            if (props != null) {
                propsMap.putAll(props);
            }
            int propsCount = propsMap.size();
            this.lblPropsCount.setText(String.valueOf(propsCount));
            this.propsTableModel.setRowCount(propsCount);
            int row = 0;
            for (Map.Entry me : propsMap.entrySet()) {
                this.propsTableModel.setValueAt(me.getKey(), row, 0);
                this.propsTableModel.setValueAt(me.getValue(), row, 1);
                ++row;
            }
            StringBuffer sb = new StringBuffer();
            if (dev != null) {
                int i;
                sb.append("Title: " + this.deviceTitle(dev));
                sb.append(this.newLine);
                sb.append("Type: " + typeInfo);
                sb.append(this.newLine);
                sb.append("Class: " + dev.getClass().getName());
                sb.append(this.newLine);
                DeviceProvider provider = dev.getProvider();
                sb.append("Provider: " + (provider == null ? "N/A" : provider.getClass().getName()));
                sb.append(this.newLine);
                sb.append("Position: ");
                Point position = dev.getPosition();
                if (position != null) {
                    sb.append(position.x + ", " + position.y);
                }
                sb.append(this.newLine);
                sb.append("Enabled: " + dev.isEnabled());
                sb.append(this.newLine);
                sb.append("Active: " + dev.isActive());
                sb.append(this.newLine);
                sb.append("Ports: " + portInfo);
                sb.append(this.newLine);
                for (i = 0; i < portCount; ++i) {
                    sb.append(" - ");
                    this.appendPortInfo(ports[i], sb);
                    sb.append(this.newLine);
                }
                for (i = 0; i < missingPortCount; ++i) {
                    sb.append(" - MISSING: ");
                    this.appendPortInfo(missingPorts[i], sb);
                    sb.append(this.newLine);
                }
                sb.append("Links: " + connInfo);
                sb.append(this.newLine);
                for (i = 0; i < connCount; ++i) {
                    sb.append(" - ");
                    this.appendConnectionInfo(conns[i], sb);
                    sb.append(this.newLine);
                }
                for (i = 0; i < invalidConnCount; ++i) {
                    sb.append(" - INVALID: ");
                    this.appendConnectionInfo(invalidConns[i], sb);
                    sb.append(this.newLine);
                }
                sb.append("Controls: " + controlCount);
                sb.append(this.newLine);
                for (i = 0; i < controlCount; ++i) {
                    Control control = controls[i];
                    sb.append(" - ");
                    if (control == null) {
                        sb.append("null");
                    } else {
                        try {
                            sb.append(String.valueOf(control.getName()));
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            sb.append("<Error: " + e.getMessage() + ">");
                        }
                        sb.append(" = ");
                        try {
                            sb.append(String.valueOf(control.getValue()));
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            sb.append("<Error: " + e.getMessage() + ">");
                        }
                    }
                    sb.append(this.newLine);
                }
                sb.append("Properties: " + propsCount);
                sb.append(this.newLine);
                for (Map.Entry me : propsMap.entrySet()) {
                    sb.append(" - ");
                    sb.append(String.valueOf(me.getKey()));
                    sb.append(" = ");
                    sb.append(String.valueOf(me.getValue()));
                    sb.append(this.newLine);
                    ++row;
                }
                sb.append("Errors: " + errorCount);
                sb.append(this.newLine);
                for (int i2 = 0; i2 < errorCount; ++i2) {
                    sb.append(" - ");
                    this.appendLogRecord(errors[i2], sb);
                    sb.append(this.newLine);
                }
            }
            this.textAreaDetails.setText(sb.toString());
            this.textAreaDetails.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void appendPortInfo(Port port, StringBuffer sb) {
        PortType type;
        if (port == null) {
            return;
        }
        String name = port.getName();
        sb.append(String.valueOf(name));
        String title = port.getTitle();
        if (title != null && !title.equals(name)) {
            sb.append(" \"" + title + "\"");
        }
        String typeName = (type = port.getType()) == null ? null : type.getName();
        sb.append(" (" + typeName + ")");
    }

    protected void appendConnectionInfo(Connection conn, StringBuffer sb) {
        Device dev;
        Port partner;
        Port port;
        if (conn == null) {
            return;
        }
        Port source = conn.getSource();
        Port target = conn.getTarget();
        if (source.getDevice() == this.device) {
            port = source;
            partner = target;
        } else if (target.getDevice() == this.device) {
            port = target;
            partner = source;
        } else {
            port = source;
            partner = target;
        }
        if (port != null) {
            sb.append(String.valueOf(port.getName()));
            dev = port.getDevice();
            if (dev != null && dev != this.device) {
                sb.append(" (");
                sb.append(this.deviceTitle(dev));
                sb.append(')');
            }
        }
        sb.append(" <=> ");
        if (partner != null) {
            sb.append(String.valueOf(partner.getName()));
            dev = partner.getDevice();
            if (dev != null && dev != this.device) {
                sb.append(" (");
                sb.append(this.deviceTitle(dev));
                sb.append(')');
            }
        }
    }

    protected String deviceTitle(Device device) {
        if (device == null) {
            return null;
        }
        String title = device.getTitle();
        if (title != null && title.length() > 0) {
            return title;
        }
        return device.getName();
    }

    protected void appendLogRecord(LogRecord record, StringBuffer sb) {
        if (record == null) {
            return;
        }
        sb.append(this.logDateFormat.format(new Date(record.getMillis())));
        sb.append(' ');
        sb.append(String.valueOf(record.getLevel()));
        sb.append(' ');
        String message = record.getMessage();
        if (message != null) {
            sb.append(message);
        }
    }

    protected JLabel getLabelTypeInfo() {
        return this.lblTypeInfo;
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected JLabel getLblPortInfo() {
        return this.lblPortInfo;
    }

    protected JLabel getLblStatusInfo() {
        return this.deviceStatusLabel;
    }

    protected JButton getBtnApplyTitle() {
        return this.btnApplyTitle;
    }

    protected JTextField getTextFieldTitle() {
        return this.textFieldTitle;
    }

    protected JTable getTableProps() {
        return this.tableProps;
    }

    protected JTextArea getTextAreaDetails() {
        return this.textAreaDetails;
    }

    protected JLabel getLblControlCount() {
        return this.lblControlCount;
    }

    protected JLabel getLblPropsCount() {
        return this.lblPropsCount;
    }

    protected ControlListPanel getControlListPanel() {
        return this.controlListPanel;
    }

    protected PresetManagerPanel getPresetManagerPanel() {
        return this.presetManagerPanel;
    }

    protected Preset createDevicePreset() {
        Device dev = this.device;
        if (dev == null) {
            return null;
        }
        try {
            return dev.createPreset();
        }
        catch (StudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected void actionLoadPreset() {
        Device dev = this.device;
        if (dev == null) {
            return;
        }
        Preset preset = this.presetManagerPanel.getSelectedPreset();
        if (preset == null) {
            return;
        }
        try {
            boolean result;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading preset: device=" + dev + ", preset=" + preset);
            }
            if (result = dev.loadPreset(preset)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Preset loaded: device=" + dev + ", preset=" + preset);
                }
            } else {
                logger.warning("Failed to load preset: device=" + dev + ", preset=" + preset);
            }
            this.refresh();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected class PresetProducerImpl
    implements PresetProducer {
        protected PresetProducerImpl() {
        }

        public Preset createPreset() {
            return DeviceSettingsPanel.this.createDevicePreset();
        }
    }
}

