/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.Editor;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.swing.ZOrderUtil;
import com.spacekiller.util.visual.Connector;
import com.spacekiller.util.visual.LineStyle;
import com.spacekiller.util.visual.StrokeLineStyle;
import com.spacekiller.util.workbench.DefaultPerspective;
import com.spacekiller.util.workbench.DesktopView;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewConstraints;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Layout;
import com.waxmonster.studio.LayoutPanel;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.StudioListener;
import com.waxmonster.studio.view.ConnectionLine;
import com.waxmonster.studio.view.DeviceComponent;
import com.waxmonster.studio.view.DeviceCustomizerView;
import com.waxmonster.studio.view.DeviceSettingsPanel;
import com.waxmonster.studio.view.PortConnector;
import com.waxmonster.studio.view.StudioPlugin;
import com.waxmonster.studio.view.StudioView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class RoutingPanel
extends JPanel {
    private static final long serialVersionUID = 4275820727227639370L;
    private static final Logger logger = Logger.getLogger(RoutingPanel.class.getName());
    private StudioView studioView;
    private Studio studio;
    private StudioHandler studioHandler = new StudioHandler();
    private Refresher refresher = new Refresher();
    private boolean refreshPending = false;
    private Layout currentLayout;
    private boolean ignoreSnapshots;
    private Map deviceMap;
    private Map connMap;
    private LineStyle defaultConnectionLineStyle;
    private LineStyle invalidConnectionLineStyle;
    private MouseHandler mouseHandler = new MouseHandler();
    private MouseMotionHandler mouseMotionHandler = new MouseMotionHandler();
    private KeyHandler keyHandler = new KeyHandler();
    private DeviceMouseHandler deviceMouseHandler = new DeviceMouseHandler();
    private DeviceMouseMotionHandler deviceMouseMotionHandler = new DeviceMouseMotionHandler();
    private DeviceFocusHandler deviceFocusHandler = new DeviceFocusHandler();
    private List selectedDeviceComps;
    private List selectedConnectionLines;
    private PortConnector selectedPortConnector;
    private boolean dirty;
    private Paint deviceBackgroundPaint;
    private Paint selectedDeviceBackgroundPaint;
    private Paint disabledDeviceBackgroundPaint;
    private Stroke deviceOutlineStroke;
    private Stroke selectedDeviceOutlineStroke;
    private Cursor deviceCursor;
    private Cursor connectCursor;
    private int maxDistanceToConnectionLine = 5;
    private DeviceComponent dragDevComp;
    private int prevX = -1;
    private int prevY = -1;
    private JComponent parentComponent;
    private JPopupMenu studioPopupMenu;
    private JPopupMenu addDevicePopupMenu;
    private JPopupMenu devicePopupMenu;
    private JPopupMenu connectionPopupMenu;
    private Point prefDeviceLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private RuntimeContext runtimeContext;
    private JDialog deviceSettingsDialog;
    private DeviceSettingsPanel deviceSettingsPanel = new DeviceSettingsPanel();
    private SettingsRefresher settingsRefresher = new SettingsRefresher();
    private boolean studioStarted;
    private boolean studioStopped;

    public RoutingPanel(StudioView studioView) {
        this.studioView = studioView;
        this.initRoutingPanel();
    }

    private void initRoutingPanel() {
        this.deviceMap = new HashMap();
        this.connMap = new HashMap();
        this.selectedDeviceComps = new LinkedList();
        this.selectedConnectionLines = new LinkedList();
        this.setLayout(null);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseMotionHandler);
        this.addKeyListener(this.keyHandler);
        Stroke normalStroke = null;
        BasicStroke selectedStroke = new BasicStroke(2.0f);
        StrokeLineStyle defaultLineStyle = new StrokeLineStyle();
        defaultLineStyle.setStroke(normalStroke);
        defaultLineStyle.setSelectedStroke((Stroke)selectedStroke);
        defaultLineStyle.setLineColor(new Color(0.0f, 0.0f, 0.0f, 0.7f));
        defaultLineStyle.setSelectedLineColor(new Color(0.4f, 0.4f, 1.0f));
        this.setDefaultConnectionLineStyle((LineStyle)defaultLineStyle);
        StrokeLineStyle invalidLineStyle = new StrokeLineStyle();
        invalidLineStyle.setStroke(normalStroke);
        invalidLineStyle.setSelectedStroke((Stroke)selectedStroke);
        invalidLineStyle.setLineColor(new Color(1.0f, 0.0f, 0.0f, 0.7f));
        invalidLineStyle.setSelectedLineColor(new Color(1.0f, 0.4f, 0.4f));
        this.setInvalidConnectionLineStyle((LineStyle)invalidLineStyle);
        this.setDeviceBackgroundPaint(new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(1.0f, 1.0f, 1.0f), new Point2D.Double(50.0, 100.0), new Color(0.6f, 0.8f, 1.0f)));
        this.setSelectedDeviceBackgroundPaint(new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(1.0f, 1.0f, 0.9f), new Point2D.Double(100.0, 100.0), new Color(0.8f, 0.8f, 0.5f)));
        this.setDisabledDeviceBackgroundPaint(new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(0.9f, 0.9f, 0.9f), new Point2D.Double(100.0, 100.0), new Color(0.5f, 0.5f, 0.5f)));
        this.setDeviceOutlineStroke(new BasicStroke(1.0f));
        this.setSelectedDeviceOutlineStroke(new BasicStroke(2.0f));
        this.setDeviceCursor(Cursor.getPredefinedCursor(12));
        this.setConnectCursor(Cursor.getPredefinedCursor(1));
        this.refresh();
    }

    public Studio getStudio() {
        return this.studio;
    }

    public synchronized void setStudio(Studio newStudio) {
        if (this.studio == newStudio) {
            return;
        }
        if (this.studio != null) {
            this.studio.removeStudioListener((StudioListener)this.studioHandler);
        }
        this.studio = newStudio;
        if (this.studio != null) {
            this.studio.addStudioListener((StudioListener)this.studioHandler);
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLater() {
        Refresher refresher = this.refresher;
        synchronized (refresher) {
            if (this.refreshPending) {
                return;
            }
            this.refreshPending = true;
        }
        SwingUtilities.invokeLater(this.refresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Device dev;
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("refresh...");
        }
        Refresher refresher = this.refresher;
        synchronized (refresher) {
            this.refreshPending = false;
        }
        Device[] devices = null;
        Connection[] conns = null;
        int state = 0;
        Studio studio = this.studio;
        if (studio != null) {
            object = studio;
            synchronized (object) {
                state = studio.getState();
                devices = studio.getDevices();
                conns = studio.getConnections();
                Connection[] ics = studio.getInvalidConnections();
                if (ics != null && ics.length > 0) {
                    Connection[] arr = new Connection[conns.length + ics.length];
                    System.arraycopy(conns, 0, arr, 0, conns.length);
                    System.arraycopy(ics, 0, arr, conns.length, ics.length);
                    conns = arr;
                }
            }
        }
        object = this;
        synchronized (object) {
            HashMap oldDeviceMap = new HashMap(this.deviceMap.size());
            oldDeviceMap.putAll(this.deviceMap);
            HashMap<Device, DeviceComponent> newDeviceMap = new HashMap<Device, DeviceComponent>();
            if (devices != null) {
                for (int i = 0; i < devices.length; ++i) {
                    Device device = devices[i];
                    DeviceComponent devComp = (DeviceComponent)oldDeviceMap.remove(device);
                    if (devComp == null) {
                        devComp = new DeviceComponent();
                        devComp.addMouseListener(this.deviceMouseHandler);
                        devComp.addMouseMotionListener(this.deviceMouseMotionHandler);
                        devComp.addKeyListener(this.keyHandler);
                        devComp.addFocusListener(this.deviceFocusHandler);
                        devComp.setDevice(device);
                        devComp.refresh();
                        devComp.validate();
                        Rectangle bounds = this.computePreferredDeviceBounds(devComp);
                        devComp.setBounds(bounds);
                        this.add(devComp);
                    }
                    devComp.setBackgroundPaint(this.deviceBackgroundPaint);
                    devComp.setSelectedBackgroundPaint(this.selectedDeviceBackgroundPaint);
                    devComp.setDisabledBackgroundPaint(this.disabledDeviceBackgroundPaint);
                    devComp.setOutlineStroke(this.deviceOutlineStroke);
                    devComp.setSelectedOutlineStroke(this.selectedDeviceOutlineStroke);
                    devComp.setConnectCursor(this.connectCursor);
                    devComp.setCursor(this.deviceCursor);
                    devComp.refresh();
                    newDeviceMap.put(device, devComp);
                }
            }
            HashMap oldConnMap = new HashMap(this.connMap.size());
            oldConnMap.putAll(this.connMap);
            HashMap<Connection, ConnectionLine> newConnMap = new HashMap<Connection, ConnectionLine>();
            if (conns != null) {
                for (int i = 0; i < conns.length; ++i) {
                    Connection conn = conns[i];
                    Port sourcePort = conn.getSource();
                    Port targetPort = conn.getTarget();
                    Device sourceDev = sourcePort.getDevice();
                    Device targetDev = targetPort.getDevice();
                    DeviceComponent sourceDeviceComp = (DeviceComponent)newDeviceMap.get(sourceDev);
                    DeviceComponent targetDeviceComp = (DeviceComponent)newDeviceMap.get(targetDev);
                    ConnectionLine line = (ConnectionLine)oldConnMap.get(conn);
                    if (sourceDeviceComp == null || targetDeviceComp == null) continue;
                    PortConnector sourceConnector = sourceDeviceComp.getPortConnector(sourcePort);
                    PortConnector targetConnector = targetDeviceComp.getPortConnector(targetPort);
                    if (sourceConnector == null || targetConnector == null) continue;
                    if (line == null) {
                        LineStyle lineStyle = this.defaultConnectionLineStyle;
                        if (studio != null && studio.isInvalidConnection(conn)) {
                            lineStyle = this.invalidConnectionLineStyle;
                        }
                        line = new ConnectionLine(conn, sourceDeviceComp, sourceConnector, targetDeviceComp, targetConnector, lineStyle);
                    }
                    newConnMap.put(conn, line);
                }
            }
            if (!oldDeviceMap.isEmpty()) {
                for (DeviceComponent devComp : oldDeviceMap.values()) {
                    this.remove(devComp);
                    DeviceCustomizerView dcv = devComp.getDeviceCustomizerView();
                    if (dcv == null) continue;
                    dcv.close();
                }
            }
            for (DeviceComponent devComp : newDeviceMap.values()) {
                Rectangle bounds = this.computePreferredDeviceBounds(devComp);
                devComp.setSize(bounds.width, bounds.height);
            }
            this.deviceMap = newDeviceMap;
            this.connMap = newConnMap;
            switch (state) {
                case 1: {
                    this.setStudioStopped(false);
                    this.setStudioStarted(true);
                    break;
                }
                case 0: {
                    this.setStudioStarted(false);
                    this.setStudioStopped(true);
                }
            }
            this.validateAndRepaint();
        }
        if (this.deviceSettingsDialog != null && this.deviceSettingsDialog.isVisible() && (dev = this.deviceSettingsPanel.getDevice()) != null) {
            if (dev.getStudio() != studio) {
                this.deviceSettingsPanel.setDevice(null);
            } else {
                this.deviceSettingsPanel.refresh();
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("refresh done.");
        }
    }

    protected void validateAndRepaint() {
        JComponent comp = this.parentComponent;
        if (comp == null) {
            comp = this;
        }
        comp.validate();
        comp.repaint();
    }

    public JComponent getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(JComponent parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension();
        for (DeviceComponent devComp : this.deviceMap.values()) {
            Rectangle rect = devComp.getBounds();
            if (rect == null) continue;
            if (rect.x + rect.width > prefSize.width) {
                prefSize.width = rect.x + rect.width;
            }
            if (rect.y + rect.height <= prefSize.height) continue;
            prefSize.height = rect.y + rect.height;
        }
        return prefSize;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintConnections(g);
    }

    protected void paintConnections(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.connMap;
        for (ConnectionLine line : map.values()) {
            line.paint(g2d);
        }
    }

    public DeviceComponent getDeviceComponentAt(int x, int y) {
        Component comp = this.getComponentAt(x, y);
        if (comp != null && comp instanceof DeviceComponent) {
            return (DeviceComponent)comp;
        }
        return null;
    }

    public LineStyle getDefaultConnectionLineStyle() {
        return this.defaultConnectionLineStyle;
    }

    public void setDefaultConnectionLineStyle(LineStyle defaultConnectionLineStyle) {
        this.defaultConnectionLineStyle = defaultConnectionLineStyle;
    }

    public void setSelectedDeviceComponent(DeviceComponent comp, boolean toFront) {
        if (!this.selectedConnectionLines.isEmpty()) {
            this.setSelectedConnectionLine(null);
        }
        Iterator i = this.selectedDeviceComps.iterator();
        while (i.hasNext()) {
            DeviceComponent old = (DeviceComponent)i.next();
            old.setSelected(false);
            i.remove();
        }
        if (comp != null) {
            comp.setSelected(true);
            this.selectedDeviceComps.add(comp);
            Device dev = comp.getDevice();
            if (dev != null) {
                Connection[] conns = dev.getConnections();
                for (int i2 = 0; i2 < conns.length; ++i2) {
                    ConnectionLine line = (ConnectionLine)this.connMap.get(conns[i2]);
                    if (line == null) continue;
                    line.setSelected(true);
                    this.selectedConnectionLines.add(line);
                }
            }
            if (toFront) {
                if (this.getComponent(0) != comp) {
                    ZOrderUtil.setComponentZOrder((Container)this, (Component)comp, (int)0);
                }
                comp.requestFocus();
            }
        }
        this.validateAndRepaint();
    }

    public void setSelectedConnectionLine(ConnectionLine line) {
        Object old;
        Iterator i = this.selectedDeviceComps.iterator();
        while (i.hasNext()) {
            old = (DeviceComponent)i.next();
            ((DeviceComponent)old).setSelected(false);
            i.remove();
        }
        i = this.selectedConnectionLines.iterator();
        while (i.hasNext()) {
            old = (ConnectionLine)i.next();
            ((ConnectionLine)old).setSelected(false);
            i.remove();
        }
        if (line != null) {
            line.setSelected(true);
            this.selectedConnectionLines.add(line);
        }
        this.validateAndRepaint();
    }

    public void setSelectedConnection(Connection conn) {
        ConnectionLine line = (ConnectionLine)this.connMap.get(conn);
        this.setSelectedConnectionLine(line);
    }

    public void setSelectedConnectionLater(final Connection conn) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RoutingPanel.this.setSelectedConnection(conn);
            }
        });
    }

    public ConnectionLine getConnectionLineAt(int x, int y) {
        ConnectionLine best = null;
        double bestDistance = -1.0;
        for (ConnectionLine line : this.connMap.values()) {
            double distance = line.distance(x, y);
            if (best != null && !(distance < bestDistance)) continue;
            best = line;
            bestDistance = distance;
        }
        if (best != null && bestDistance <= (double)this.maxDistanceToConnectionLine) {
            return best;
        }
        return null;
    }

    protected void handleMousePressed(int x, int y, boolean popup) {
        DeviceComponent comp;
        this.dragDevComp = comp = this.getDeviceComponentAt(x, y);
        this.prevX = x;
        this.prevY = y;
        ConnectionLine line = this.getConnectionLineAt(x, y);
        if (line != null) {
            this.setSelectedConnectionLine(line);
            return;
        }
        if (comp != null) {
            this.setSelectedDeviceComponent(comp, true);
        } else {
            if (!this.selectedDeviceComps.isEmpty()) {
                this.setSelectedDeviceComponent(null, false);
            }
            if (!this.selectedConnectionLines.isEmpty()) {
                this.setSelectedConnectionLine(null);
            }
        }
        if (popup) {
            this.showPopupMenu(x, y);
            return;
        }
    }

    protected void handleMouseClicked(int x, int y, int clicks) {
        DeviceComponent comp = this.getDeviceComponentAt(x, y);
        if (comp != null) {
            boolean deiconify;
            Device device;
            this.handleMousePressed(x, y, false);
            Connector connector = comp.getConnectorAtPosition(x, y);
            if (connector != null && connector instanceof PortConnector) {
                PortConnector portConnector = (PortConnector)connector;
                if (this.selectedPortConnector != null) {
                    Port port1 = this.selectedPortConnector.getPort();
                    Port port2 = portConnector.getPort();
                    if (port1 != null && port2 != null && port1 != port2) {
                        if (port1.isConnectable(port2) && port2.isConnectable(port1)) {
                            try {
                                Connection conn = this.studio.connect(port1, port2);
                                this.selectedPortConnector = null;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine("Ports connected: " + port1 + ", " + port2);
                                }
                                if (conn != null) {
                                    this.setSelectedConnectionLater(conn);
                                }
                            }
                            catch (Exception e) {
                                this.handleException(e);
                            }
                            return;
                        }
                        this.handlePortsNotConnectable(port1, port2);
                    }
                }
                this.selectedPortConnector = portConnector;
                return;
            }
            if (clicks == 2 && (device = comp.getDevice()) != null && this.studio != null && !this.showDeviceCustomizer(device, deiconify = true)) {
                this.handleDeviceCustomizerUnavailable(device);
            }
        } else if (!this.selectedDeviceComps.isEmpty()) {
            this.setSelectedDeviceComponent(null, false);
        }
    }

    protected void handleDeviceCustomizerUnavailable(Device device) {
        RuntimeContext rc = this.getRuntimeContext();
        if (rc != null) {
            rc.notify((Object)this, (Object)"The selected device does not provide a custom view.");
        }
    }

    protected void handlePortsNotConnectable(Port port1, Port port2) {
        RuntimeContext rc = this.getRuntimeContext();
        if (rc != null && port1 != null && port2 != null) {
            RoutingPanel source = this;
            String message = null;
            PortType type1 = port1.getType();
            PortType type2 = port2.getType();
            if (!(type1 == null || type2 == null || type1.isConnectable(type2) && type2.isConnectable(type1))) {
                message = "Ports are not compatible: " + port1.getName() + " / " + port2.getName();
            }
            if (message == null) {
                boolean c1 = port1.isConnectable(port2);
                boolean c2 = port2.isConnectable(port1);
                message = c2 && !c1 ? "Port is not connectable: " + port1.getName() : (c1 && !c2 ? "Port is not connectable: " + port2.getName() : "Ports are not connectable: " + port1.getName() + " / " + port2.getName());
            }
            rc.notify((Object)source, message);
        }
    }

    protected void handleMouseDragged(int x, int y) {
        int relX = x - this.prevX;
        int relY = y - this.prevY;
        DeviceComponent comp = this.dragDevComp;
        if (comp != null) {
            int newX = comp.getX() + relX;
            int newY = comp.getY() + relY;
            if (newX < 0) {
                x -= newX;
                newX = 0;
            }
            if (newY < 0) {
                y -= newY;
                newY = 0;
            }
            this.setDirty(true);
            comp.setLocation(newX, newY);
            this.validateAndRepaint();
            Device device = comp.getDevice();
            if (device != null) {
                this.studio.setDevicePosition(device, newX, newY);
            }
        }
        this.prevX = x;
        this.prevY = y;
    }

    protected void handleMouseReleased(int x, int y, boolean popup) {
        this.dragDevComp = null;
        if (popup) {
            DeviceComponent comp = this.getDeviceComponentAt(x, y);
            if (comp != null) {
                if (!this.selectedDeviceComps.contains(comp)) {
                    this.setSelectedDeviceComponent(comp, true);
                }
            } else if (!this.selectedDeviceComps.isEmpty()) {
                this.setSelectedDeviceComponent(null, false);
            }
            this.showPopupMenu(x, y);
            return;
        }
    }

    public void removeSelectedElements() throws StudioException {
        Object old;
        Iterator i = this.selectedDeviceComps.iterator();
        while (i.hasNext()) {
            old = (DeviceComponent)i.next();
            Device dev = ((DeviceComponent)old).getDevice();
            if (dev != null) {
                int connCount = 0;
                Connection[] conns = dev.getConnections();
                if (conns != null) {
                    connCount += conns.length;
                }
                if ((conns = dev.getInvalidConnections()) != null) {
                    connCount += conns.length;
                }
                if (connCount > 0 && !this.promptRemoveConnectedDevice(dev)) {
                    return;
                }
                this.studio.removeDevice(dev);
            }
            ((DeviceComponent)old).setSelected(false);
            i.remove();
        }
        i = this.selectedConnectionLines.iterator();
        while (i.hasNext()) {
            old = (ConnectionLine)i.next();
            Connection conn = ((ConnectionLine)old).getConnection();
            if (conn != null) {
                this.studio.disconnect(conn);
            }
            ((ConnectionLine)old).setSelected(false);
            i.remove();
        }
    }

    protected boolean promptRemoveConnectedDevice(Device device) {
        String message = "Are you sure to remove the selected device and connection(s) ?";
        String title = "Remove connected device ?";
        int optionType = 2;
        int messageType = 3;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
        return rc == 0;
    }

    public Connection connectNextPorts() throws StudioException {
        if (this.selectedConnectionLines.size() != 1) {
            return null;
        }
        ConnectionLine line = (ConnectionLine)this.selectedConnectionLines.get(0);
        Connection conn = line.getConnection();
        if (conn == null) {
            return null;
        }
        Port sourcePort = conn.getSource();
        Port targetPort = conn.getTarget();
        if (sourcePort == null || targetPort == null) {
            return null;
        }
        PortType sourcePortType = sourcePort.getType();
        PortType targetPortType = targetPort.getType();
        if (sourcePortType == null || targetPortType == null) {
            return null;
        }
        Device sourceDevice = sourcePort.getDevice();
        Device targetDevice = targetPort.getDevice();
        if (sourceDevice == null || targetDevice == null) {
            return null;
        }
        int sourcePortIndex = -1;
        Port[] sourcePorts = sourceDevice.getPorts();
        for (int i = 0; i < sourcePorts.length; ++i) {
            if (sourcePorts[i] != sourcePort) continue;
            sourcePortIndex = i;
            break;
        }
        if (sourcePortIndex < 0 || sourcePortIndex + 1 >= sourcePorts.length) {
            return null;
        }
        int targetPortIndex = -1;
        Port[] targetPorts = targetDevice.getPorts();
        for (int i = 0; i < targetPorts.length; ++i) {
            if (targetPorts[i] != targetPort) continue;
            targetPortIndex = i;
            break;
        }
        if (targetPortIndex < 0 || targetPortIndex + 1 >= targetPorts.length) {
            return null;
        }
        Port nextSource = sourcePorts[sourcePortIndex + 1];
        Port nextTarget = targetPorts[targetPortIndex + 1];
        PortType nextSourceType = nextSource.getType();
        PortType nextTargetType = nextTarget.getType();
        if (nextSourceType == null || nextTargetType == null) {
            return null;
        }
        if (!nextSource.isConnectable(nextTarget)) {
            return null;
        }
        if (!nextTarget.isConnectable(nextSource)) {
            return null;
        }
        Connection nextConn = this.studio.connect(nextSource, nextTarget);
        this.setSelectedConnectionLater(nextConn);
        return nextConn;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected Rectangle computePreferredDeviceBounds(DeviceComponent comp) {
        Dimension prefSize = comp.getPreferredSize();
        Rectangle bounds = new Rectangle(prefSize);
        Device dev = comp.getDevice();
        Point pos = null;
        Object layoutConstraint = null;
        if (dev != null) {
            pos = dev.getPosition();
            layoutConstraint = dev.getPreferredLayoutConstraint();
        }
        if (layoutConstraint == null) {
            layoutConstraint = "Center";
        }
        if (pos != null) {
            bounds.x = pos.x;
            bounds.y = pos.y;
            if (bounds.x < 0) {
                bounds.x = 0;
            }
            if (bounds.y < 0) {
                bounds.y = 0;
            }
        }
        return bounds;
    }

    protected void showPopupMenu(int x, int y) {
        if (!this.selectedDeviceComps.isEmpty()) {
            if (this.devicePopupMenu != null) {
                this.devicePopupMenu.show(this, x, y);
            }
            return;
        }
        if (!this.selectedConnectionLines.isEmpty()) {
            if (this.connectionPopupMenu != null) {
                this.connectionPopupMenu.show(this, x, y);
            }
            return;
        }
        if (this.studioPopupMenu != null) {
            this.prefDeviceLocation.x = x;
            this.prefDeviceLocation.y = y;
            this.studioPopupMenu.show(this, x, y);
            return;
        }
    }

    public void showAddDevicePopupMenu(Component parent) throws StudioException {
        int y;
        int x;
        if (this.addDevicePopupMenu == null) {
            return;
        }
        if (parent == null) {
            parent = this;
            x = this.getWidth() / 2;
            y = this.getHeight() / 2;
        } else {
            x = 0;
            y = parent.getHeight();
        }
        this.addDevicePopupMenu.show(parent, x, y);
    }

    public void showSelectedDeviceSettings() {
        if (this.selectedDeviceComps.size() != 1) {
            return;
        }
        DeviceComponent comp = (DeviceComponent)this.selectedDeviceComps.get(0);
        Device dev = comp.getDevice();
        if (this.deviceSettingsDialog == null) {
            Window owner = SwingUtilities.getWindowAncestor(this);
            this.deviceSettingsDialog = this.createDialog(owner);
            this.deviceSettingsDialog.setTitle("Device Settings");
            this.deviceSettingsDialog.setContentPane(this.deviceSettingsPanel);
            this.deviceSettingsDialog.setModal(false);
            this.deviceSettingsDialog.pack();
            Tools.centerWindow((Component)this, (Window)this.deviceSettingsDialog);
        }
        this.deviceSettingsPanel.setDevice(dev);
        Tools.ensureWindowFitsScreen((Window)this.deviceSettingsDialog);
        this.deviceSettingsDialog.setVisible(true);
        this.deviceSettingsDialog.toFront();
        this.deviceSettingsDialog.requestFocus();
    }

    public void hideDeviceSettingsDialog() {
        this.deviceSettingsPanel.setDevice(null);
        if (this.deviceSettingsDialog != null) {
            this.deviceSettingsDialog.setVisible(false);
        }
    }

    private JDialog createDialog(Window owner) {
        if (owner != null && owner instanceof Frame) {
            Frame frame = (Frame)owner;
            return new JDialog(frame);
        }
        return new JDialog();
    }

    public JPopupMenu getStudioPopupMenu() {
        return this.studioPopupMenu;
    }

    public void setStudioPopupMenu(JPopupMenu studioPopupMenu) {
        this.studioPopupMenu = studioPopupMenu;
    }

    public JPopupMenu getDevicePopupMenu() {
        return this.devicePopupMenu;
    }

    public void setDevicePopupMenu(JPopupMenu devicePopupMenu) {
        this.devicePopupMenu = devicePopupMenu;
    }

    public JPopupMenu getConnectionPopupMenu() {
        return this.connectionPopupMenu;
    }

    public void setConnectionPopupMenu(JPopupMenu connectionPopupMenu) {
        this.connectionPopupMenu = connectionPopupMenu;
    }

    public boolean isStudioStarted() {
        return this.studioStarted;
    }

    protected void setStudioStarted(boolean studioStarted) {
        if (this.studioStarted != studioStarted) {
            this.studioStarted = studioStarted;
            this.firePropertyChange("studioStarted", !studioStarted, studioStarted);
        }
    }

    public boolean isStudioStopped() {
        return this.studioStopped;
    }

    protected void setStudioStopped(boolean studioStopped) {
        if (this.studioStopped != studioStopped) {
            this.studioStopped = studioStopped;
            this.firePropertyChange("studioStopped", !studioStopped, studioStopped);
        }
    }

    private boolean compareProperties(Properties aProps, Properties bProps) {
        HashMap bMap;
        boolean fine = logger.isLoggable(Level.FINE);
        HashMap<Object, Object> hashMap = bMap = bProps == null ? new HashMap() : new HashMap<Object, Object>(bProps);
        if (aProps != null) {
            for (Map.Entry<Object, Object> me : aProps.entrySet()) {
                Object key = me.getKey();
                Object aVal = me.getValue();
                Object bVal = bMap.remove(key);
                if (aVal == null) {
                    if (bVal == null) continue;
                    if (fine) {
                        logger.fine("Device property is dirty: " + key + " = " + aVal + " != " + bVal);
                    }
                    return false;
                }
                if (bVal == null) {
                    if (fine) {
                        logger.fine("Device property is dirty: " + key + " = " + aVal + " != " + bVal);
                    }
                    return false;
                }
                if (aVal.equals(bVal)) continue;
                if (fine) {
                    logger.fine("Device property is dirty: " + key + " = " + aVal + " != " + bVal);
                }
                return false;
            }
        }
        if (!bMap.isEmpty()) {
            if (fine) {
                logger.fine("Device properties are dirty: " + bMap);
            }
            return false;
        }
        return true;
    }

    private boolean compareControls(Map aControlMap, Control[] bControls) {
        boolean fine = logger.isLoggable(Level.FINE);
        HashMap<String, Object> bMap = new HashMap<String, Object>();
        if (bControls != null) {
            for (int i = 0; i < bControls.length; ++i) {
                Control control = bControls[i];
                if (control == null) continue;
                bMap.put(control.getName(), control.getValue());
            }
        }
        if (aControlMap != null) {
            for (Map.Entry me : aControlMap.entrySet()) {
                Object key = me.getKey();
                Object aVal = me.getValue();
                Object bVal = bMap.remove(key);
                if (aVal == null) {
                    if (bVal == null) continue;
                    if (fine) {
                        logger.fine("Device control is dirty: " + key + " = " + aVal + " != " + bVal);
                    }
                    return false;
                }
                if (bVal == null) {
                    if (fine) {
                        logger.fine("Device control is dirty: " + key + " = " + aVal + " != " + bVal);
                    }
                    return false;
                }
                if (aVal.equals(bVal)) continue;
                if (fine) {
                    logger.fine("Device control is dirty: " + key + " = " + aVal + " != " + bVal);
                }
                return false;
            }
        }
        if (!bMap.isEmpty()) {
            if (fine) {
                logger.fine("Device controls are dirty: " + bMap);
            }
            return false;
        }
        return true;
    }

    private boolean compareLayoutPanel(LayoutPanel aInfo, LayoutPanel bInfo) {
        if (aInfo == null) {
            return bInfo == null;
        }
        return aInfo.equals((Object)bInfo);
    }

    public boolean isDirty() throws Exception {
        if (this.dirty) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Routing panel is dirty: " + this);
            }
            return true;
        }
        for (DeviceComponent devComp : this.deviceMap.values()) {
            Editor editor;
            LayoutPanel newLayoutPanel;
            DeviceCustomizerView customView;
            Device device = devComp.getDevice();
            if (device != null) {
                Control[] newDevControls;
                Properties newDevProps;
                Properties oldDevProps = devComp.getOldDeviceProperties();
                if (!this.compareProperties(oldDevProps, newDevProps = device.getProperties())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Device properties are dirty: " + device);
                    }
                    return true;
                }
                Map oldDevControls = devComp.getOldDeviceControls();
                if (!this.compareControls(oldDevControls, newDevControls = device.getControls())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Device controls are dirty: " + device);
                    }
                    return true;
                }
            }
            if ((customView = devComp.getDeviceCustomizerView()) == null) continue;
            LayoutPanel oldLayoutPanel = devComp.getOldDeviceLayoutPanel();
            if (!this.compareLayoutPanel(oldLayoutPanel, newLayoutPanel = customView.createLayoutPanel())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Device layout is dirty: " + device);
                }
                return true;
            }
            Component comp = customView.getCustomizer();
            if (comp == null || !(comp instanceof Editor) || !(editor = (Editor)comp).isDirty()) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Device-Customizer is dirty: " + editor);
            }
            return true;
        }
        return false;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected void clearDirtyFlags() {
        for (DeviceComponent devComp : this.deviceMap.values()) {
            Device device = devComp.getDevice();
            if (device == null) continue;
            Properties devProps = device.getProperties();
            devComp.setOldDeviceProperties(devProps);
            Control[] devControls = device.getControls();
            HashMap<String, Object> devControlMap = new HashMap<String, Object>();
            for (int k = 0; k < devControls.length; ++k) {
                Control control = devControls[k];
                if (control == null) continue;
                devControlMap.put(control.getName(), control.getValue());
            }
            devComp.setOldDeviceControls(devControlMap);
            LayoutPanel layoutPanel = null;
            DeviceCustomizerView customizerView = devComp.getDeviceCustomizerView();
            if (customizerView != null) {
                layoutPanel = customizerView.createLayoutPanel();
            }
            devComp.setOldDeviceLayoutPanel(layoutPanel);
        }
        this.setDirty(false);
    }

    public void saveStudioViewSettings() throws Exception {
        DefaultPerspective dp;
        View contentView;
        Perspective pers;
        if (this.studio == null) {
            return;
        }
        if (this.studioView != null && (pers = this.studioView.getPerspective()) != null && pers instanceof DefaultPerspective && (contentView = (dp = (DefaultPerspective)pers).getContentView()) != null && contentView instanceof DesktopView) {
            DesktopView desk = (DesktopView)contentView;
            this.studio.setViewBounds(desk.getViewBounds((View)this.studioView));
        }
    }

    public DeviceCustomizerView[] getDeviceCustomizerViews() {
        LinkedList<DeviceCustomizerView> list = new LinkedList<DeviceCustomizerView>();
        for (DeviceComponent devComp : this.deviceMap.values()) {
            DeviceCustomizerView customView = devComp.getDeviceCustomizerView();
            if (customView == null) continue;
            list.add(customView);
        }
        return list.toArray(new DeviceCustomizerView[list.size()]);
    }

    protected RuntimeContext getRuntimeContext() {
        Workbench wb;
        StudioView view;
        if (this.runtimeContext == null && (view = this.getStudioView()) != null && (wb = view.getWorkbench()) != null) {
            this.runtimeContext = wb.getRuntimeContext();
        }
        return this.runtimeContext;
    }

    public Point getPreferredDeviceLocation() {
        return this.prefDeviceLocation;
    }

    public Paint getDeviceBackgroundPaint() {
        return this.deviceBackgroundPaint;
    }

    public void setDeviceBackgroundPaint(Paint deviceBackgroundPaint) {
        this.deviceBackgroundPaint = deviceBackgroundPaint;
    }

    public Paint getSelectedDeviceBackgroundPaint() {
        return this.selectedDeviceBackgroundPaint;
    }

    public void setSelectedDeviceBackgroundPaint(Paint selectedDeviceBackgroundPaint) {
        this.selectedDeviceBackgroundPaint = selectedDeviceBackgroundPaint;
    }

    public Paint getDisabledDeviceBackgroundPaint() {
        return this.disabledDeviceBackgroundPaint;
    }

    public void setDisabledDeviceBackgroundPaint(Paint disabledDeviceBackgroundPaint) {
        this.disabledDeviceBackgroundPaint = disabledDeviceBackgroundPaint;
    }

    public Stroke getDeviceOutlineStroke() {
        return this.deviceOutlineStroke;
    }

    public void setDeviceOutlineStroke(Stroke deviceOutlineStroke) {
        this.deviceOutlineStroke = deviceOutlineStroke;
    }

    public Stroke getSelectedDeviceOutlineStroke() {
        return this.selectedDeviceOutlineStroke;
    }

    public void setSelectedDeviceOutlineStroke(Stroke selectedDeviceOutlineStroke) {
        this.selectedDeviceOutlineStroke = selectedDeviceOutlineStroke;
    }

    public StudioView getStudioView() {
        return this.studioView;
    }

    protected void setStudioView(StudioView studioView) {
        this.studioView = studioView;
    }

    public LineStyle getInvalidConnectionLineStyle() {
        return this.invalidConnectionLineStyle;
    }

    public void setInvalidConnectionLineStyle(LineStyle invalidConnectionLineStyle) {
        this.invalidConnectionLineStyle = invalidConnectionLineStyle;
    }

    public JPopupMenu getAddDevicePopupMenu() {
        return this.addDevicePopupMenu;
    }

    public void setAddDevicePopupMenu(JPopupMenu addDevicePopupMenu) {
        this.addDevicePopupMenu = addDevicePopupMenu;
    }

    public Cursor getConnectCursor() {
        return this.connectCursor;
    }

    public void setConnectCursor(Cursor connectCursor) {
        this.connectCursor = connectCursor;
    }

    public Cursor getDeviceCursor() {
        return this.deviceCursor;
    }

    public void setDeviceCursor(Cursor deviceCursor) {
        this.deviceCursor = deviceCursor;
    }

    public void enableSelectedDevice() throws StudioException {
        for (DeviceComponent comp : this.selectedDeviceComps) {
            Device dev = comp.getDevice();
            if (dev == null || dev.isEnabled()) continue;
            this.studio.enableDevice(dev);
        }
    }

    public void disableSelectedDevice() throws StudioException {
        for (DeviceComponent comp : this.selectedDeviceComps) {
            Device dev = comp.getDevice();
            if (dev == null || !dev.isEnabled()) continue;
            this.studio.disableDevice(dev);
        }
    }

    public void toggleEnableDisableSelectedDevice() throws StudioException {
        for (DeviceComponent comp : this.selectedDeviceComps) {
            Device dev = comp.getDevice();
            if (dev == null) continue;
            if (dev.isEnabled()) {
                this.studio.disableDevice(dev);
                continue;
            }
            this.studio.enableDevice(dev);
        }
    }

    public void disconnectSelectedDevice() throws StudioException {
        for (DeviceComponent comp : this.selectedDeviceComps) {
            Device dev = comp.getDevice();
            if (dev == null) continue;
            int connCount = 0;
            Connection[] conns = dev.getConnections();
            if (conns != null) {
                connCount += conns.length;
            }
            if ((conns = dev.getInvalidConnections()) != null) {
                connCount += conns.length;
            }
            if (connCount > 0 && !this.promptDisconnectDevice(dev)) {
                return;
            }
            this.studio.disconnect(dev);
        }
    }

    protected boolean promptDisconnectDevice(Device device) {
        String message = "Are you sure to disconnect the selected device ?";
        String title = "Disconnect device ?";
        int optionType = 2;
        int messageType = 3;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
        return rc == 0;
    }

    public synchronized void saveDeviceCustomizers() throws Exception {
        for (DeviceComponent devComp : this.deviceMap.values()) {
            Component comp;
            DeviceCustomizerView customView;
            Device device = devComp.getDevice();
            if (device == null || (customView = devComp.getDeviceCustomizerView()) == null || (comp = customView.getCustomizer()) == null || !(comp instanceof Editor)) continue;
            Editor editor = (Editor)comp;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Saving Device-Customizer: " + editor);
            }
            editor.save();
        }
    }

    public synchronized void snapshotDeviceCustomizerViews() throws Exception {
        if (this.ignoreSnapshots) {
            return;
        }
        for (DeviceComponent devComp : this.deviceMap.values()) {
            DeviceCustomizerView customView;
            Device device = devComp.getDevice();
            if (device == null || (customView = devComp.getDeviceCustomizerView()) == null) continue;
            boolean closing = false;
            this.snapshotDeviceCustomizerView(customView, closing);
        }
    }

    public void snapshotDeviceCustomizerView(DeviceCustomizerView view, boolean closing) {
        LayoutPanel oldLayoutPanel;
        if (this.ignoreSnapshots) {
            return;
        }
        Layout layout = this.currentLayout;
        if (layout == null) {
            return;
        }
        Device device = view.getDevice();
        if (device == null) {
            return;
        }
        LayoutPanel newLayoutPanel = view.createLayoutPanel();
        if (newLayoutPanel == null) {
            return;
        }
        if (closing) {
            newLayoutPanel.setEditorVisible(false);
        }
        if ((oldLayoutPanel = layout.getPanelForDevice(device)) != null) {
            if (newLayoutPanel.equals((Object)oldLayoutPanel)) {
                return;
            }
            if (!oldLayoutPanel.isEditorVisible() && !newLayoutPanel.isEditorVisible()) {
                return;
            }
            layout.removePanel(oldLayoutPanel);
        }
        layout.addPanel(newLayoutPanel);
    }

    public boolean showSelectedDeviceView() throws StudioException {
        if (this.selectedDeviceComps.size() != 1) {
            return false;
        }
        DeviceComponent comp = (DeviceComponent)this.selectedDeviceComps.get(0);
        Device device = comp.getDevice();
        if (device == null || this.studio == null) {
            return false;
        }
        boolean deiconify = true;
        if (this.showDeviceCustomizer(device, deiconify)) {
            return true;
        }
        this.handleDeviceCustomizerUnavailable(device);
        return false;
    }

    public boolean showDeviceCustomizer(Device device, boolean deiconify) {
        if (device == null) {
            return false;
        }
        DeviceComponent devComp = (DeviceComponent)this.deviceMap.get(device);
        if (devComp == null) {
            return false;
        }
        if (this.studio == null) {
            return false;
        }
        Layout layout = this.studio.getLayout();
        if (layout == null) {
            return false;
        }
        LayoutPanel panel = layout.getPanelForDevice(device);
        if (panel == null) {
            panel = new LayoutPanel(device);
            layout.addPanel(panel);
        }
        if (deiconify) {
            panel.setEditorIconified(false);
        }
        panel.setEditorVisible(true);
        return this.refreshDeviceCustomizer(device, devComp, false);
    }

    public boolean refreshDeviceCustomizer(Device device) {
        DeviceComponent devComp = (DeviceComponent)this.deviceMap.get(device);
        if (devComp == null) {
            return false;
        }
        return this.refreshDeviceCustomizer(device, devComp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshDeviceCustomizer(Device device, DeviceComponent devComp, boolean refreshLayout) {
        if (device == null) {
            return false;
        }
        if (devComp == null) {
            return false;
        }
        Component customizer = null;
        try {
            customizer = device.getCustomizer();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        DeviceCustomizerView deviceView = devComp.getDeviceCustomizerView();
        Workbench wb = WorkbenchUtilities.getWorkbench((Component)this);
        if (wb == null) {
            return false;
        }
        Perspective perspective = wb.getPerspective();
        if (perspective == null) {
            return false;
        }
        if (this.studio == null) {
            return false;
        }
        Layout layout = this.studio.getLayout();
        if (layout == null) {
            return false;
        }
        try {
            this.ignoreSnapshots = true;
            LayoutPanel panel = layout.getPanelForDevice(device);
            if (panel == null || !panel.isEditorVisible() || customizer == null) {
                if (deviceView != null) {
                    perspective.removeView((View)deviceView);
                }
                boolean bl = true;
                return bl;
            }
            Rectangle editorBounds = panel.getEditorBounds();
            if (deviceView == null) {
                deviceView = new DeviceCustomizerView(this.studioView, device);
                devComp.setDeviceCustomizerView(deviceView);
            } else if (refreshLayout) {
                perspective.removeView((View)deviceView);
            }
            String title = device.getTitle();
            if ((title == null || title.trim().length() < 1) && (title = device.getName()) == null) {
                title = device.toString();
            }
            deviceView.setTitle(title);
            deviceView.setTooltip(device.getTooltip());
            deviceView.setIcon(device.getIcon(1));
            deviceView.setCustomizer(customizer);
            ViewConstraints constr = deviceView.getViewConstraints();
            if (constr == null) {
                constr = new ViewConstraints();
            }
            constr.setBounds(editorBounds);
            constr.setMinimized(panel.isEditorIconified());
            constr.setDetached(panel.isEditorDetached());
            constr.setDetachedBounds(panel.getEditorDetachedBounds());
            deviceView.setViewConstraints(constr);
            perspective.addView((View)deviceView);
            perspective.toFront((View)deviceView);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ignoreSnapshots = false;
        }
    }

    public void refreshAllDeviceCustomizers() {
        int i;
        if (this.studio == null) {
            return;
        }
        Layout layout = this.studio.getLayout();
        if (layout != null) {
            int num = layout.getPanelCount();
            for (i = 0; i < num; ++i) {
                Device device;
                LayoutPanel panel = layout.getPanelAt(i);
                if (panel == null || (device = panel.getDevice()) == null) continue;
                try {
                    this.refreshDeviceCustomizer(device);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        Device[] devices = this.studio.getDevices();
        for (i = 0; i < devices.length; ++i) {
            Device device = devices[i];
            if (device == null || layout != null && layout.getPanelForDevice(device) != null) continue;
            try {
                this.refreshDeviceCustomizer(device);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void setDeviceCustomizerViewBounds(DeviceCustomizerView deviceView, Rectangle viewBounds) {
        DefaultPerspective dp;
        View contentView;
        Perspective perspective = deviceView.getPerspective();
        if (perspective != null && perspective instanceof DefaultPerspective && (contentView = (dp = (DefaultPerspective)perspective).getContentView()) != null && contentView instanceof DesktopView) {
            DesktopView desk = (DesktopView)contentView;
            desk.setViewBounds((View)deviceView, viewBounds);
        }
    }

    public void closeAllDeviceCustomizers() {
        DeviceCustomizerView[] dcvs = this.getDeviceCustomizerViews();
        for (int i = 0; i < dcvs.length; ++i) {
            dcvs[i].close();
        }
    }

    protected void handleLayoutChanged(Layout layout) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Layout newLayout;
                    Layout layout = newLayout = RoutingPanel.this.studio == null ? null : RoutingPanel.this.studio.getLayout();
                    if (RoutingPanel.this.currentLayout != null) {
                        RoutingPanel.this.snapshotDeviceCustomizerViews();
                    }
                    RoutingPanel.this.currentLayout = newLayout;
                    RoutingPanel.this.refreshLayoutMenu();
                    RoutingPanel.this.refreshAllDeviceCustomizers();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        });
    }

    protected void handleLayoutsChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RoutingPanel.this.refreshLayoutMenu();
            }
        });
    }

    protected void refreshLayoutMenu() {
        try {
            StudioPlugin.getInstance().refreshDeviceLayoutMenu();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            super.keyPressed(ev);
            try {
                switch (ev.getKeyCode()) {
                    case 78: {
                        RoutingPanel.this.connectNextPorts();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                ev.consume();
            }
            catch (Exception e) {
                RoutingPanel.this.handleException(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent ev) {
            super.keyTyped(ev);
            try {
                switch (ev.getKeyChar()) {
                    case '\u007f': {
                        RoutingPanel.this.removeSelectedElements();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                ev.consume();
            }
            catch (Exception e) {
                RoutingPanel.this.handleException(e);
            }
        }
    }

    protected class DeviceFocusHandler
    extends FocusAdapter {
        protected DeviceFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            Component comp = e.getComponent();
            if (comp != null && comp instanceof DeviceComponent) {
                DeviceComponent devComp = (DeviceComponent)comp;
                if (!RoutingPanel.this.selectedDeviceComps.contains(devComp)) {
                    RoutingPanel.this.setSelectedDeviceComponent(devComp, false);
                }
            }
        }
    }

    protected class DeviceMouseMotionHandler
    extends MouseMotionAdapter {
        protected DeviceMouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            Component comp = e.getComponent();
            int x = comp.getX() + e.getX();
            int y = comp.getY() + e.getY();
            RoutingPanel.this.handleMouseDragged(x, y);
        }
    }

    protected class DeviceMouseHandler
    extends MouseAdapter {
        protected DeviceMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            Component comp = e.getComponent();
            int x = comp.getX() + e.getX();
            int y = comp.getY() + e.getY();
            RoutingPanel.this.handleMousePressed(x, y, e.isPopupTrigger());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            Component comp = e.getComponent();
            int x = comp.getX() + e.getX();
            int y = comp.getY() + e.getY();
            RoutingPanel.this.handleMouseClicked(x, y, e.getClickCount());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            Component comp = e.getComponent();
            int x = comp.getX() + e.getX();
            int y = comp.getY() + e.getY();
            RoutingPanel.this.handleMouseReleased(x, y, e.isPopupTrigger());
        }
    }

    protected class MouseMotionHandler
    extends MouseMotionAdapter {
        protected MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            RoutingPanel.this.handleMouseDragged(e.getX(), e.getY());
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            RoutingPanel.this.handleMousePressed(e.getX(), e.getY(), e.isPopupTrigger());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            RoutingPanel.this.handleMouseClicked(e.getX(), e.getY(), e.getClickCount());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            RoutingPanel.this.handleMouseReleased(e.getX(), e.getY(), e.isPopupTrigger());
        }
    }

    protected class SettingsRefresher
    implements Runnable {
        protected SettingsRefresher() {
        }

        @Override
        public void run() {
            RoutingPanel.this.deviceSettingsPanel.refresh();
        }
    }

    protected class Refresher
    implements Runnable {
        protected Refresher() {
        }

        @Override
        public void run() {
            RoutingPanel.this.refresh();
        }
    }

    protected class StudioHandler
    implements StudioListener {
        protected StudioHandler() {
        }

        public void studioStateChanged(int state) {
            RoutingPanel.this.refreshLater();
        }

        public void errorReported(Device device, LogRecord error) {
            RoutingPanel.this.refreshLater();
        }

        public void errorResolved(Device device, LogRecord error) {
            RoutingPanel.this.refreshLater();
        }

        public void layoutChanged(Layout layout) {
            RoutingPanel.this.handleLayoutChanged(layout);
        }

        public void layoutsChanged() {
            RoutingPanel.this.handleLayoutsChanged();
        }

        public void deviceAdded(Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void deviceRemoved(Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void deviceRenamed(Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void deviceTitleChanged(Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void deviceEnabled(Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void deviceDisabled(Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void portAdded(Port port, Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void portRemoved(Port port, Device device) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void portRenamed(Port port) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void connectionAdded(Connection cable) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void connectionRemoved(Connection cable) {
            RoutingPanel.this.setDirty(true);
            RoutingPanel.this.refreshLater();
        }

        public void controlAdded(Control control, int index, Device device) {
            if (RoutingPanel.this.deviceSettingsDialog != null && RoutingPanel.this.deviceSettingsDialog.isVisible() && RoutingPanel.this.deviceSettingsPanel.getDevice() == device) {
                SwingUtilities.invokeLater(RoutingPanel.this.settingsRefresher);
            }
        }

        public void controlRemoved(Control control, int index, Device device) {
            if (RoutingPanel.this.deviceSettingsDialog != null && RoutingPanel.this.deviceSettingsDialog.isVisible() && RoutingPanel.this.deviceSettingsPanel.getDevice() == device) {
                SwingUtilities.invokeLater(RoutingPanel.this.settingsRefresher);
            }
        }
    }
}

