/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.workbench.DefaultPerspective;
import com.spacekiller.util.workbench.DesktopView;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.impl.DefaultStudio;
import com.waxmonster.studio.view.RoutingPanel;
import com.waxmonster.studio.view.StudioPanel;
import com.waxmonster.studio.view.StudioView;
import java.awt.Rectangle;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class StudioLoader
extends AbstractExecution {
    private static final Logger logger = Logger.getLogger(StudioLoader.class.getName());
    private final StudioPanel studioPanel;
    private final Studio studio;
    private final File file;
    private final boolean autoStartStudio;

    public StudioLoader(String name, String descr, StudioPanel studioPanel, Studio studio, File file, boolean autoStartStudio) {
        super(name, descr);
        this.studioPanel = studioPanel;
        this.studio = studio;
        this.file = file;
        this.autoStartStudio = autoStartStudio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            RoutingPanel rp;
            boolean studioWasEmpty = true;
            if (this.studio.getDevices().length > 0) {
                studioWasEmpty = false;
            }
            boolean wasDirty = (rp = this.studioPanel.getRoutingPanel()) == null ? true : rp.isDirty();
            DefaultStudio defStudio = null;
            if (this.studio instanceof DefaultStudio) {
                defStudio = (DefaultStudio)this.studio;
            }
            if (defStudio == null) {
                throw new StudioException("Studio not available!");
            }
            if (this.file != null) {
                try {
                    File dir = this.file.getParentFile();
                    defStudio.setDirectory(dir);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Loading studio file: " + this.file);
                        logger.fine("Context: " + Thread.currentThread().getContextClassLoader());
                    }
                    Runnable postStudioSettingsHook = new Runnable(){

                        @Override
                        public void run() {
                            StudioLoader.this.afterStudioSettings();
                        }
                    };
                    defStudio.load(this.file, postStudioSettingsHook);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Loaded studio file: " + this.file);
                    }
                    if (studioWasEmpty) {
                        File curr = dir.getParentFile();
                        if (curr != null) {
                            this.studioPanel.setCurrentDirectory(curr);
                        }
                        this.studioPanel.setProjectDirectory(dir);
                        this.studioPanel.setStudioFile(this.file);
                    }
                }
                catch (Throwable e) {
                    this.handleException(e);
                }
            }
            final boolean cleanDirtyFlags = !wasDirty;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StudioLoader.this.afterProjectLoad(cleanDirtyFlags);
                }
            });
        }
        finally {
            this.setProgress(1.0);
        }
    }

    protected void afterStudioSettings() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StudioLoader.this.restoreStudioBounds();
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void afterProjectLoad(boolean cleanDirtyFlags) {
        RoutingPanel rp;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("afterProjectLoad: studioPanel=" + this.studioPanel);
        }
        if ((rp = this.studioPanel.getRoutingPanel()) == null) {
            return;
        }
        this.restoreStudioBounds();
        if (cleanDirtyFlags) {
            rp.clearDirtyFlags();
        }
        if (this.autoStartStudio) {
            this.autoStartStudio();
        }
    }

    protected void restoreStudioBounds() {
        RoutingPanel rp = this.studioPanel.getRoutingPanel();
        if (rp == null) {
            return;
        }
        StudioView studioView = rp.getStudioView();
        if (studioView != null) {
            DefaultPerspective dp;
            View contentView;
            Workbench wb;
            Perspective pers = studioView.getPerspective();
            if (pers == null && (wb = studioView.getStudioWorkbench()) != null && (pers = wb.getPerspective()) != null) {
                pers.addView((View)studioView);
            }
            if (pers != null && pers instanceof DefaultPerspective && (contentView = (dp = (DefaultPerspective)pers).getContentView()) != null && contentView instanceof DesktopView) {
                DesktopView desk = (DesktopView)contentView;
                Rectangle viewBounds = this.studio.getViewBounds();
                if (viewBounds == null) {
                    return;
                }
                desk.setViewBounds((View)studioView, viewBounds);
            }
        }
    }

    protected void autoStartStudio() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Auto-starting studio...");
        }
        if (this.studioPanel != null) {
            try {
                this.studioPanel.startStudio();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

