/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.impl.DefaultStudio;
import com.waxmonster.studio.impl.StudioXmlUtil;
import com.waxmonster.studio.impl.StudioZipUtil;
import com.waxmonster.studio.view.DeviceLayoutManagerPanel;
import com.waxmonster.studio.view.RoutingPanel;
import com.waxmonster.studio.view.StudioLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class StudioPanel
extends JPanel {
    private static final long serialVersionUID = 4094221211019121100L;
    private static final Logger logger = Logger.getLogger(StudioPanel.class.getName());
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private JPanel toolbarPanel;
    private JScrollPane scrollPane;
    private RoutingPanel routingPanel;
    private JToolBar toolBar;
    private JPopupMenu studioPopupMenu;
    private File currentDirectory;
    private File projectDirectory;
    private File studioFile;

    public StudioPanel() {
        this.initStudioPanel();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(JToolBar toolBar) {
        this.toolBar = toolBar;
        this.toolbarPanel.removeAll();
        if (toolBar != null) {
            this.toolbarPanel.add(toolBar);
        }
        this.toolbarPanel.validate();
        this.toolbarPanel.repaint();
    }

    public RoutingPanel getRoutingPanel() {
        return this.routingPanel;
    }

    public void setRoutingPanel(RoutingPanel routingPanel) {
        this.routingPanel = routingPanel;
        routingPanel.setParentComponent(this.scrollPane);
        this.scrollPane.setViewportView(routingPanel);
    }

    protected void initStudioPanel() {
        this.setLayout(new BorderLayout());
        this.toolbarPanel = new JPanel();
        this.toolbarPanel.setOpaque(true);
        this.toolbarPanel.setLayout(new GridLayout(1, 1));
        this.add((Component)this.toolbarPanel, "North");
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.getRoutingPanel();
        try {
            this.currentDirectory = Platform.getInstance().getDataDir();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.setPreferredSize(new Dimension(700, 400));
        this.initActionMap();
        this.initInputMap();
    }

    protected void initActionMap() {
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("StartStudioAction", new StartStudioAction());
        actionMap.put("StopStudioAction", new StopStudioAction());
    }

    protected void initInputMap() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(49, 640), "StartStudioAction");
        inputMap.put(KeyStroke.getKeyStroke(48, 640), "StopStudioAction");
    }

    public Studio getStudio() {
        if (this.routingPanel == null) {
            return null;
        }
        return this.routingPanel.getStudio();
    }

    public JPopupMenu getStudioPopupMenu() {
        return this.studioPopupMenu;
    }

    public void setStudioPopupMenu(JPopupMenu studioPopupMenu) {
        this.studioPopupMenu = studioPopupMenu;
    }

    public void saveStudio() throws StudioException, IOException {
        File dir = this.projectDirectory;
        File file = this.studioFile;
        if (dir == null || file == null) {
            this.saveStudioAs();
        } else {
            try {
                this.saveStudioImpl(dir, file);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void saveStudioAs() throws StudioException, IOException {
        try {
            this.ensureStudioWindowVisible();
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogType(1);
            chooser.setDialogTitle("Save Studio Project");
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new StudioFileFilter());
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if (this.studioFile != null) {
                chooser.setSelectedFile(this.studioFile);
            } else if (this.projectDirectory != null) {
                chooser.setSelectedFile(this.projectDirectory);
            }
            int rc = chooser.showSaveDialog(this);
            if (rc != 0) {
                return;
            }
            File sel = chooser.getSelectedFile();
            if (sel == null) {
                return;
            }
            File file = null;
            File dir = null;
            if (sel.exists()) {
                boolean emptyDir = false;
                File existingFile = null;
                if (sel.isFile()) {
                    existingFile = sel;
                    file = sel;
                } else if (sel.isDirectory()) {
                    dir = sel;
                    file = new File(dir, "waxmonster.xml");
                    if (file != null && file.exists() && file.isFile()) {
                        existingFile = file;
                    } else {
                        File[] files = sel.listFiles();
                        int fileCount = files == null ? 0 : files.length;
                        boolean bl = emptyDir = fileCount < 1;
                    }
                }
                if (existingFile != null || !emptyDir) {
                    int optionType;
                    String message;
                    String title;
                    int messageType = 3;
                    if (existingFile != null) {
                        title = "Overwrite existing file ?";
                        message = "Target project file already exists: \n";
                        message = message + String.valueOf(existingFile);
                        message = message + "\n\n";
                        message = message + "Are you sure ?";
                        if (!"waxmonster.xml".equals(file.getName())) {
                            messageType = 2;
                            message = message + "\n\n";
                            message = message + "Warning: Unusual studio file name: " + file.getName();
                            message = message + "\n\n";
                            message = message + "Expected file name: waxmonster.xml";
                        }
                    } else {
                        title = "Directory already exists";
                        message = "Target project directory already exists and is not empty: \n";
                        message = message + String.valueOf(sel);
                        message = message + "\n\n";
                        message = message + "Are you sure ?";
                    }
                    if ((rc = JOptionPane.showConfirmDialog(this, message, title, optionType = 0, messageType)) != 0) {
                        return;
                    }
                }
            }
            if (dir == null) {
                dir = file == null ? sel : file.getParentFile();
            }
            if (file == null) {
                file = new File(dir, "waxmonster.xml");
            }
            this.currentDirectory = dir;
            this.saveStudioImpl(dir, file);
            boolean showConfirmMessage = true;
            if (showConfirmMessage) {
                int messageType = 1;
                String title = "Saved Studio Project";
                String message = "Studio project saved successfully:\n\n" + String.valueOf(file);
                JOptionPane.showMessageDialog(this, message, title, messageType);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStudioImpl(File targetDir, File targetFile) throws StudioException, IOException {
        DefaultStudio defStudio = null;
        Studio studio = this.getStudio();
        if (studio != null && studio instanceof DefaultStudio) {
            defStudio = (DefaultStudio)studio;
        }
        if (defStudio == null) {
            throw new StudioException("Studio not available!");
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        defStudio.setDirectory(targetDir);
        try {
            this.getRoutingPanel().saveDeviceCustomizers();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            this.getRoutingPanel().snapshotDeviceCustomizerViews();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            this.getRoutingPanel().saveStudioViewSettings();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving studio file: " + targetFile);
        }
        boolean backup = true;
        File backupFile = null;
        if (backup && targetFile.exists() && targetFile.isFile()) {
            backupFile = new File(targetFile.getPath() + ".bak");
            if (backupFile.exists() && !backupFile.delete()) {
                throw new IOException("Failed to delete old studio backup file: " + backupFile);
            }
            if (!targetFile.renameTo(backupFile)) {
                throw new IOException("Failed to rename old studio file: " + targetFile + " -> " + backupFile);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing studio config file: " + targetFile);
        }
        boolean success = false;
        try {
            defStudio.save(targetFile);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Studio file saved: " + targetFile);
            }
            this.projectDirectory = targetDir;
            this.studioFile = targetFile;
            try {
                this.getRoutingPanel().clearDirtyFlags();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            success = true;
        }
        finally {
            if (!success) {
                if (targetFile.delete()) {
                    if (backupFile != null) {
                        if (backupFile.renameTo(targetFile)) {
                            logger.info("Restored backup file: " + backupFile + " -> " + targetFile);
                        } else {
                            logger.warning("Failed to restore backup file: " + backupFile + " -> " + targetFile);
                        }
                    }
                } else {
                    logger.warning("Failed to delete corrupted file: " + targetFile);
                }
            }
        }
    }

    public static File showFileOpenDialog(Component parent, File currentDirectory, File currentFile) {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle("Open Studio Project");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new StudioFileFilter());
        if (currentDirectory == null) {
            try {
                currentDirectory = Platform.getInstance().getDataDir();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (currentDirectory != null) {
            chooser.setCurrentDirectory(currentDirectory);
        }
        if (currentFile != null) {
            chooser.setSelectedFile(currentFile);
        }
        if ((rc = chooser.showOpenDialog(parent)) != 0) {
            return null;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        if (!selectedFile.exists()) {
            int messageType = 2;
            String title = "File or Directory not found";
            String message = "File or directory does not exist:\n";
            message = message + String.valueOf(selectedFile);
            JOptionPane.showMessageDialog(parent, message, title, messageType);
            return null;
        }
        File studioFile = selectedFile;
        if (selectedFile.isDirectory()) {
            File file = new File(selectedFile, "waxmonster.xml");
            if (file.exists() && file.isFile()) {
                studioFile = file;
            } else {
                int messageType = 2;
                String title = "Invalid Studio Directory";
                String message = "Studio project file not found:\n";
                message = message + String.valueOf(file);
                JOptionPane.showMessageDialog(parent, message, title, messageType);
                return null;
            }
        }
        return studioFile;
    }

    public void openStudio() throws StudioException, IOException {
        Studio studio = this.getStudio();
        if (studio == null) {
            return;
        }
        File file = StudioPanel.showFileOpenDialog(this, this.currentDirectory, this.studioFile);
        if (file == null) {
            return;
        }
        this.currentDirectory = file.getParentFile();
        this.openStudio(file);
    }

    public void openStudio(File file) throws StudioException, IOException {
        boolean autoStartStudio = false;
        this.openStudio(file, autoStartStudio);
    }

    public void openStudio(File file, boolean autoStartStudio) throws StudioException, IOException {
        Studio studio = this.getStudio();
        if (studio == null) {
            return;
        }
        String title = "Loading studio";
        String descr = "Loading studio project";
        StudioLoader loader = new StudioLoader(title, descr, this, studio, file, autoStartStudio);
        ExecutionManager execManager = Platform.getInstance().getExecutionManager();
        if (execManager != null) {
            execManager.addExecution((Execution)loader);
        }
        loader.start();
    }

    public void exportStudio() throws StudioException, IOException {
        int rc;
        File projectDir = this.projectDirectory;
        if (projectDir == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setDialogTitle("Export Studio Project");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new ZipFileFilter());
        File proposedFile = new File(projectDir.getName() + ZIP_FILE_EXTENSION);
        chooser.setSelectedFile(proposedFile);
        if (this.currentDirectory == null) {
            try {
                this.currentDirectory = Platform.getInstance().getDataDir();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        if ((rc = chooser.showSaveDialog(this)) != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        File targetZipFile = selectedFile;
        if (selectedFile.exists()) {
            int messageType = 3;
            int optionType = 2;
            String title = "Overwrite ?";
            String message = "Target file already exists:\n\n";
            message = message + String.valueOf(targetZipFile);
            message = message + "\n\n";
            rc = JOptionPane.showConfirmDialog(this, message = message + "Are you sure ?", title, optionType, messageType);
            if (rc != 0) {
                return;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Export studio project: projectDir=" + projectDir + ", targetZipFile=" + targetZipFile);
        }
        try {
            StudioZipUtil zipUtil = new StudioZipUtil();
            zipUtil.exportStudioProjectToZipFile(projectDir, targetZipFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Studio project exported: " + targetZipFile);
        }
        int messageType = 1;
        String title = "Export Studio Project";
        String message = "Studio project exported successfully:\n\n";
        message = message + String.valueOf(targetZipFile);
        JOptionPane.showMessageDialog(this, message, title, messageType);
    }

    public void importStudio() throws StudioException, IOException {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setDialogTitle("Import Studio Project");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new ZipFileFilter());
        if (this.currentDirectory == null) {
            try {
                this.currentDirectory = Platform.getInstance().getDataDir();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        if ((rc = chooser.showOpenDialog(this)) != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        File sourceZipFile = selectedFile;
        URL studioZipURL = Tools.getFileURL((File)sourceZipFile);
        StudioZipUtil zipUtil = new StudioZipUtil();
        try {
            zipUtil.checkStudioProjectZipFile(sourceZipFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        this.importStudio(studioZipURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStudio(URL studioZipURL) throws StudioException, IOException {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setDialogTitle("Choose Target Directory");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new DirectoryFilter());
        if (studioZipURL != null) {
            String proposedName = studioZipURL.getFile();
            if (proposedName.toLowerCase().endsWith(ZIP_FILE_EXTENSION)) {
                proposedName = proposedName.substring(0, proposedName.length() - ZIP_FILE_EXTENSION.length());
            }
            File proposedDir = new File(proposedName);
            chooser.setSelectedFile(proposedDir);
        }
        if (this.currentDirectory == null) {
            try {
                this.currentDirectory = Platform.getInstance().getDataDir();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        if ((rc = chooser.showSaveDialog(this)) != 0) {
            return;
        }
        File targetDirectory = chooser.getSelectedFile();
        if (targetDirectory == null) {
            return;
        }
        if (targetDirectory.exists()) {
            int messageType = 0;
            String title = "Directory Already Exists";
            String message = "Target directory already exists:\n\n";
            message = message + String.valueOf(targetDirectory);
            message = message + "\n\n";
            message = message + "Please retry with a new target directory.";
            JOptionPane.showMessageDialog(this, message, title, messageType);
            return;
        }
        if (targetDirectory.exists()) {
            throw new IOException("Target directory already exists: " + targetDirectory);
        }
        if (!targetDirectory.mkdirs()) {
            throw new IOException("Failed to create target directory: " + targetDirectory);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Create studio project: " + targetDirectory);
        }
        if (studioZipURL != null) {
            InputStream inputStream = studioZipURL.openStream();
            try {
                StudioZipUtil zipUtil = new StudioZipUtil();
                zipUtil.importStudioProjectFromZipStream(inputStream, targetDirectory);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return;
            }
            finally {
                inputStream.close();
            }
        }
        try {
            File studioFile = new File(targetDirectory, "waxmonster.xml");
            if (!studioFile.exists()) {
                DefaultStudio defStudio = (DefaultStudio)this.getStudio();
                StudioXmlUtil xmlUtil = new StudioXmlUtil();
                xmlUtil.saveStudioConfig(defStudio, studioFile);
            }
            this.openStudio(studioFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Studio project created: " + targetDirectory);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public boolean showSelectedDeviceView() throws StudioException {
        return this.getRoutingPanel().showSelectedDeviceView();
    }

    public void showSelectedDeviceSettings() throws StudioException {
        this.getRoutingPanel().showSelectedDeviceSettings();
    }

    public void enableSelectedDevice() throws StudioException {
        this.getRoutingPanel().enableSelectedDevice();
    }

    public void disableSelectedDevice() throws StudioException {
        this.getRoutingPanel().disableSelectedDevice();
    }

    public void toggleEnableDisableSelectedDevice() throws StudioException {
        this.getRoutingPanel().toggleEnableDisableSelectedDevice();
    }

    public void disconnectSelectedDevice() throws StudioException {
        this.getRoutingPanel().disconnectSelectedDevice();
    }

    public void showAddDevicePopupMenu(Component parent) throws StudioException {
        this.getRoutingPanel().showAddDevicePopupMenu(parent);
    }

    public void closeAllDeviceViews() {
        this.getRoutingPanel().closeAllDeviceCustomizers();
        this.getRoutingPanel().hideDeviceSettingsDialog();
    }

    public void addDevice(Device device) throws StudioException {
        this.addDevice(device, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void addDevice(Device device, int x, int y) throws StudioException {
        Studio s = this.getStudio();
        s.addDevice(device);
        if (x != Integer.MIN_VALUE || y != Integer.MIN_VALUE) {
            s.setDevicePosition(device, x, y);
        }
        s.validateDevice(device);
    }

    public Point getPreferredDeviceLocation() {
        return this.getRoutingPanel().getPreferredDeviceLocation();
    }

    public void showLayoutManagerDialog() {
        DeviceLayoutManagerPanel panel = new DeviceLayoutManagerPanel();
        panel.setStudio(this.getStudio());
        String title = "Layout Manager";
        DeviceLayoutManagerPanel message = panel;
        int messageType = -1;
        JOptionPane.showMessageDialog(this, message, title, messageType);
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    protected void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    protected void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getStudioFile() {
        return this.studioFile;
    }

    protected void setStudioFile(File studioFile) {
        this.studioFile = studioFile;
    }

    public void ensureStudioWindowVisible() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(true);
            if (window instanceof Frame) {
                ((Frame)window).setState(0);
            }
            window.toFront();
            window.requestFocus();
        }
    }

    public void startStudio() throws StudioException {
        new StudioStarter().run();
    }

    public void stopStudio() throws StudioException {
        new StudioStopper().run();
    }

    protected class StopStudioAction
    extends AbstractAction {
        private static final long serialVersionUID = -4564168070094215630L;
        public static final String ACTION_KEY = "StopStudioAction";

        protected StopStudioAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                StudioPanel.this.stopStudio();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class StartStudioAction
    extends AbstractAction {
        private static final long serialVersionUID = 4954457794596598707L;
        public static final String ACTION_KEY = "StartStudioAction";

        protected StartStudioAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                StudioPanel.this.startStudio();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected static class DirectoryFilter
    extends FileFilter {
        protected DirectoryFilter() {
        }

        @Override
        public String getDescription() {
            return "Target Directory";
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    }

    protected static class ZipFileFilter
    extends FileFilter {
        protected ZipFileFilter() {
        }

        @Override
        public String getDescription() {
            return StudioPanel.ZIP_FILE_EXTENSION;
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName();
            if (name != null && name.toLowerCase().endsWith(StudioPanel.ZIP_FILE_EXTENSION)) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public static class StudioFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "waxmonster.xml";
        }

        @Override
        public boolean accept(File f) {
            if ("waxmonster.xml".equals(f.getName())) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public class StudioStopper
    implements Runnable {
        @Override
        public void run() {
            Studio studio = StudioPanel.this.getStudio();
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Stopping studio: " + studio);
                }
                studio.stop();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Studio stopped: " + studio);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public class StudioStarter
    implements Runnable {
        @Override
        public void run() {
            Studio studio = StudioPanel.this.getStudio();
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Starting studio: " + studio);
                }
                studio.start();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Studio started: " + studio);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

