/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.TimerQueue;
import com.spacekiller.util.timer.DefaultTimerQueue;
import com.spacekiller.util.tooling.ToolGroup;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.DeviceRegistry;
import com.waxmonster.studio.PresetProvider;
import com.waxmonster.studio.PresetRegistry;
import com.waxmonster.studio.PresetStore;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.common.FilePresetStore;
import com.waxmonster.studio.impl.DefaultStudio;
import com.waxmonster.studio.impl.DeviceRegistryImpl;
import com.waxmonster.studio.impl.PresetRegistryImpl;
import com.waxmonster.studio.view.StudioView;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StudioPlugin
extends Plugin {
    public static final String WAXMONSTER_STUDIO_PLUGIN_ID = "com.waxmonster.studio.view.StudioPlugin";
    public static final String POINT_DEVICE_PROVIDER = "com.waxmonster.studio.DeviceProvider";
    public static final String POINT_PRESET_PROVIDER = "com.waxmonster.studio.PresetProvider";
    public static final String DEFAULT_PRESET_STORE_FILE_NAME = "presets.registry";
    private static final String DEVICE_LAYOUT_MENU_GROUP_ID = "WaxStudioView_DeviceLayoutMenu_Group";
    private static final Logger logger = Logger.getLogger(StudioPlugin.class.getName());
    private DeviceRegistry deviceRegistry = new DeviceRegistryImpl();
    private PresetRegistry presetRegistry = new PresetRegistryImpl();
    private FilePresetStore presetStore;
    private ThreadManager threadManager;
    private TimerQueue timerQueue;

    public static StudioPlugin getInstance() throws Exception {
        return (StudioPlugin)Platform.getInstance().getPlugin(WAXMONSTER_STUDIO_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
        try {
            File configDir = this.getPlatform().getConfigDir();
            String presetStoreFileName = DEFAULT_PRESET_STORE_FILE_NAME;
            File presetStoreFile = new File(configDir, presetStoreFileName);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading PresetStore: " + presetStoreFile.getPath());
            }
            this.presetStore = new FilePresetStore(presetStoreFileName, presetStoreFile);
            this.presetRegistry.addPresetProvider((PresetProvider)this.presetStore);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading DeviceProviders...");
        }
        Iterator deviceProviderIter = null;
        try {
            deviceProviderIter = this.getPlatform().getServices(DeviceProvider.class);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        int numDeviceProvider = 0;
        while (deviceProviderIter != null && deviceProviderIter.hasNext()) {
            try {
                Object obj = deviceProviderIter.next();
                if (obj == null || !(obj instanceof DeviceProvider)) continue;
                DeviceProvider provider = (DeviceProvider)obj;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("DeviceProvider: " + provider);
                }
                this.deviceRegistry.addDeviceProvider(provider);
                ++numDeviceProvider;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("DeviceProviders: " + numDeviceProvider);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading PresetProviders...");
        }
        Iterator presetProviderIter = null;
        try {
            presetProviderIter = this.getPlatform().getServices(PresetProvider.class);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        int numPresetProvider = 0;
        while (presetProviderIter != null && presetProviderIter.hasNext()) {
            try {
                Object obj = presetProviderIter.next();
                if (obj == null || !(obj instanceof PresetProvider)) continue;
                PresetProvider provider = (PresetProvider)obj;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("PresetProvider: " + provider);
                }
                this.presetRegistry.addPresetProvider(provider);
                ++numPresetProvider;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("PresetProviders: " + numPresetProvider);
        }
    }

    protected void shutdown() {
        super.shutdown();
        try {
            PresetStore presetStore = this.getPresetStore();
            if (presetStore != null) {
                presetStore.flush();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Clock getClock() {
        return this.getPlatform().getClock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadManager getThreadManager() {
        if (this.threadManager == null) {
            StudioPlugin studioPlugin = this;
            synchronized (studioPlugin) {
                if (this.threadManager == null) {
                    this.threadManager = this.getPlatform().getThreadManager();
                }
            }
        }
        return this.threadManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimerQueue getTimerQueue() {
        if (this.timerQueue == null) {
            StudioPlugin studioPlugin = this;
            synchronized (studioPlugin) {
                if (this.timerQueue == null) {
                    ThreadManager threadManager = this.getThreadManager();
                    String timerThreadName = "StudioTimerQueue";
                    int timerThreadPrio = 4;
                    this.timerQueue = new DefaultTimerQueue(threadManager, timerThreadName, timerThreadPrio);
                }
            }
        }
        return this.timerQueue;
    }

    public Studio createStudio(StudioView studioView) {
        DeviceRegistry deviceRegistry = this.getDeviceRegistry();
        PresetRegistry presetRegistry = this.getPresetRegistry();
        PresetStore presetStore = this.getPresetStore();
        Clock clock = this.getClock();
        TimerQueue timerQueue = this.getTimerQueue();
        ThreadManager threadManager = this.getThreadManager();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("createStudio: deviceRegistry=" + deviceRegistry + ", presetRegistry=" + presetRegistry + ", presetStore=" + presetStore + ", clock=" + clock + ", timerQueue=" + timerQueue);
        }
        DefaultStudio studio = new DefaultStudio(deviceRegistry, presetRegistry, presetStore, clock, timerQueue, threadManager, studioView);
        return studio;
    }

    public DeviceRegistry getDeviceRegistry() {
        return this.deviceRegistry;
    }

    public PresetRegistry getPresetRegistry() {
        return this.presetRegistry;
    }

    public PresetStore getPresetStore() {
        return this.presetStore;
    }

    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        super.extensionAvailable(point, x);
        try {
            DeviceProvider provider;
            Object obj;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("extensionAvailable: p=" + point + ", x=" + x);
            }
            if (POINT_DEVICE_PROVIDER.equals(point.getId()) && (obj = this.getExtensionInstance(x)) != null && obj instanceof DeviceProvider) {
                provider = (DeviceProvider)obj;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("DeviceProvider available: " + provider);
                }
                this.deviceRegistry.addDeviceProvider(provider);
            }
            if (POINT_PRESET_PROVIDER.equals(point.getId()) && (obj = this.getExtensionInstance(x)) != null && obj instanceof PresetProvider) {
                provider = (PresetProvider)obj;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("PresetProvider available: " + provider);
                }
                this.presetRegistry.addPresetProvider((PresetProvider)provider);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void extensionUnavailable(ExtensionPoint point, Extension x) {
        super.extensionUnavailable(point, x);
    }

    public void refreshDeviceLayoutMenu() throws Exception {
        Extension ext = this.getDescriptor().getExtension(DEVICE_LAYOUT_MENU_GROUP_ID);
        if (ext == null) {
            return;
        }
        ToolGroup group = (ToolGroup)this.getExtensionInstance(ext);
        if (group == null) {
            return;
        }
        group.refresh();
    }
}

