/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.view.DeviceCustomizerView;
import com.waxmonster.studio.view.RoutingPanel;
import com.waxmonster.studio.view.StudioPanel;
import com.waxmonster.studio.view.StudioToolContextImpl;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class StudioView
extends View {
    public static final String STUDIO_VIEW_NAME = "StudioView";
    private static final Logger logger = Logger.getLogger(StudioView.class.getName());
    private Studio studio;
    private StudioPanel studioPanel;
    private Workbench studioWorkbench;
    private ToolGroup toolBarGroup;
    private ToolGroup studioPopupMenuGroup;
    private ToolGroup addDevicePopupMenuGroup;
    private ToolGroup devicePopupMenuGroup;
    private ToolGroup connectionPopupMenuGroup;

    public StudioView() {
        this.setName(STUDIO_VIEW_NAME);
    }

    protected Component createComponent() {
        return this.getStudioPanel();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    public boolean isDirty() throws Exception {
        if (super.isDirty()) {
            return true;
        }
        if (this.studioPanel != null && this.studioPanel.getRoutingPanel().isDirty()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("StudioPanel is dirty: " + this.studioPanel);
            }
            return true;
        }
        return false;
    }

    public void save() throws Exception {
        super.save();
        StudioPanel sp = this.getStudioPanel();
        if (sp != null) {
            sp.saveStudio();
        }
    }

    public boolean promptClose() throws Exception {
        if (this.studio != null && this.studio.isStarted() && !this.promptStopStudio()) {
            return false;
        }
        return super.promptClose();
    }

    protected boolean promptStopStudio() throws Exception {
        String title = "Stop Studio";
        String message = "The studio is currently active. Are you sure to close ?";
        int optionType = 2;
        int messageType = 2;
        int rc = JOptionPane.showConfirmDialog(this.getComponent(), message, title, optionType, messageType);
        if (rc == 0) {
            if (this.studio != null && this.studio.isStarted()) {
                this.studio.stop();
            }
            return true;
        }
        return false;
    }

    protected boolean promptSaveAndClose() throws Exception {
        this.toFront();
        String title = "Save Studio";
        String message = "Save studio changes ?";
        int optionType = 1;
        int messageType = 3;
        StudioPanel parentComp = this.studioPanel;
        int rc = JOptionPane.showConfirmDialog(parentComp, message, title, optionType, messageType);
        if (rc == 0) {
            this.save();
            return !this.isDirty();
        }
        return rc == 1;
    }

    protected synchronized void dispose() {
        super.dispose();
        try {
            if (this.studio != null && this.studio.isStarted()) {
                this.studio.stop();
            }
            if (this.studioPanel != null) {
                this.studioPanel.closeAllDeviceViews();
            }
            if (this.studio != null) {
                for (Device device : this.studio.getDevices()) {
                    if (device == null) continue;
                    this.studio.removeDevice(device);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected StudioPanel createStudioPanel() {
        StudioPanel studioPanel = new StudioPanel();
        RoutingPanel routingPanel = new RoutingPanel(this);
        routingPanel.setStudio(this.studio);
        studioPanel.setRoutingPanel(routingPanel);
        StudioToolContextImpl toolContext = new StudioToolContextImpl(studioPanel, routingPanel);
        if (this.toolBarGroup != null) {
            JToolBar toolBar = (JToolBar)this.toolBarGroup.createInstance((ToolContext)toolContext, JToolBar.class);
            studioPanel.setToolBar(toolBar);
        }
        if (this.studioPopupMenuGroup != null) {
            JPopupMenu studioPopupMenu = (JPopupMenu)this.studioPopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
            studioPanel.setStudioPopupMenu(studioPopupMenu);
            routingPanel.setStudioPopupMenu(studioPopupMenu);
        }
        if (this.addDevicePopupMenuGroup != null) {
            JPopupMenu addPopupMenu = (JPopupMenu)this.addDevicePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
            routingPanel.setAddDevicePopupMenu(addPopupMenu);
        }
        if (this.devicePopupMenuGroup != null) {
            JPopupMenu devicePopupMenu = (JPopupMenu)this.devicePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
            routingPanel.setDevicePopupMenu(devicePopupMenu);
        }
        if (this.connectionPopupMenuGroup != null) {
            JPopupMenu connectionPopupMenu = (JPopupMenu)this.connectionPopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
            routingPanel.setConnectionPopupMenu(connectionPopupMenu);
        }
        return studioPanel;
    }

    public StudioPanel getStudioPanel() {
        if (this.studioPanel == null) {
            this.setStudioPanel(this.createStudioPanel());
        }
        return this.studioPanel;
    }

    protected void setStudioPanel(StudioPanel studioPanel) {
        this.studioPanel = studioPanel;
    }

    public ToolGroup getToolBarGroup() {
        return this.toolBarGroup;
    }

    public void setToolBarGroup(ToolGroup toolBarGroup) {
        this.toolBarGroup = toolBarGroup;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public ToolGroup getStudioPopupMenuGroup() {
        return this.studioPopupMenuGroup;
    }

    public void setStudioPopupMenuGroup(ToolGroup studioPopupMenuGroup) {
        this.studioPopupMenuGroup = studioPopupMenuGroup;
    }

    public ToolGroup getDevicePopupMenuGroup() {
        return this.devicePopupMenuGroup;
    }

    public void setDevicePopupMenuGroup(ToolGroup devicePopupMenuGroup) {
        this.devicePopupMenuGroup = devicePopupMenuGroup;
    }

    public ToolGroup getConnectionPopupMenuGroup() {
        return this.connectionPopupMenuGroup;
    }

    public void setConnectionPopupMenuGroup(ToolGroup connectionPopupMenuGroup) {
        this.connectionPopupMenuGroup = connectionPopupMenuGroup;
    }

    public ToolGroup getAddDevicePopupMenuGroup() {
        return this.addDevicePopupMenuGroup;
    }

    public void setAddDevicePopupMenuGroup(ToolGroup addDevicePopupMenuGroup) {
        this.addDevicePopupMenuGroup = addDevicePopupMenuGroup;
    }

    public Workbench getStudioWorkbench() {
        return this.studioWorkbench;
    }

    public void setStudioWorkbench(Workbench studioWorkbench) {
        this.studioWorkbench = studioWorkbench;
    }

    protected void snapshotDeviceCustomizerView(DeviceCustomizerView view, boolean closing) {
        StudioPanel sp = this.getStudioPanel();
        if (sp == null) {
            return;
        }
        RoutingPanel rp = sp.getRoutingPanel();
        if (rp == null) {
            return;
        }
        rp.snapshotDeviceCustomizerView(view, closing);
    }
}

