/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.view;

import com.spacekiller.util.FileLocator;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.View;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.view.StudioPanel;
import com.waxmonster.studio.view.StudioPlugin;
import com.waxmonster.studio.view.StudioView;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StudioViewProvider
extends DefaultViewProvider {
    public static final String VIEW_PROVIDER_ID = "StudioViewProvider";
    private static final Logger logger = Platform.getLogger(StudioViewProvider.class);
    private static boolean loadViewDisabled = false;
    private ToolGroup toolBarGroup;
    private ToolGroup studioPopupMenuGroup;
    private ToolGroup addDevicePopupMenuGroup;
    private ToolGroup devicePopupMenuGroup;
    private ToolGroup connectionPopupMenuGroup;

    protected void initView(View v) {
        super.initView(v);
        try {
            StudioView sv = (StudioView)v;
            sv.setToolBarGroup(this.toolBarGroup);
            sv.setStudioPopupMenuGroup(this.studioPopupMenuGroup);
            sv.setAddDevicePopupMenuGroup(this.addDevicePopupMenuGroup);
            sv.setDevicePopupMenuGroup(this.devicePopupMenuGroup);
            sv.setConnectionPopupMenuGroup(this.connectionPopupMenuGroup);
            Studio studio = StudioPlugin.getInstance().createStudio(sv);
            sv.setStudio(studio);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public View loadView(Preferences prefs) throws Exception {
        if (loadViewDisabled) {
            return null;
        }
        return super.loadView(prefs);
    }

    protected void loadView(View view, Preferences prefs) throws Exception {
        String path;
        Object studioFilePath;
        StudioView sv;
        StudioPanel sp;
        super.loadView(view, prefs);
        if (view != null && view instanceof StudioView && (sp = (sv = (StudioView)view).getStudioPanel()) != null && (studioFilePath = prefs.getObject("studioFile")) != null && (path = studioFilePath.toString()) != null && path.length() > 0) {
            FileLocator fileLocator;
            File studioFile = new File(path);
            if (!studioFile.exists() && (fileLocator = Platform.getInstance().getFileLocator()) != null) {
                studioFile = fileLocator.locateFile(path);
            }
            if (studioFile != null) {
                sp.openStudio(studioFile);
            }
        }
    }

    public void saveView(View view, Preferences prefs) throws Exception {
        super.saveView(view, prefs);
        if (view != null && view instanceof StudioView) {
            StudioView sv = (StudioView)view;
            Studio studio = sv.getStudio();
            if (studio == null) {
                return;
            }
            StudioPanel sp = sv.getStudioPanel();
            if (sp == null) {
                return;
            }
            File studioFile = sp.getStudioFile();
            String studioFilePath = studioFile == null ? null : studioFile.getPath();
            prefs.setObject("studioFile", (Object)studioFilePath);
        }
    }

    public ToolGroup getToolBarGroup() {
        return this.toolBarGroup;
    }

    public void setToolBarGroup(ToolGroup toolBarGroup) {
        this.toolBarGroup = toolBarGroup;
    }

    public ToolGroup getStudioPopupMenuGroup() {
        return this.studioPopupMenuGroup;
    }

    public void setStudioPopupMenuGroup(ToolGroup studioPopupMenuGroup) {
        this.studioPopupMenuGroup = studioPopupMenuGroup;
    }

    public ToolGroup getDevicePopupMenuGroup() {
        return this.devicePopupMenuGroup;
    }

    public void setDevicePopupMenuGroup(ToolGroup devicePopupMenuGroup) {
        this.devicePopupMenuGroup = devicePopupMenuGroup;
    }

    public ToolGroup getConnectionPopupMenuGroup() {
        return this.connectionPopupMenuGroup;
    }

    public void setConnectionPopupMenuGroup(ToolGroup connectionPopupMenuGroup) {
        this.connectionPopupMenuGroup = connectionPopupMenuGroup;
    }

    public ToolGroup getAddDevicePopupMenuGroup() {
        return this.addDevicePopupMenuGroup;
    }

    public void setAddDevicePopupMenuGroup(ToolGroup addDevicePopupMenuGroup) {
        this.addDevicePopupMenuGroup = addDevicePopupMenuGroup;
    }

    public static boolean isLoadViewDisabled() {
        return loadViewDisabled;
    }

    public static void setLoadViewDisabled(boolean loadViewDisabled) {
        StudioViewProvider.loadViewDisabled = loadViewDisabled;
    }
}

