/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.math;

import com.spacekiller.util.math.Big;
import com.spacekiller.util.math.BigVar;
import java.io.Serializable;
import java.math.BigDecimal;

public class BigVal
implements Big,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3244622917358480939L;
    public static final BigVal ZERO = new BigVal(0L, 0.0);
    public static final BigVal ONE = new BigVal(1L, 0.0);
    public static final BigVal TWO = new BigVal(2L, 0.0);
    long m;
    double d;

    protected BigVal() {
    }

    public BigVal(double v) {
        this.m = (long)v;
        this.d = v - (double)this.m;
    }

    public BigVal(long vm, double vd) {
        long v = (long)vd;
        this.m = vm + v;
        this.d = vd - (double)v;
    }

    public BigVal(BigVal t) {
        this.m = t.m;
        this.d = t.d;
    }

    public BigVal(Big t) {
        this.m = t.major();
        this.d = t.delta();
    }

    @Override
    public long major() {
        return this.m;
    }

    @Override
    public double delta() {
        return this.d;
    }

    @Override
    public double doubleValue() {
        return (double)this.m + this.d;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.d).add(BigDecimal.valueOf(this.m));
    }

    public BigVal cloneBigVal() throws CloneNotSupportedException {
        return (BigVal)super.clone();
    }

    public String toString() {
        return BigVal.toString(this.m, this.d);
    }

    public int hashCode() {
        return BigVal.hashCode(this.m, this.d);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == BigVal.class) {
            BigVal b = (BigVal)o;
            return this.m == b.m && this.d == b.d;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.compareTo((Big)o);
    }

    public int compareTo(Big o) {
        return BigVal.compare(this.m, this.d, o.major(), o.delta());
    }

    public int compareTo(BigVal o) {
        return BigVal.compare(this.m, this.d, o.m, o.d);
    }

    public int compareTo(BigVar o) {
        return BigVal.compare(this.m, this.d, o.m, o.d);
    }

    public static String toString(long m, double d) {
        return Double.toString((double)m + d);
    }

    public static int hashCode(long m, double d) {
        long v = m ^ Double.doubleToLongBits(d);
        return (int)(v ^ v >>> 32);
    }

    public static int compare(long m, double d, long om, double od) {
        long v = (long)d;
        if (v != 0L) {
            m += v;
            d -= (double)v;
        }
        if ((v = (long)od) != 0L) {
            om += v;
            od -= (double)v;
        }
        if (m < om) {
            return -1;
        }
        if (m > om) {
            return 1;
        }
        if (d < od) {
            return -1;
        }
        if (d > od) {
            return 1;
        }
        return 0;
    }
}

