/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.math;

public class MathUtil {
    private static final double LOG10 = StrictMath.log(10.0);

    private MathUtil() {
    }

    public static double getBeatsPerMinute(double millisPerBeat) {
        return 60000.0 / millisPerBeat;
    }

    public static double getMillisPerBeat(double beatsPerMinute) {
        return 60000.0 / beatsPerMinute;
    }

    public static double getBeatsPerMinute(double framesPerBeat, double frameRate) {
        return frameRate * 60.0 / framesPerBeat;
    }

    public static double getFramesPerBeat(double beatsPerMinute, double frameRate) {
        return frameRate * 60.0 / beatsPerMinute;
    }

    public static double getFrames(double millis, double frameRate) {
        return millis * frameRate / 1000.0;
    }

    public static double getMillis(double frames, double frameRate) {
        return frames * 1000.0 / frameRate;
    }

    public static double getHertz(double frames, double frameRate) {
        return frameRate / frames;
    }

    public static double getHertz(double millis) {
        return 1000.0 / millis;
    }

    public static double getDecibel(double gain) {
        return StrictMath.log(gain) * 20.0 / LOG10;
    }

    public static double getGain(double decibel) {
        return StrictMath.exp(decibel * LOG10 / 20.0);
    }

    public static double minAbsolute(double[] arr, int off, int len) {
        int end = off + len;
        double m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            double v = StrictMath.abs(arr[i]);
            if (!(v < m)) continue;
            m = v;
        }
        return m;
    }

    public static float minAbsolute(float[] arr, int off, int len) {
        int end = off + len;
        float m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            float v = StrictMath.abs(arr[i]);
            if (!(v < m)) continue;
            m = v;
        }
        return m;
    }

    public static long minAbsolute(long[] arr, int off, int len) {
        int end = off + len;
        long m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            long v = StrictMath.abs(arr[i]);
            if (v >= m) continue;
            m = v;
        }
        return m;
    }

    public static int minAbsolute(int[] arr, int off, int len) {
        int end = off + len;
        int m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            int v = StrictMath.abs(arr[i]);
            if (v >= m) continue;
            m = v;
        }
        return m;
    }

    public static double maxAbsolute(double[] arr, int off, int len) {
        int end = off + len;
        double m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            double v = StrictMath.abs(arr[i]);
            if (!(v > m)) continue;
            m = v;
        }
        return m;
    }

    public static float maxAbsolute(float[] arr, int off, int len) {
        int end = off + len;
        float m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            float v = StrictMath.abs(arr[i]);
            if (!(v > m)) continue;
            m = v;
        }
        return m;
    }

    public static float maxAbsolute(long[] arr, int off, int len) {
        int end = off + len;
        long m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            long v = StrictMath.abs(arr[i]);
            if (v <= m) continue;
            m = v;
        }
        return m;
    }

    public static float maxAbsolute(int[] arr, int off, int len) {
        int end = off + len;
        int m = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            int v = StrictMath.abs(arr[i]);
            if (v <= m) continue;
            m = v;
        }
        return m;
    }

    public static void normalize(double[] arr, int off, int len) {
        double m = MathUtil.maxAbsolute(arr, off, len);
        if (m > 0.0) {
            int end = off + len;
            int i = off;
            while (i < end) {
                int n = i++;
                arr[n] = arr[n] / m;
            }
        }
    }

    public static void normalize(float[] arr, int off, int len) {
        float m = MathUtil.maxAbsolute(arr, off, len);
        if (m > 0.0f) {
            int end = off + len;
            int i = off;
            while (i < end) {
                int n = i++;
                arr[n] = arr[n] / m;
            }
        }
    }

    public static void absolute(double[] arr, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            arr[i] = Math.abs(arr[i]);
        }
    }

    public static void absolute(float[] arr, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            arr[i] = Math.abs(arr[i]);
        }
    }

    public static void absolute(long[] arr, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            arr[i] = Math.abs(arr[i]);
        }
    }

    public static void absolute(int[] arr, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            arr[i] = Math.abs(arr[i]);
        }
    }

    public static void multiply(double[] arr, int off, int len, double v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] * v;
        }
    }

    public static void multiply(float[] arr, int off, int len, float v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] * v;
        }
    }

    public static void multiply(long[] arr, int off, int len, long v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] * v;
        }
    }

    public static void multiply(int[] arr, int off, int len, int v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] * v;
        }
    }

    public static void multiply(long[] arr, int off, int len, double v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = (long)((double)arr[n] * v);
        }
    }

    public static void multiply(int[] arr, int off, int len, double v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = (int)((double)arr[n] * v);
        }
    }

    public static void divide(double[] arr, int off, int len, double v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] / v;
        }
    }

    public static void divide(float[] arr, int off, int len, float v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] / v;
        }
    }

    public static void divide(long[] arr, int off, int len, long v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] / v;
        }
    }

    public static void divide(int[] arr, int off, int len, int v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = arr[n] / v;
        }
    }

    public static void divide(long[] arr, int off, int len, double v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = (long)((double)arr[n] / v);
        }
    }

    public static void divide(int[] arr, int off, int len, double v) {
        int end = off + len;
        int i = off;
        while (i < end) {
            int n = i++;
            arr[n] = (int)((double)arr[n] / v);
        }
    }

    public static double max(double[] arr, int off, int len) {
        int end = off + len;
        double m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (!(arr[i] > m)) continue;
            m = arr[i];
        }
        return m;
    }

    public static float max(float[] arr, int off, int len) {
        int end = off + len;
        float m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (!(arr[i] > m)) continue;
            m = arr[i];
        }
        return m;
    }

    public static long max(long[] arr, int off, int len) {
        int end = off + len;
        long m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (arr[i] <= m) continue;
            m = arr[i];
        }
        return m;
    }

    public static int max(int[] arr, int off, int len) {
        int end = off + len;
        int m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (arr[i] <= m) continue;
            m = arr[i];
        }
        return m;
    }

    public static double min(double[] arr, int off, int len) {
        int end = off + len;
        double m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (!(arr[i] < m)) continue;
            m = arr[i];
        }
        return m;
    }

    public static float min(float[] arr, int off, int len) {
        int end = off + len;
        float m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (!(arr[i] < m)) continue;
            m = arr[i];
        }
        return m;
    }

    public static long min(long[] arr, int off, int len) {
        int end = off + len;
        long m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (arr[i] >= m) continue;
            m = arr[i];
        }
        return m;
    }

    public static int min(int[] arr, int off, int len) {
        int end = off + len;
        int m = arr[off];
        for (int i = off + 1; i < end; ++i) {
            if (arr[i] >= m) continue;
            m = arr[i];
        }
        return m;
    }

    public static double avg(double[] arr, int off, int len) {
        int end = off + len;
        double s = arr[off];
        for (int i = off + 1; i < end; ++i) {
            s += arr[i];
        }
        return s / (double)len;
    }

    public static double avg(float[] arr, int off, int len) {
        int end = off + len;
        double s = arr[off];
        for (int i = off + 1; i < end; ++i) {
            s += (double)arr[i];
        }
        return s / (double)len;
    }

    public static double avg(long[] arr, int off, int len) {
        int end = off + len;
        double s = arr[off];
        for (int i = off + 1; i < end; ++i) {
            s += (double)arr[i];
        }
        return s / (double)len;
    }

    public static double avg(int[] arr, int off, int len) {
        int end = off + len;
        double s = arr[off];
        for (int i = off + 1; i < end; ++i) {
            s += (double)arr[i];
        }
        return s / (double)len;
    }

    public static double avgAbsolute(double[] arr, int off, int len) {
        int end = off + len;
        double s = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            s += StrictMath.abs(arr[i]);
        }
        return s / (double)len;
    }

    public static double avgAbsolute(float[] arr, int off, int len) {
        int end = off + len;
        double s = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            s += (double)StrictMath.abs(arr[i]);
        }
        return s / (double)len;
    }

    public static double avgAbsolute(long[] arr, int off, int len) {
        int end = off + len;
        double s = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            s += (double)StrictMath.abs(arr[i]);
        }
        return s / (double)len;
    }

    public static int max(int a, int b, int c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    public static long max(long a, long b, long c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    public static float max(float a, float b, float c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    public static double max(double a, double b, double c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    public static int min(int a, int b, int c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static long min(long a, long b, long c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static float min(float a, float b, float c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static double min(double a, double b, double c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static double avgAbsolute(int[] arr, int off, int len) {
        int end = off + len;
        double s = StrictMath.abs(arr[off]);
        for (int i = off + 1; i < end; ++i) {
            s += (double)StrictMath.abs(arr[i]);
        }
        return s / (double)len;
    }

    public static void differentiate(double[] arr, int off, int len) {
        int end = off + len - 1;
        for (int i = off; i < end; ++i) {
            arr[i] = arr[i + 1] - arr[i];
        }
        arr[end] = -arr[end];
    }

    public static void differentiate(float[] arr, int off, int len) {
        int end = off + len - 1;
        for (int i = off; i < end; ++i) {
            arr[i] = arr[i + 1] - arr[i];
        }
        arr[end] = -arr[end];
    }

    public static void integrate(double[] arr, int off, int len, double v) {
        int end = off + len - 1;
        for (int i = off; i < end; ++i) {
            double x = v + arr[i];
            arr[i] = v;
            v = x;
        }
        arr[end] = v;
    }

    public static void integrate(float[] arr, int off, int len, float v) {
        int end = off + len - 1;
        for (int i = off; i < end; ++i) {
            float x = v + arr[i];
            arr[i] = v;
            v = x;
        }
        arr[end] = v;
    }
}

