/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionListener;
import com.spacekiller.util.ExecutionManager;
import java.util.ArrayList;
import java.util.List;

public class DefaultExecutionManager
implements ExecutionManager {
    private List executions;
    private List listeners;
    private ExecHandler execHandler = new ExecHandler();

    public DefaultExecutionManager() {
        this.executions = new ArrayList();
        this.listeners = new ArrayList();
    }

    public synchronized int getExecutionCount() {
        return this.executions.size();
    }

    public synchronized Execution[] getExecutions() {
        int num = this.executions.size();
        Execution[] rc = new Execution[num];
        rc = this.executions.toArray(rc);
        return rc;
    }

    public int getUserExecutionCount() {
        return this.getExecutionCount(false);
    }

    public int getDaemonExecutionCount() {
        return this.getExecutionCount(true);
    }

    protected synchronized int getExecutionCount(boolean daemon) {
        int num = this.executions.size();
        if (num < 1) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < num; ++i) {
            Execution exec = (Execution)this.executions.get(i);
            if (exec == null || exec.isDaemon() != daemon) continue;
            ++count;
        }
        return count;
    }

    public synchronized void addExecution(Execution exec) {
        if (exec != null) {
            this.executions.add(exec);
            exec.addExecutionListener((ExecutionListener)this.execHandler);
        }
    }

    public synchronized void removeExecution(Execution exec) {
        if (this.executions.remove(exec)) {
            exec.removeExecutionListener((ExecutionListener)this.execHandler);
        }
    }

    public synchronized void addExecutionListener(ExecutionListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public synchronized void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    protected synchronized void fireExecutionStarted(Execution exec) {
        int num = this.listeners.size();
        for (int c = 0; c < num; ++c) {
            ExecutionListener l = (ExecutionListener)this.listeners.get(c);
            l.executionStarted(exec);
        }
    }

    protected synchronized void fireExecutionStopped(Execution exec) {
        int num = this.listeners.size();
        for (int c = 0; c < num; ++c) {
            ExecutionListener l = (ExecutionListener)this.listeners.get(c);
            l.executionStopped(exec);
        }
    }

    protected synchronized void fireExecutionPaused(Execution exec) {
        int num = this.listeners.size();
        for (int c = 0; c < num; ++c) {
            ExecutionListener l = (ExecutionListener)this.listeners.get(c);
            l.executionPaused(exec);
        }
    }

    protected synchronized void fireExecutionResumed(Execution exec) {
        int num = this.listeners.size();
        for (int c = 0; c < num; ++c) {
            ExecutionListener l = (ExecutionListener)this.listeners.get(c);
            l.executionResumed(exec);
        }
    }

    protected class ExecHandler
    implements ExecutionListener {
        protected ExecHandler() {
        }

        public void executionStarted(Execution x) {
            DefaultExecutionManager.this.fireExecutionStarted(x);
        }

        public void executionStopped(Execution x) {
            DefaultExecutionManager.this.removeExecution(x);
            DefaultExecutionManager.this.fireExecutionStopped(x);
        }

        public void executionPaused(Execution x) {
            DefaultExecutionManager.this.fireExecutionPaused(x);
        }

        public void executionResumed(Execution x) {
            DefaultExecutionManager.this.fireExecutionResumed(x);
        }
    }
}

