/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.Injection;
import com.spacekiller.util.InjectionException;
import com.spacekiller.util.InjectionFactory;
import com.spacekiller.util.Platform;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultInjectionFactory
implements InjectionFactory {
    private static final Logger logger = Platform.getLogger(DefaultInjectionFactory.class);
    private List factoryList = new LinkedList();

    public Injection createInjection(URL configURL, ClassLoader loader, Injection parentInjection) throws InjectionException {
        for (InjectionFactory factory : this.factoryList) {
            try {
                return factory.createInjection(configURL, loader, parentInjection);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        throw new InjectionException("No InjectionFactory available to load configuration: " + configURL);
    }

    protected void registerInjectionFactory(InjectionFactory factory) {
        ArrayList<InjectionFactory> newList = new ArrayList<InjectionFactory>(this.factoryList.size() + 1);
        newList.addAll(this.factoryList);
        newList.add(factory);
        this.factoryList = newList;
    }
}

