/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.platform.DefaultPreferences;
import com.spacekiller.util.platform.DefaultPropertyReader;
import com.spacekiller.util.platform.DefaultPropertyWriter;
import com.spacekiller.util.platform.PropertiesFileWriter;
import com.spacekiller.util.platform.PropertyReader;
import com.spacekiller.util.platform.PropertyWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultPreferencesRegistry
implements PreferencesRegistry {
    private static final Logger logger = Logger.getLogger(DefaultPreferencesRegistry.class.getName());
    public static final String KEY_BASE_DIRECTORY = ".directory";
    public static final String DEFAULT_BASE_DIRECTORY_NAME = "preferences";
    public static final String DEFAULT_PROPERTIES_FILE_SUFFIX = ".properties";
    private static PropertyReader defaultPropertyReader;
    private static PropertyWriter defaultPropertyWriter;
    private File indexFile;
    private File baseDirectory;
    private String propertiesFileSuffix = ".properties";
    private String baseDirectoryName = "preferences";
    private Map<String, String> keyMap;
    private Map<String, DefaultPreferences> prefMap;
    private PropertyReader propertyReader;
    private PropertyWriter propertyWriter;

    public DefaultPreferencesRegistry(File indexFile) {
        this.setIndexFile(indexFile);
        this.setBaseDirectory(new File(indexFile.getParentFile(), this.baseDirectoryName));
        this.setPropertyReader(DefaultPreferencesRegistry.getDefaultPropertyReader());
        this.setPropertyWriter(DefaultPreferencesRegistry.getDefaultPropertyWriter());
    }

    public void initialize() throws IOException {
        this.keyMap = new HashMap<String, String>();
        this.prefMap = new HashMap<String, DefaultPreferences>();
        if (this.indexFile.exists() && this.indexFile.isFile()) {
            this.loadIndexFile();
        }
    }

    protected static PropertyReader getDefaultPropertyReader() {
        PropertyReader reader = defaultPropertyReader;
        if (reader == null) {
            defaultPropertyReader = reader = new DefaultPropertyReader();
        }
        return reader;
    }

    protected static PropertyWriter getDefaultPropertyWriter() {
        PropertyWriter writer = defaultPropertyWriter;
        if (writer == null) {
            defaultPropertyWriter = writer = new DefaultPropertyWriter();
        }
        return writer;
    }

    protected String getPropertiesFileSuffix() {
        return this.propertiesFileSuffix;
    }

    protected void setPropertiesFileSuffix(String propertiesFileSuffix) {
        this.propertiesFileSuffix = propertiesFileSuffix;
    }

    protected String getBaseDirectoryName() {
        return this.baseDirectoryName;
    }

    protected void setBaseDirectoryName(String baseDirectoryName) {
        this.baseDirectoryName = baseDirectoryName;
    }

    protected File getIndexFile() {
        return this.indexFile;
    }

    protected void setIndexFile(File indexFile) {
        this.indexFile = indexFile;
    }

    protected File getBaseDirectory() {
        return this.baseDirectory;
    }

    protected void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected PropertyReader getPropertyReader() {
        return this.propertyReader;
    }

    protected void setPropertyReader(PropertyReader propertyReader) {
        this.propertyReader = propertyReader;
    }

    protected PropertyWriter getPropertyWriter() {
        return this.propertyWriter;
    }

    protected void setPropertyWriter(PropertyWriter propertyWriter) {
        this.propertyWriter = propertyWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadIndexFile() throws IOException {
        FileInputStream fis = new FileInputStream(this.indexFile);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                Properties props = new Properties();
                props.load(bis);
                for (Map.Entry<Object, Object> me : props.entrySet()) {
                    String key = (String)me.getKey();
                    String value = (String)me.getValue();
                    if (KEY_BASE_DIRECTORY.equals(key)) {
                        File baseDir = new File(value);
                        if (!baseDir.isAbsolute()) {
                            baseDir = new File(this.indexFile.getParentFile(), value);
                        }
                        this.setBaseDirectoryName(value);
                        this.setBaseDirectory(baseDir);
                        continue;
                    }
                    this.keyMap.put(key, value);
                }
            }
            finally {
                bis.close();
            }
        }
        finally {
            fis.close();
        }
    }

    protected synchronized void saveIndexFile() throws IOException {
        if (this.indexFile.exists()) {
            // empty if block
        }
        Properties props = new Properties();
        this.map2props(this.keyMap, props);
        props.setProperty(KEY_BASE_DIRECTORY, this.getBaseDirectoryName());
        this.writePropertiesFile(props, this.indexFile);
    }

    protected File getPropertiesFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDirectory, path);
    }

    protected DefaultPreferences newPreferences(String key) {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        DefaultPreferences prefs = new DefaultPreferences(propMap);
        prefs.setKey(key);
        return prefs;
    }

    public synchronized boolean containsKey(String key) throws Exception {
        return this.keyMap.containsKey(key);
    }

    public synchronized String[] getKeys() throws Exception {
        Set<String> set = this.keyMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public synchronized String[] getKeys(String keyPrefix) throws Exception {
        if (keyPrefix == null) {
            keyPrefix = "";
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String key : this.keyMap.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            list.add(key);
        }
        return list.toArray(new String[list.size()]);
    }

    public synchronized Preferences createPreferences(String key) throws Exception {
        if (key == null || key.length() < 1) {
            throw new Exception("Invalid preferences key: " + key);
        }
        if (this.keyMap.containsKey(key)) {
            throw new Exception("Preferences already exist for key: " + key);
        }
        if (!this.baseDirectory.exists() && !this.baseDirectory.mkdirs()) {
            throw new IOException("Preferences base directory could not be created: " + this.baseDirectory);
        }
        File propFile = new File(this.baseDirectory, key + this.propertiesFileSuffix);
        if (propFile.exists()) {
            File file;
            int i;
            File newFile = null;
            for (i = 2; i < 10; ++i) {
                file = new File(this.baseDirectory, key + "-" + i + this.propertiesFileSuffix);
                if (file.exists()) continue;
                newFile = file;
                break;
            }
            if (newFile == null) {
                for (i = 2; i < 10; ++i) {
                    file = new File(this.baseDirectory, key + "-" + (int)(Math.random() * (double)i * 10.0) + this.propertiesFileSuffix);
                    if (file.exists()) continue;
                    newFile = file;
                    break;
                }
                if (newFile == null) {
                    throw new Exception("Properties file already exist: " + propFile);
                }
            }
            propFile = newFile;
        }
        RandomAccessFile raf = new RandomAccessFile(propFile, "rw");
        raf.close();
        this.keyMap.put(key, propFile.getName());
        this.saveIndexFile();
        DefaultPreferences prefs = this.newPreferences(key);
        this.prefMap.put(key, prefs);
        return prefs;
    }

    public synchronized void removePreferences(String key) throws Exception {
        String path = this.keyMap.get(key);
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (!file.isAbsolute() && (file = this.getPropertiesFile(path)).exists() && file.isFile()) {
            try {
                boolean done = file.delete();
                if (!done) {
                    logger.warning("Could not delete properties file: " + file);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.keyMap.remove(key);
        this.prefMap.remove(key);
        this.saveIndexFile();
    }

    public synchronized Preferences getPreferences(String key) throws Exception {
        DefaultPreferences prefs = this.prefMap.get(key);
        if (prefs != null) {
            return prefs;
        }
        prefs = this.readPreferences(key, false);
        if (prefs != null) {
            this.prefMap.put(key, prefs);
        }
        return prefs;
    }

    public synchronized Preferences verifyPreferences(String key) throws Exception {
        DefaultPreferences prefs = this.prefMap.get(key);
        if (prefs != null) {
            return prefs;
        }
        prefs = this.readPreferences(key, true);
        if (prefs != null) {
            this.prefMap.put(key, prefs);
        }
        return prefs;
    }

    public void savePreferences(Preferences prefs) throws Exception {
        DefaultPreferences def = (DefaultPreferences)prefs;
        if (!def.isDirty()) {
            return;
        }
        String key = def.getKey();
        DefaultPreferences thePrefs = this.prefMap.get(key);
        if (thePrefs == null) {
            throw new IllegalArgumentException("Preferences not loaded: " + key);
        }
        if (thePrefs != def) {
            throw new IllegalArgumentException("Invalid Preferences object: " + (Object)((Object)def));
        }
        this.writePreferences(key, thePrefs, true);
    }

    public void clearPreferences(Preferences prefs) throws Exception {
        DefaultPreferences def = (DefaultPreferences)prefs;
        def.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DefaultPreferences readPreferences(String key, boolean verify) throws Exception {
        String path = this.keyMap.get(key);
        if (path == null) {
            return null;
        }
        File file = this.getPropertiesFile(path);
        if (!file.exists()) {
            if (verify) {
                throw new FileNotFoundException("Preferences file not found: key=" + key + ", file=" + file);
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Preferences file not found: key=" + key + ", file=" + file);
            }
            return this.newPreferences(key);
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                props.load(bis);
            }
            finally {
                bis.close();
            }
        }
        finally {
            fis.close();
        }
        DefaultPreferences prefs = this.newPreferences(key);
        Map<String, Object> map = prefs.getMap();
        PropertyReader reader = this.propertyReader;
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String k = (String)me.getKey();
            try {
                reader.read(props, k, (String)me.getValue(), map);
            }
            catch (Exception e) {
                if (verify) {
                    throw e;
                }
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writePreferences(String key, DefaultPreferences prefs, boolean verify) throws Exception {
        String path = this.keyMap.get(key);
        if (path == null) {
            throw new IllegalStateException("Path is null for key: " + key);
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.baseDirectory, path);
            if (!this.baseDirectory.exists() && !this.baseDirectory.mkdirs()) {
                throw new IOException("Preferences base directory could not be created: " + this.baseDirectory);
            }
        }
        PropertyWriter writer = this.propertyWriter;
        Properties props = new Properties();
        DefaultPreferences defaultPreferences = prefs;
        synchronized (defaultPreferences) {
            Map<String, Object> map = prefs.getMap();
            for (Map.Entry<String, Object> me : map.entrySet()) {
                try {
                    writer.write(me.getKey(), me.getValue(), props);
                }
                catch (Exception e) {
                    if (verify) {
                        throw e;
                    }
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        this.writePropertiesFile(props, file);
    }

    protected void writePropertiesFile(Properties props, File file) throws IOException {
        new PropertiesFileWriter().writePropertiesFile(props, file);
    }

    protected void map2props(Map<String, String> map, Properties props) {
        for (Map.Entry<String, String> me : map.entrySet()) {
            props.setProperty(me.getKey(), me.getValue());
        }
    }
}

