/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.platform;

import com.spacekiller.util.BeanNotFoundException;
import com.spacekiller.util.Injection;
import com.spacekiller.util.InjectionException;
import java.util.HashMap;
import java.util.Map;

public class PluginInjection
implements Injection {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Injection[] array;
    private final int count;
    private Map beans;

    public PluginInjection(Injection[] injections) {
        this.array = injections;
        this.count = injections.length;
        this.beans = new HashMap();
    }

    public boolean containsBean(String name) {
        return this.getInjection(name) != null;
    }

    public Class getType(String name) throws BeanNotFoundException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.getType(name);
        }
        throw new BeanNotFoundException(name);
    }

    public boolean isTypeMatch(String name, Class type) throws BeanNotFoundException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.isTypeMatch(name, type);
        }
        throw new BeanNotFoundException(name);
    }

    public Object getBean(String name) throws InjectionException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.getBean(name);
        }
        throw new BeanNotFoundException(name);
    }

    public Object getBean(String name, Class type) throws InjectionException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.getBean(name, type);
        }
        throw new BeanNotFoundException(name);
    }

    public Object getBean(String name, Object[] args) throws InjectionException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.getBean(name, args);
        }
        throw new BeanNotFoundException(name);
    }

    public Object getBean(String name, Class type, Object[] args) throws InjectionException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.getBean(name, type, args);
        }
        throw new BeanNotFoundException(name);
    }

    public String[] getAliases(String name) {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.getAliases(name);
        }
        return EMPTY_STRING_ARRAY;
    }

    public boolean isSingleton(String name) throws BeanNotFoundException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.isSingleton(name);
        }
        throw new BeanNotFoundException(name);
    }

    public boolean isPrototype(String name) throws BeanNotFoundException {
        Injection injection = this.getInjection(name);
        if (injection != null) {
            return injection.isPrototype(name);
        }
        throw new BeanNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Injection getInjection(String name) {
        Injection injection;
        Map map = this.beans;
        synchronized (map) {
            injection = (Injection)this.beans.get(name);
            if (injection == null) {
                for (int i = 0; i < this.count; ++i) {
                    if (!this.array[i].containsBean(name)) continue;
                    injection = this.array[i];
                    this.beans.put(name, injection);
                    break;
                }
            }
        }
        return injection;
    }
}

