/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.format;

import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatRequest;
import com.spacekiller.util.format.FileFormatSignature;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;

public abstract class AbstractFileFormat
implements FileFormat {
    private final String formatName;
    private String formatTitle;
    private Icon defaultFormatIcon;
    private String defaultExtension;
    private String[] supportedExtensions;
    private FileFormatSignature[] supportedSignatures;

    protected AbstractFileFormat(String formatName) {
        this.formatName = formatName;
    }

    @Override
    public final String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getFormatTitle() {
        return this.formatTitle;
    }

    protected void setFormatTitle(String formatTitle) {
        this.formatTitle = formatTitle;
    }

    @Override
    public Icon getFormatIcon(int kind) {
        return this.getDefaultFormatIcon();
    }

    protected Icon getDefaultFormatIcon() {
        return this.defaultFormatIcon;
    }

    protected void setDefaultFormatIcon(Icon defaultFormatIcon) {
        this.defaultFormatIcon = defaultFormatIcon;
    }

    @Override
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    protected void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    @Override
    public String[] getSupportedExtensions() {
        String[] orig = this.supportedExtensions;
        if (orig == null) {
            return null;
        }
        String[] copy = new String[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    protected void setSupportedExtensions(String[] supportedExtensions) {
        this.supportedExtensions = supportedExtensions;
    }

    public FileFormatSignature[] getSupportedSignatures() {
        FileFormatSignature[] orig = this.supportedSignatures;
        if (orig == null) {
            return null;
        }
        FileFormatSignature[] copy = new FileFormatSignature[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    protected void setSupportedSignatures(FileFormatSignature[] supportedSignatures) {
        this.supportedSignatures = supportedSignatures;
    }

    @Override
    public boolean checkExtension(String path) throws IOException {
        String ext2 = this.defaultExtension;
        if (ext2 != null && this.checkExtension(path, ext2)) {
            return true;
        }
        String[] extensions = this.supportedExtensions;
        if (extensions != null) {
            for (String ext2 : extensions) {
                if (ext2 == null || !this.checkExtension(path, ext2)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkExtension(String path, String extension) throws IOException {
        int extLen;
        int pathLen = path.length();
        if (pathLen < (extLen = extension.length())) {
            return false;
        }
        return extension.equalsIgnoreCase(path.substring(pathLen - extLen));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSignature(FileFormatRequest request) throws IOException {
        int num;
        FileFormatSignature[] signatures = this.supportedSignatures;
        if (signatures != null && (num = signatures.length) > 0) {
            InputStream stream = request.getInputStream();
            try {
                for (int i = 0; i < num; ++i) {
                    FileFormatSignature sig = signatures[i];
                    byte[] buffer = request.getBuffer(sig.getMinBufferSize());
                    if (!sig.matches(stream, buffer)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                stream.close();
            }
        }
        return false;
    }
}

