/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.format;

import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatFileType;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class AbstractFileFormatFileType
implements FileFormatFileType {
    private static final Logger logger = Logger.getLogger(AbstractFileFormatFileType.class.getName());
    private final FileFormat fileFormat;

    protected AbstractFileFormatFileType(FileFormat fileFormat) {
        if (fileFormat == null) {
            throw new NullPointerException("fileFormat");
        }
        this.fileFormat = fileFormat;
    }

    @Override
    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String getName() {
        return this.fileFormat.getFormatName();
    }

    public Icon getIcon(int iconKind) {
        return this.fileFormat.getFormatIcon(iconKind);
    }

    public Icon getIcon(File file, int iconKind) {
        return this.getIcon(iconKind);
    }

    public String getFileExtension() {
        return this.fileFormat.getDefaultExtension();
    }

    public String[] getFileExtensions() {
        return this.fileFormat.getSupportedExtensions();
    }

    public String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public boolean matches(File file) {
        if (file == null) {
            return false;
        }
        try {
            return this.fileFormat.checkExtension(file.getPath());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public String[] getCustomizerClassNames() {
        return null;
    }

    public Iterator getOpenWithActions(File file) {
        return null;
    }
}

