/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.format;

import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractFileFormatSignature
implements FileFormatSignature {
    private final String name;
    private FileFormat defaultFileFormat;
    private FileFormat[] supportedFileFormats;

    public AbstractFileFormatSignature(String name, FileFormat fileFormat) {
        this.name = name;
        this.defaultFileFormat = fileFormat;
    }

    public AbstractFileFormatSignature(String name, FileFormat defaultFormat, FileFormat[] supportedFormats) {
        this(name, defaultFormat);
        this.supportedFileFormats = supportedFormats;
    }

    @Override
    public final String getSignatureName() {
        return this.name;
    }

    @Override
    public FileFormat getDefaultFileFormat() {
        return this.defaultFileFormat;
    }

    @Override
    public FileFormat[] getSupportedFileFormats() {
        FileFormat[] orig = this.supportedFileFormats;
        if (orig == null) {
            return null;
        }
        int num = orig.length;
        FileFormat[] copy = new FileFormat[num];
        System.arraycopy(orig, 0, copy, 0, num);
        return copy;
    }

    protected boolean readFully(InputStream stream, byte[] buf, int off, int len) throws IOException {
        int n;
        while ((n = stream.read(buf, off, len)) < len) {
            if (n < 0) {
                return false;
            }
            off += n;
            len -= n;
        }
        return true;
    }
}

