/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.format;

import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatDetector;
import com.spacekiller.util.format.FileFormatRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFileFormatDetector
implements FileFormatDetector {
    private static final Logger logger = Logger.getLogger(DefaultFileFormatDetector.class.getName());
    private FileFormat[] fileFormats;
    private Map fileExtensionMap;

    public DefaultFileFormatDetector(FileFormat[] fileFormats) {
        this.fileFormats = fileFormats;
        this.fileExtensionMap = new HashMap();
        this.initFileFormatDetectorImpl();
    }

    protected void initFileFormatDetectorImpl() {
        for (FileFormat format : this.fileFormats) {
            String[] extensions;
            String extension = format.getDefaultExtension();
            if (extension != null) {
                this.initFileFormatExtension(extension, format);
            }
            if ((extensions = format.getSupportedExtensions()) == null) continue;
            for (int k = 0; k < extensions.length; ++k) {
                extension = extensions[k];
                if (extension == null) continue;
                this.initFileFormatExtension(extension, format);
            }
        }
    }

    protected void initFileFormatExtension(String extension, FileFormat format) {
        FileFormat[] arr = (FileFormat[])this.fileExtensionMap.get(extension = extension.toLowerCase());
        int arrLen = arr == null ? 0 : arr.length;
        int newLen = arrLen + 1;
        FileFormat[] newArr = new FileFormat[newLen];
        if (arrLen > 0) {
            System.arraycopy(arr, 0, newArr, 0, arrLen);
        }
        newArr[arrLen] = format;
        this.fileExtensionMap.put(extension, newArr);
    }

    @Override
    public FileFormat detectExtension(String path) {
        FileFormat[] formats;
        String extension = this.parseExtension(path);
        if (extension != null && (formats = (FileFormat[])this.fileExtensionMap.get(extension = extension.toLowerCase())) != null) {
            for (FileFormat format : formats) {
                try {
                    if (format.checkExtension(path)) {
                        return format;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        for (FileFormat format : this.fileFormats) {
            try {
                if (!format.checkExtension(path)) continue;
                return format;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    protected String parseExtension(String path) {
        int x = path.lastIndexOf(46);
        if (x < 0) {
            return null;
        }
        return path.substring(x);
    }

    @Override
    public FileFormat detectSignature(FileFormatRequest request) throws IOException {
        for (FileFormat format : this.fileFormats) {
            try {
                if (!format.checkSignature(request)) continue;
                return format;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }
}

