/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.format;

import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.Platform;
import com.spacekiller.util.format.DefaultFileFormatDetector;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatDetector;
import com.spacekiller.util.format.FileFormatFileType;
import java.util.LinkedList;

public class FileFormatManager {
    private static FileFormatManager instance;

    protected FileFormatManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileFormatManager getInstance() {
        if (instance != null) return instance;
        Class<FileFormatManager> clazz = FileFormatManager.class;
        synchronized (FileFormatManager.class) {
            if (instance != null) return instance;
            instance = new FileFormatManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized FileFormat[] getFileFormats() {
        FileTypeRegistry fileTypeRegistry = Platform.getInstance().getFileTypeRegistry();
        if (fileTypeRegistry == null) {
            return null;
        }
        FileType[] fileTypes = fileTypeRegistry.getFileTypes();
        if (fileTypes == null) {
            return null;
        }
        LinkedList<FileFormat> formatList = new LinkedList<FileFormat>();
        int num = fileTypes.length;
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                FileFormatFileType ffft;
                FileFormat fileFormat;
                FileType fileType = fileTypes[i];
                if (fileType == null || !(fileType instanceof FileFormatFileType) || (fileFormat = (ffft = (FileFormatFileType)fileType).getFileFormat()) == null) continue;
                formatList.add(fileFormat);
            }
        }
        return formatList.toArray(new FileFormat[formatList.size()]);
    }

    public FileFormatDetector createFileFormatDetector() {
        FileFormat[] fileFormats = this.getFileFormats();
        return new DefaultFileFormatDetector(fileFormats);
    }
}

