/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.format;

import com.spacekiller.util.format.AbstractFileFormatSignature;
import com.spacekiller.util.format.FileFormat;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class SimpleFileFormatSignature
extends AbstractFileFormatSignature {
    private final int offset;
    private final byte[] data;

    public SimpleFileFormatSignature(String name, FileFormat format, int offset, byte[] data) {
        super(name, format);
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid signature offset: " + offset);
        }
        if (data == null) {
            throw new NullPointerException("signature data is null");
        }
        this.offset = offset;
        this.data = data;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.data.length;
    }

    @Override
    public int getMinBufferSize() {
        return this.offset + this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(InputStream stream, byte[] buffer) throws IOException {
        int readlimit = this.getMinBufferSize();
        stream.mark(readlimit);
        try {
            if (!this.readFully(stream, buffer, 0, readlimit)) {
                boolean bl = false;
                return bl;
            }
            int ofs = this.offset;
            int len = this.data.length;
            if (ofs + len > buffer.length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < len; ++i) {
                if (this.data[i] == buffer[ofs++]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (EOFException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            stream.reset();
        }
    }
}

