/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.AbstractControl;
import com.spacekiller.util.media.control.AudioFormatControl;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;

public abstract class AbstractAudioFormatControl
extends AbstractControl
implements AudioFormatControl {
    private static final float DEFAULT_AUDIO_FRAME_RATE = 44100.0f;
    private static final float[] COMMON_AUDIO_FRAME_RATES = new float[]{44100.0f, 48000.0f, 88200.0f, 96000.0f};
    private AudioFormat audioFormat;
    private AudioFormat[] audioFormats;

    public static float[] getCommonAudioFrameRates() {
        float[] arr = new float[COMMON_AUDIO_FRAME_RATES.length];
        System.arraycopy(COMMON_AUDIO_FRAME_RATES, 0, arr, 0, arr.length);
        return arr;
    }

    public static float getDefaultAudioFrameRate() {
        return 44100.0f;
    }

    public static Properties getAudioFormatProperties(AudioFormat format, String keyPrefix) {
        Properties props = new Properties();
        if (format != null) {
            props.setProperty(keyPrefix + "encoding", String.valueOf(format.getEncoding()));
            props.setProperty(keyPrefix + "frameRate", String.valueOf(format.getFrameRate()));
            props.setProperty(keyPrefix + "channels", String.valueOf(format.getChannels()));
            props.setProperty(keyPrefix + "bitDepth", String.valueOf(format.getSampleSizeInBits()));
            if (format.isBigEndian()) {
                props.setProperty(keyPrefix + "bigEndian", String.valueOf(format.isBigEndian()));
            }
        }
        return props;
    }

    public static AudioFormat.Encoding parseEncoding(String s) {
        if (AudioFormat.Encoding.PCM_SIGNED.toString().equalsIgnoreCase(s)) {
            return AudioFormat.Encoding.PCM_SIGNED;
        }
        if (AudioFormat.Encoding.PCM_UNSIGNED.toString().equalsIgnoreCase(s)) {
            return AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (AudioFormat.Encoding.ALAW.toString().equalsIgnoreCase(s)) {
            return AudioFormat.Encoding.ALAW;
        }
        if (AudioFormat.Encoding.ULAW.toString().equalsIgnoreCase(s)) {
            return AudioFormat.Encoding.ULAW;
        }
        return null;
    }

    public static AudioFormat parseAudioFormatProperties(Properties props, String keyPrefix) {
        AudioFormat.Encoding encoding = null;
        float frameRate = -1.0f;
        int channels = -1;
        int bits = -1;
        boolean bigEndian = false;
        String s = props.getProperty(keyPrefix + "encoding");
        if (s != null && s.length() > 0) {
            encoding = AbstractAudioFormatControl.parseEncoding(s);
        }
        if ((s = props.getProperty(keyPrefix + "frameRate")) != null && s.length() > 0) {
            frameRate = Float.parseFloat(s.trim());
        }
        if ((s = props.getProperty(keyPrefix + "channels")) != null && s.length() > 0) {
            channels = Integer.parseInt(s.trim());
        }
        if ((s = props.getProperty(keyPrefix + "bitDepth")) != null && s.length() > 0) {
            bits = Integer.parseInt(s.trim());
        }
        if ((s = props.getProperty(keyPrefix + "bigEndian")) != null && s.length() > 0) {
            bigEndian = "true".equalsIgnoreCase(s.trim());
        }
        if (frameRate <= 0.0f || channels < 1 || bits < 1) {
            return null;
        }
        if (encoding == null) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        }
        float sampleRate = frameRate;
        int frameSize = (channels * bits + 7) / 8;
        return new AudioFormat(encoding, sampleRate, bits, channels, frameSize, frameRate, bigEndian);
    }

    public static boolean isAudioFormatEqual(AudioFormat format1, AudioFormat format2) {
        AudioFormat.Encoding enc2;
        if (format1 == null) {
            return format2 == null;
        }
        if (format2 == null) {
            return false;
        }
        if (format1.getClass() != format2.getClass()) {
            return false;
        }
        if (format1.getEncoding() != format2.getEncoding()) {
            return false;
        }
        AudioFormat.Encoding enc1 = format1.getEncoding();
        if (enc1 != (enc2 = format2.getEncoding())) {
            return false;
        }
        if (format1.getFrameRate() != format2.getFrameRate()) {
            return false;
        }
        if (format1.getChannels() != format2.getChannels()) {
            return false;
        }
        if (format1.getSampleSizeInBits() != format2.getSampleSizeInBits()) {
            return false;
        }
        if (format1.getFrameSize() != format2.getFrameSize()) {
            return false;
        }
        if (format1.getSampleRate() != format2.getSampleRate()) {
            return false;
        }
        return format1.isBigEndian() == format2.isBigEndian();
    }

    @Override
    public Object getValue() {
        return this.audioFormat;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setAudioFormat(null);
            return;
        }
        if (value instanceof AudioFormat) {
            this.setAudioFormat((AudioFormat)value);
            return;
        }
        throw new UnsupportedOperationException("Parse audio format: " + value);
    }

    @Override
    public boolean isValueSupported(Object value) {
        if (value == null) {
            this.setAudioFormat(null);
            return true;
        }
        if (value instanceof AudioFormat) {
            this.setAudioFormat((AudioFormat)value);
            return true;
        }
        return false;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        AudioFormat oldFormat = this.audioFormat;
        if (oldFormat == null ? audioFormat == null : AbstractAudioFormatControl.isAudioFormatEqual(oldFormat, audioFormat)) {
            return;
        }
        this.audioFormat = audioFormat;
        this.applyAudioFormat(audioFormat);
        this.fireControlChanged();
    }

    protected abstract void applyAudioFormat(AudioFormat var1);

    @Override
    public Object[] getValues() {
        return this.getAudioFormats();
    }

    @Override
    public AudioFormat[] getAudioFormats() {
        int num = this.audioFormats == null ? 0 : this.audioFormats.length;
        AudioFormat[] formats = new AudioFormat[num];
        if (num > 0) {
            System.arraycopy(this.audioFormats, 0, formats, 0, num);
        }
        return formats;
    }

    protected void setAudioFormats(AudioFormat[] audioFormats) {
        this.audioFormats = audioFormats;
    }

    @Override
    public boolean isAudioFormatSupported(AudioFormat format) {
        return true;
    }
}

