/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.control.AbstractControl;
import com.spacekiller.util.media.control.DoubleControl;

public abstract class AbstractDoubleControl
extends AbstractControl
implements DoubleControl {
    private double value;
    private double minimum;
    private double maximum;

    @Override
    public Object getValue() {
        return Data.toDouble((double)this.value);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof Number) {
            this.setDouble(((Number)value).doubleValue());
            return;
        }
        String s = value.toString();
        double v = Double.parseDouble(s);
        this.setDouble(v);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public synchronized void setDouble(double v) {
        if (v < this.minimum) {
            v = this.minimum;
        }
        if (v > this.maximum) {
            v = this.maximum;
        }
        if (this.value == v) {
            return;
        }
        this.value = v;
        this.applyDouble(v);
        this.fireControlChanged();
    }

    protected abstract void applyDouble(double var1);

    @Override
    public double getMinimum() {
        return this.minimum;
    }

    protected void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    protected void setMaximum(double maximum) {
        this.maximum = maximum;
    }
}

