/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.AbstractControl;
import com.spacekiller.util.media.control.EnumControl;

public abstract class AbstractEnumControl
extends AbstractControl
implements EnumControl {
    private Object value;
    private Object[] values;

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(Object v) {
        if (!this.isValueSupported(v)) {
            throw new IllegalArgumentException("Value is not supported: " + this.value);
        }
        Object old = this.value;
        if (old == v) {
            return;
        }
        this.value = v;
        this.applyValue(v);
        this.fireControlChanged();
    }

    @Override
    public Object[] getValues() {
        Object[] arr = this.values;
        int n = arr == null ? 0 : arr.length;
        Object[] copy = new Object[n];
        if (n > 0) {
            System.arraycopy(arr, 0, copy, 0, n);
        }
        return copy;
    }

    @Override
    public boolean isValueSupported(Object value) {
        block4: {
            Object[] arr = this.values;
            if (arr == null) break block4;
            if (value == null) {
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i] != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    if (!value.equals(arr[i])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void setValues(Object[] values) {
        this.values = values;
    }

    protected abstract void applyValue(Object var1);
}

