/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.AbstractControl;
import com.spacekiller.util.media.control.FileControl;
import java.io.File;

public abstract class AbstractFileControl
extends AbstractControl
implements FileControl {
    private File file;

    @Override
    public Object getValue() {
        return this.file;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setFile(null);
            return;
        }
        if (value instanceof File) {
            this.setFile((File)value);
            return;
        }
        String path = value.toString();
        this.setFile(new File(path));
    }

    @Override
    public String getPath() {
        File f = this.file;
        return f == null ? null : f.getPath();
    }

    @Override
    public void setPath(String path) {
        File f = path == null ? null : new File(path);
        this.setFile(f);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public synchronized void setFile(File file) {
        File oldFile = this.file;
        if (oldFile == null ? file == null : oldFile.equals(file)) {
            return;
        }
        this.file = file;
        this.applyFile(file);
        this.fireControlChanged();
    }

    protected abstract void applyFile(File var1);
}

