/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.control.AbstractControl;
import com.spacekiller.util.media.control.FloatControl;

public abstract class AbstractFloatControl
extends AbstractControl
implements FloatControl {
    private float value;
    private float minimum;
    private float maximum;

    @Override
    public Object getValue() {
        return Data.toFloat((float)this.value);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof Number) {
            this.setFloat(((Number)value).floatValue());
            return;
        }
        String s = value.toString();
        float v = Float.parseFloat(s);
        this.setFloat(v);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public synchronized void setFloat(float v) {
        if (v < this.minimum) {
            v = this.minimum;
        }
        if (v > this.maximum) {
            v = this.maximum;
        }
        if (this.value == v) {
            return;
        }
        this.value = v;
        this.applyFloat(v);
        this.fireControlChanged();
    }

    protected abstract void applyFloat(float var1);

    @Override
    public float getMinimum() {
        return this.minimum;
    }

    protected void setMinimum(float minimum) {
        this.minimum = minimum;
    }

    @Override
    public float getMaximum() {
        return this.maximum;
    }

    protected void setMaximum(float maximum) {
        this.maximum = maximum;
    }
}

