/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.control.AbstractControl;
import com.spacekiller.util.media.control.IntControl;

public abstract class AbstractIntControl
extends AbstractControl
implements IntControl {
    private int value;
    private int minimum;
    private int maximum;

    @Override
    public Object getValue() {
        return Data.toInteger((int)this.value);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof Number) {
            this.setInt(((Number)value).intValue());
            return;
        }
        String s = value.toString();
        int v = Integer.parseInt(s);
        this.setInt(v);
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public synchronized void setInt(int v) {
        if (v < this.minimum) {
            v = this.minimum;
        }
        if (v > this.maximum) {
            v = this.maximum;
        }
        if (this.value == v) {
            return;
        }
        this.value = v;
        this.applyInt(v);
        this.fireControlChanged();
    }

    protected abstract void applyInt(int var1);

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    protected void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    protected void setMaximum(int maximum) {
        this.maximum = maximum;
    }
}

