/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import com.spacekiller.util.media.control.AudioFormatControl;
import com.spacekiller.util.media.control.AudioFormatSettingsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AudioFormatControlPanel
extends JPanel {
    private static final long serialVersionUID = -2542911717950910131L;
    private AudioFormatControl audioFormatControl;
    private boolean refreshing;
    private JComboBox jComboBoxAudioFormat = null;
    private JButton jButtonSettings = null;

    public AudioFormatControlPanel() {
        this.initialize();
        this.initAudioFormatControlPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJComboBoxAudioFormat(), gridBagConstraints);
        this.add((Component)this.getJButtonSettings(), gridBagConstraints1);
    }

    private JComboBox getJComboBoxAudioFormat() {
        if (this.jComboBoxAudioFormat == null) {
            this.jComboBoxAudioFormat = new JComboBox();
            this.jComboBoxAudioFormat.setOpaque(false);
            this.jComboBoxAudioFormat.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!AudioFormatControlPanel.this.refreshing) {
                        AudioFormatControlPanel.this.applyAudioFormat();
                    }
                }
            });
        }
        return this.jComboBoxAudioFormat;
    }

    private JButton getJButtonSettings() {
        if (this.jButtonSettings == null) {
            this.jButtonSettings = new JButton();
            this.jButtonSettings.setToolTipText("Settings");
            this.jButtonSettings.setIcon(new ImageIcon(AudioFormatControlPanel.class.getResource("/com/spacekiller/util/media/control/icons/button-settings.gif")));
            this.jButtonSettings.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioFormatControlPanel.this.showSettingsDialog();
                }
            });
        }
        return this.jButtonSettings;
    }

    protected void initAudioFormatControlPanel() {
    }

    public AudioFormatControl getAudioFormatControl() {
        return this.audioFormatControl;
    }

    public synchronized void setAudioFormatControl(AudioFormatControl audioFormatControl) {
        this.audioFormatControl = audioFormatControl;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            this.getJComboBoxAudioFormat().removeAllItems();
            if (this.audioFormatControl != null) {
                AudioFormat format = this.audioFormatControl.getAudioFormat();
                AudioFormat[] formats = this.audioFormatControl.getAudioFormats();
                for (int i = 0; i < formats.length; ++i) {
                    this.getJComboBoxAudioFormat().addItem(formats[i]);
                }
                this.setSelectedAudioFormat(format);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public AudioFormat getSelectedAudioFormat() {
        return (AudioFormat)this.getJComboBoxAudioFormat().getSelectedItem();
    }

    protected void setSelectedAudioFormat(AudioFormat format) {
        if (format == null) {
            this.getJComboBoxAudioFormat().setSelectedIndex(-1);
            return;
        }
        int n = this.getJComboBoxAudioFormat().getItemCount();
        int index = -1;
        for (int i = 0; i < n; ++i) {
            AudioFormat af = (AudioFormat)this.jComboBoxAudioFormat.getItemAt(i);
            if (!AbstractAudioFormatControl.isAudioFormatEqual(format, af)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            index = n;
            this.jComboBoxAudioFormat.addItem(format);
        }
        this.jComboBoxAudioFormat.setSelectedIndex(index);
    }

    protected void applyAudioFormat() {
        if (this.audioFormatControl == null) {
            return;
        }
        AudioFormat format = this.getSelectedAudioFormat();
        if (format == null) {
            return;
        }
        this.audioFormatControl.setAudioFormat(format);
    }

    public void showSettingsDialog() {
        AudioFormat format = this.getSelectedAudioFormat();
        AudioFormatSettingsPanel settingsPanel = new AudioFormatSettingsPanel();
        settingsPanel.setAudioFormat(format);
        AudioFormatSettingsPanel message = settingsPanel;
        String title = "Audio Format";
        int optionType = 2;
        int messageType = -1;
        Icon icon = null;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType, icon);
        if (rc != 0) {
            return;
        }
        format = settingsPanel.getAudioFormat();
        if (format == null) {
            return;
        }
        this.setSelectedAudioFormat(format);
    }
}

