/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.sound.sampled.AudioFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AudioFormatSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 3168058522771750560L;
    public static final String CHANNELS_MONO = "Mono";
    public static final String CHANNELS_STEREO = "Stereo";
    public static final String ORDER_LITTLE_ENDIAN = "Little Endian";
    public static final String ORDER_BIG_ENDIAN = "Big Endian";
    private AudioFormat audioFormat;
    private boolean refreshing;
    private JComboBox comboBoxFrameRate;
    private JComboBox comboBoxChannels;
    private JComboBox comboBoxEncoding;
    private JComboBox comboBoxBitDepth;
    private JComboBox comboBoxByteOrder;

    public AudioFormatSettingsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblFrameRate = new JLabel("Frame Rate:");
        GridBagConstraints gbc_lblFrameRate = new GridBagConstraints();
        gbc_lblFrameRate.anchor = 17;
        gbc_lblFrameRate.insets = new Insets(0, 0, 5, 5);
        gbc_lblFrameRate.gridx = 0;
        gbc_lblFrameRate.gridy = 0;
        this.add((Component)lblFrameRate, gbc_lblFrameRate);
        this.comboBoxFrameRate = new JComboBox();
        this.comboBoxFrameRate.setOpaque(false);
        this.comboBoxFrameRate.setEditable(true);
        this.comboBoxFrameRate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (!AudioFormatSettingsPanel.this.refreshing) {
                    AudioFormatSettingsPanel.this.apply();
                }
            }
        });
        this.comboBoxFrameRate.setToolTipText("Sample rate");
        GridBagConstraints gbc_comboBoxFrameRate = new GridBagConstraints();
        gbc_comboBoxFrameRate.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxFrameRate.fill = 2;
        gbc_comboBoxFrameRate.gridx = 1;
        gbc_comboBoxFrameRate.gridy = 0;
        this.add((Component)this.comboBoxFrameRate, gbc_comboBoxFrameRate);
        JLabel lblChannels = new JLabel("Channels:");
        GridBagConstraints gbc_lblChannels = new GridBagConstraints();
        gbc_lblChannels.anchor = 17;
        gbc_lblChannels.insets = new Insets(0, 0, 5, 5);
        gbc_lblChannels.gridx = 0;
        gbc_lblChannels.gridy = 2;
        this.add((Component)lblChannels, gbc_lblChannels);
        this.comboBoxChannels = new JComboBox();
        this.comboBoxChannels.setOpaque(false);
        this.comboBoxChannels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioFormatSettingsPanel.this.refreshing) {
                    AudioFormatSettingsPanel.this.apply();
                }
            }
        });
        this.comboBoxChannels.setToolTipText("Channels");
        GridBagConstraints gbc_comboBoxChannels = new GridBagConstraints();
        gbc_comboBoxChannels.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxChannels.fill = 2;
        gbc_comboBoxChannels.gridx = 1;
        gbc_comboBoxChannels.gridy = 2;
        this.add((Component)this.comboBoxChannels, gbc_comboBoxChannels);
        JLabel lblEncoding = new JLabel("Encoding:");
        GridBagConstraints gbc_lblEncoding = new GridBagConstraints();
        gbc_lblEncoding.anchor = 17;
        gbc_lblEncoding.insets = new Insets(0, 0, 5, 5);
        gbc_lblEncoding.gridx = 0;
        gbc_lblEncoding.gridy = 3;
        this.add((Component)lblEncoding, gbc_lblEncoding);
        this.comboBoxEncoding = new JComboBox();
        this.comboBoxEncoding.setOpaque(false);
        this.comboBoxEncoding.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioFormatSettingsPanel.this.refreshing) {
                    AudioFormatSettingsPanel.this.apply();
                }
            }
        });
        this.comboBoxEncoding.setToolTipText("Encoding");
        GridBagConstraints gbc_comboBoxEncoding = new GridBagConstraints();
        gbc_comboBoxEncoding.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxEncoding.fill = 2;
        gbc_comboBoxEncoding.gridx = 1;
        gbc_comboBoxEncoding.gridy = 3;
        this.add((Component)this.comboBoxEncoding, gbc_comboBoxEncoding);
        JLabel lblBitDepth = new JLabel("Bit Depth:");
        GridBagConstraints gbc_lblBitDepth = new GridBagConstraints();
        gbc_lblBitDepth.anchor = 17;
        gbc_lblBitDepth.insets = new Insets(0, 0, 5, 5);
        gbc_lblBitDepth.gridx = 0;
        gbc_lblBitDepth.gridy = 1;
        this.add((Component)lblBitDepth, gbc_lblBitDepth);
        this.comboBoxBitDepth = new JComboBox();
        this.comboBoxBitDepth.setOpaque(false);
        this.comboBoxBitDepth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioFormatSettingsPanel.this.refreshing) {
                    AudioFormatSettingsPanel.this.apply();
                }
            }
        });
        this.comboBoxBitDepth.setToolTipText("Bit depth");
        GridBagConstraints gbc_comboBoxBitDepth = new GridBagConstraints();
        gbc_comboBoxBitDepth.weightx = 1.0;
        gbc_comboBoxBitDepth.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxBitDepth.fill = 2;
        gbc_comboBoxBitDepth.gridx = 1;
        gbc_comboBoxBitDepth.gridy = 1;
        this.add((Component)this.comboBoxBitDepth, gbc_comboBoxBitDepth);
        JLabel lblByteOrder = new JLabel("Byte Order:");
        GridBagConstraints gbc_lblByteOrder = new GridBagConstraints();
        gbc_lblByteOrder.anchor = 17;
        gbc_lblByteOrder.insets = new Insets(0, 0, 0, 5);
        gbc_lblByteOrder.gridx = 0;
        gbc_lblByteOrder.gridy = 4;
        this.add((Component)lblByteOrder, gbc_lblByteOrder);
        this.comboBoxByteOrder = new JComboBox();
        this.comboBoxByteOrder.setOpaque(false);
        this.comboBoxByteOrder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioFormatSettingsPanel.this.refreshing) {
                    AudioFormatSettingsPanel.this.apply();
                }
            }
        });
        this.comboBoxByteOrder.setToolTipText("Byte order");
        GridBagConstraints gbc_comboBoxByteOrder = new GridBagConstraints();
        gbc_comboBoxByteOrder.fill = 2;
        gbc_comboBoxByteOrder.gridx = 1;
        gbc_comboBoxByteOrder.gridy = 4;
        this.add((Component)this.comboBoxByteOrder, gbc_comboBoxByteOrder);
        this.initAudioFormatSettingsPanel();
    }

    protected void initAudioFormatSettingsPanel() {
        float[] commonRates = AbstractAudioFormatControl.getCommonAudioFrameRates();
        for (int i = 0; i < commonRates.length; ++i) {
            this.comboBoxFrameRate.addItem(this.getFrameRateNumber(commonRates[i]));
        }
        this.comboBoxChannels.addItem(CHANNELS_MONO);
        this.comboBoxChannels.addItem(CHANNELS_STEREO);
        this.comboBoxEncoding.addItem(AudioFormat.Encoding.PCM_SIGNED);
        this.comboBoxEncoding.addItem(AudioFormat.Encoding.PCM_UNSIGNED);
        this.comboBoxEncoding.addItem(AudioFormat.Encoding.ALAW);
        this.comboBoxEncoding.addItem(AudioFormat.Encoding.ULAW);
        this.comboBoxBitDepth.addItem(Data.toInteger((int)16));
        this.comboBoxBitDepth.addItem(Data.toInteger((int)24));
        this.comboBoxBitDepth.addItem(Data.toInteger((int)32));
        this.comboBoxBitDepth.addItem(Data.toInteger((int)64));
        this.comboBoxByteOrder.addItem(ORDER_LITTLE_ENDIAN);
        this.comboBoxByteOrder.addItem(ORDER_BIG_ENDIAN);
    }

    protected Number getFrameRateNumber(float frameRate) {
        int intRate = (int)frameRate;
        if (frameRate == (float)intRate) {
            return Data.toInteger((int)intRate);
        }
        return Data.toFloat((float)frameRate);
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        float rate = AbstractAudioFormatControl.getDefaultAudioFrameRate();
        int channels = 2;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        int bits = 16;
        boolean bigEndian = false;
        AudioFormat format = this.audioFormat;
        if (format != null) {
            rate = format.getFrameRate();
            channels = format.getChannels();
            encoding = format.getEncoding();
            bits = format.getSampleSizeInBits();
            bigEndian = format.isBigEndian();
        }
        try {
            Object channelsItem;
            this.refreshing = true;
            int rateInt = (int)rate;
            Number rateItem = (float)rateInt == rate ? (Number)Data.toInteger((int)rateInt) : (Number)Data.toFloat((float)rate);
            this.comboBoxFrameRate.setSelectedItem(rateItem);
            switch (channels) {
                case 1: {
                    channelsItem = CHANNELS_MONO;
                    break;
                }
                case 2: {
                    channelsItem = CHANNELS_STEREO;
                    break;
                }
                default: {
                    channelsItem = Data.toInteger((int)channels);
                }
            }
            this.comboBoxChannels.setSelectedItem(channelsItem);
            this.comboBoxEncoding.setSelectedItem(encoding);
            this.comboBoxBitDepth.setSelectedItem(Data.toInteger((int)bits));
            String order = bigEndian ? ORDER_BIG_ENDIAN : ORDER_LITTLE_ENDIAN;
            this.comboBoxByteOrder.setSelectedItem(order);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        AudioFormat format;
        float rate;
        Object rateItem = this.comboBoxFrameRate.getSelectedItem();
        if (rateItem == null) {
            return;
        }
        float sampleRate = rate = Float.parseFloat(String.valueOf(rateItem));
        float frameRate = rate;
        Object channelsItem = this.comboBoxChannels.getSelectedItem();
        if (channelsItem == null) {
            return;
        }
        int channels = CHANNELS_MONO.equals(channelsItem) ? 1 : (CHANNELS_STEREO.equals(channelsItem) ? 2 : Integer.parseInt(String.valueOf(channelsItem)));
        AudioFormat.Encoding encoding = (AudioFormat.Encoding)this.comboBoxEncoding.getSelectedItem();
        if (encoding == null) {
            return;
        }
        Object bitDepth = this.comboBoxBitDepth.getSelectedItem();
        if (bitDepth == null) {
            return;
        }
        int bits = Integer.parseInt(String.valueOf(bitDepth));
        Object order = this.comboBoxByteOrder.getSelectedItem();
        boolean bigEndian = ORDER_BIG_ENDIAN.equals(order);
        int frameSize = (channels * bits + 7) / 8;
        this.audioFormat = format = new AudioFormat(encoding, sampleRate, bits, channels, frameSize, frameRate, bigEndian);
    }

    protected JComboBox getComboBoxFrameRate() {
        return this.comboBoxFrameRate;
    }

    protected JComboBox getComboBoxChannels() {
        return this.comboBoxChannels;
    }

    protected JComboBox getComboBoxEncoding() {
        return this.comboBoxEncoding;
    }

    protected JComboBox getComboBoxBitDepth() {
        return this.comboBoxBitDepth;
    }

    protected JComboBox getComboBoxByteOrder() {
        return this.comboBoxByteOrder;
    }
}

