/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.ControlListener;
import com.spacekiller.util.media.control.EnumControl;
import com.spacekiller.util.media.control.IntControl;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ComboBoxControlPanel
extends JPanel {
    private static final long serialVersionUID = -948576885011381969L;
    private Control control;
    private ControlHandler controlHandler = new ControlHandler();
    private boolean ignorePropertyChange;
    private ComboBoxUpdater comboBoxUpdater = new ComboBoxUpdater();
    private JComboBox comboBox;
    private ComboItemHandler comboItemHandler = new ComboItemHandler();
    private boolean ignoreComboChange;

    public ComboBoxControlPanel() {
        this.initComboBoxControlPanel();
    }

    private void initComboBoxControlPanel() {
        this.removeAll();
        this.setLayout(new GridLayout(1, 1));
        this.comboBox = new JComboBox();
        this.comboBox.setOpaque(false);
        this.comboBox.addItemListener(this.comboItemHandler);
        this.add(this.comboBox);
        this.refresh();
    }

    public Control getControl() {
        return this.control;
    }

    public synchronized void setControl(Control newControl) {
        if (this.control != newControl) {
            if (this.control != null) {
                this.control.removeControlListener(this.controlHandler);
            }
            this.control = newControl;
            if (this.control != null) {
                this.control.addControlListener(this.controlHandler);
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.ignoreComboChange = true;
            String name = null;
            String tooltip = null;
            Control ctrl = this.control;
            if (ctrl != null) {
                name = ctrl.getName();
                tooltip = ctrl.getTooltip();
            }
            if (name != null) {
                this.comboBox.setName(name);
            }
            this.comboBox.setToolTipText(tooltip);
        }
        finally {
            this.ignoreComboChange = false;
        }
        this.updateComboValue();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateComboValue() {
        Object value = null;
        Object[] values = null;
        Control ctrl = this.control;
        if (ctrl != null) {
            if (ctrl instanceof EnumControl) {
                EnumControl ec = (EnumControl)ctrl;
                value = ec.getValue();
                values = ec.getValues();
            } else if (ctrl instanceof IntControl) {
                IntControl ic = (IntControl)ctrl;
                value = ic.getValue();
                int min = ic.getMinimum();
                int max = ic.getMaximum();
                long total = max - min + 1;
                if (total > 0L && total < 256L) {
                    int num = (int)total;
                    values = new Object[num];
                    for (int i = 0; i < num; ++i) {
                        values[i] = Data.toInteger((int)(min + i));
                    }
                }
            }
        }
        try {
            this.ignoreComboChange = true;
            this.comboBox.removeAllItems();
            int num = values == null ? 0 : values.length;
            int sel = -1;
            for (int i = 0; i < num; ++i) {
                Object item = values[i];
                if (item == null) continue;
                if (item.equals(value)) {
                    sel = this.comboBox.getItemCount();
                }
                this.comboBox.addItem(item);
            }
            if (sel >= 0) {
                this.comboBox.setSelectedIndex(sel);
            } else if (value == null) {
                this.comboBox.setSelectedIndex(-1);
            } else {
                sel = this.comboBox.getItemCount();
                this.comboBox.addItem(value);
                this.comboBox.setSelectedIndex(sel);
            }
        }
        finally {
            this.ignoreComboChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyComboValue() {
        Control ctrl = this.control;
        if (ctrl == null) {
            return;
        }
        Object item = this.comboBox.getSelectedItem();
        try {
            this.ignorePropertyChange = true;
            if (ctrl instanceof EnumControl) {
                EnumControl ec = (EnumControl)ctrl;
                ec.setValue(item);
            } else if (ctrl instanceof IntControl) {
                IntControl ic = (IntControl)ctrl;
                ic.setValue(item);
            }
        }
        finally {
            this.ignorePropertyChange = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox.setEnabled(enabled);
    }

    protected class ComboItemHandler
    implements ItemListener {
        protected ComboItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ComboBoxControlPanel.this.ignoreComboChange) {
                return;
            }
            ComboBoxControlPanel.this.applyComboValue();
        }
    }

    protected class ComboBoxUpdater
    implements Runnable {
        protected ComboBoxUpdater() {
        }

        @Override
        public void run() {
            ComboBoxControlPanel.this.updateComboValue();
        }
    }

    protected class ControlHandler
    implements ControlListener {
        protected ControlHandler() {
        }

        @Override
        public void controlChanged(Control control) {
            if (ComboBoxControlPanel.this.ignorePropertyChange) {
                return;
            }
            SwingUtilities.invokeLater(ComboBoxControlPanel.this.comboBoxUpdater);
        }
    }
}

